/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.ComponentModuleRegistrationChecker;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0017J\b\u0010\u000e\u001a\u00020\u0005H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/idea/devkit/inspections/MoveRegistrationQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "myTargetModule", "Lcom/intellij/openapi/module/Module;", "myTargetFileName", "", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "intellij.devkit"})
public final class MoveRegistrationQuickFix
implements LocalQuickFix {
    private final Module myTargetModule;
    private final String myTargetFileName;

    @Nls
    @NotNull
    public String getName() {
        return "Move registration to " + this.myTargetFileName;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        return "Move registration to correct module";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        block8: {
            XmlTag tag;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
            XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlTag.class, (boolean)false);
            if (xmlTag == null) {
                return;
            }
            XmlTag xmlTag2 = tag = xmlTag;
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlTag2, (String)"tag");
            XmlTag xmlTag3 = xmlTag2.getParentTag();
            if (xmlTag3 == null) {
                return;
            }
            XmlTag parentTag = xmlTag3;
            XmlFile xmlFile = ComponentModuleRegistrationChecker.access$findModulePluginXmlFile(this.myTargetModule);
            if (xmlFile == null) {
                return;
            }
            XmlFile targetFile = xmlFile;
            XmlTag xmlTag4 = targetFile.getRootTag();
            if (xmlTag4 == null) {
                return;
            }
            XmlTag rootTag = xmlTag4;
            XmlTag xmlTag5 = tag.getParentTag();
            if (xmlTag5 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)xmlTag5, (String)"tag.parentTag!!");
            XmlTag[] subTags = rootTag.findSubTags(xmlTag5.getName());
            Intrinsics.checkExpressionValueIsNotNull((Object)subTags, (String)"subTags");
            XmlTag xmlTag6 = (XmlTag)ArraysKt.firstOrNull((Object[])subTags);
            if (xmlTag6 == null) {
                XmlTag xmlTag7;
                XmlTag xmlTag8 = parentTag;
                Intrinsics.checkExpressionValueIsNotNull((Object)xmlTag8, (String)"parentTag");
                XmlTag $receiver = xmlTag7 = rootTag.addSubTag(rootTag.createChildTag(xmlTag8.getLocalName(), "", null, false), false);
                XmlAttribute[] xmlAttributeArray = parentTag.getAttributes();
                int n = xmlAttributeArray.length;
                for (int i = 0; i < n; ++i) {
                    XmlAttribute attribute;
                    XmlAttribute xmlAttribute = attribute = xmlAttributeArray[i];
                    Intrinsics.checkExpressionValueIsNotNull((Object)xmlAttribute, (String)"attribute");
                    $receiver.setAttribute(xmlAttribute.getName(), attribute.getValue());
                }
                xmlTag6 = xmlTag7;
            }
            XmlTag newParentTag = xmlTag6;
            XmlTag newTag = newParentTag.addSubTag(tag, false);
            tag.delete();
            XmlTag xmlTag9 = newTag;
            if (!(xmlTag9 instanceof Navigatable)) {
                xmlTag9 = null;
            }
            Navigatable navigatable = (Navigatable)xmlTag9;
            if (navigatable == null) break block8;
            navigatable.navigate(true);
        }
    }

    public MoveRegistrationQuickFix(@NotNull Module myTargetModule, @NotNull String myTargetFileName) {
        Intrinsics.checkParameterIsNotNull((Object)myTargetModule, (String)"myTargetModule");
        Intrinsics.checkParameterIsNotNull((Object)myTargetFileName, (String)"myTargetFileName");
        this.myTargetModule = myTargetModule;
        this.myTargetFileName = myTargetFileName;
    }
}

