/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.utils;

import com.intellij.cdi.beans.AbstractCdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanPsiClassDescriptor;
import com.intellij.cdi.beans.CdiExtensionBeanDescriptor;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.events.CdiObserves;
import com.intellij.cdi.jam.inject.CdiInject;
import com.intellij.cdi.jam.lifecycle.CdiDispose;
import com.intellij.cdi.jam.producers.CdiProduces;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.model.CdiBeansXmlDomModelManager;
import com.intellij.cdi.model.CdiBeansXmlModel;
import com.intellij.cdi.model.xml.AlternativeClass;
import com.intellij.cdi.model.xml.Alternatives;
import com.intellij.cdi.model.xml.BeanDiscoveryMode;
import com.intellij.cdi.model.xml.Beans;
import com.intellij.cdi.model.xml.Exclude;
import com.intellij.cdi.model.xml.Scan;
import com.intellij.cdi.model.xml.StereotypeClass;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiManagedBeanValidationUtils;
import com.intellij.cdi.utils.CdiVersion;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiInjectionUtils {
    private static final List<String> ANNOTATIONS = Arrays.asList("javax.enterprise.event.Observes", "javax.enterprise.event.ObservesAsync", "javax.enterprise.inject.Disposes", "javax.decorator.Delegate");

    private CdiInjectionUtils() {
    }

    @NotNull
    public static Set<InjectionPointDescriptor> getInjectionPointOfType(@NotNull PsiType psiType, @NotNull CdiInject inject) {
        if (psiType == null) {
            CdiInjectionUtils.$$$reportNull$$$0(0);
        }
        if (inject == null) {
            CdiInjectionUtils.$$$reportNull$$$0(1);
        }
        HashSet ipsByType = ContainerUtil.newHashSet();
        List<InjectionPointDescriptor> injectionPoints = inject.getInjectionPoints();
        for (InjectionPointDescriptor descriptor : injectionPoints) {
            PsiType injectionPointType = descriptor.getType();
            if (injectionPointType == null || !injectionPointType.isAssignableFrom(psiType)) continue;
            ipsByType.add(descriptor);
        }
        HashSet hashSet = ipsByType;
        if (hashSet == null) {
            CdiInjectionUtils.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    public static List<InjectionPointDescriptor> getInjectionPoints(@NotNull PsiMethod method) {
        if (method == null) {
            CdiInjectionUtils.$$$reportNull$$$0(3);
        }
        LinkedList ips = ContainerUtil.newLinkedList();
        for (PsiParameter psiParameter : method.getParameterList().getParameters()) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, ANNOTATIONS, (int)0)) continue;
            ips.add(new InjectionPointDescriptor((PsiModifierListOwner)psiParameter));
        }
        return ips;
    }

    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull Module module) {
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(4);
        }
        return (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                CdiInjectionUtils.$$$reportNull$$$0(61);
            }
            Set<InjectionPointDescriptor> ips = CdiInjectionUtils.getInjectionPoints(module, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
            return CachedValueProvider.Result.create(ips, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        PsiMethod method;
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            CdiInjectionUtils.$$$reportNull$$$0(6);
        }
        HashSet<InjectionPointDescriptor> ips = new HashSet<InjectionPointDescriptor>();
        for (CdiInject inject : CdiJamModel.getModel(module).getInjects(scope)) {
            ips.addAll(inject.getInjectionPoints());
        }
        for (CdiProduces produces : CdiJamModel.getModel(module).getProduces(scope)) {
            ips.addAll(produces.getInjectionPoints());
        }
        for (CdiObserves observes : CdiJamModel.getModel(module).getObserves(scope)) {
            method = observes.getPsiMethod();
            if (method == null) continue;
            ips.addAll(CdiInjectionUtils.getInjectionPoints(method));
        }
        for (CdiDispose dispose : CdiJamModel.getModel(module).getDisposes(scope)) {
            method = dispose.getPsiMethod();
            if (method == null) continue;
            ips.addAll(CdiInjectionUtils.getInjectionPoints(method));
        }
        return ips;
    }

    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiInjectionUtils.$$$reportNull$$$0(7);
        }
        return (Set)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            if (psiClass == null) {
                CdiInjectionUtils.$$$reportNull$$$0(60);
            }
            HashSet ips = ContainerUtil.newHashSet();
            JamService service = JamService.getJamService((Project)psiClass.getProject());
            for (CdiInject inject : service.getAnnotatedMembersList(psiClass, CdiInject.SEM_KEY, true, true, true, true)) {
                ips.addAll(inject.getInjectionPoints());
            }
            for (CdiProduces produces : service.getAnnotatedMembersList(psiClass, CdiProduces.SEM_KEY, true, true, true, true)) {
                ips.addAll(produces.getInjectionPoints());
            }
            for (PsiMethod observesMethod : CdiCommonUtils.getObservesMethods(psiClass)) {
                ips.addAll(CdiInjectionUtils.getInjectionPoints(observesMethod));
            }
            for (PsiMethod disposerMethod : CdiCommonUtils.getDisposerMethods(psiClass)) {
                ips.addAll(CdiInjectionUtils.getInjectionPoints(disposerMethod));
            }
            return CachedValueProvider.Result.create(Collections.unmodifiableSet(ips), (Object[])new Object[]{psiClass});
        });
    }

    public static Set<InjectionPointDescriptor> getInjectionPoints(@NotNull PsiType psiType, @NotNull Set<InjectionPointDescriptor> ipd) {
        if (psiType == null) {
            CdiInjectionUtils.$$$reportNull$$$0(8);
        }
        if (ipd == null) {
            CdiInjectionUtils.$$$reportNull$$$0(9);
        }
        HashSet<InjectionPointDescriptor> result = new HashSet<InjectionPointDescriptor>();
        for (InjectionPointDescriptor descriptor : ipd) {
            PsiType injectionPointType = descriptor.getType();
            if (injectionPointType == null || !injectionPointType.isAssignableFrom(psiType)) continue;
            result.add(descriptor);
        }
        return result;
    }

    @NotNull
    public static Set<CdiBeanDescriptor> getInjectedBeans(@NotNull InjectionPointDescriptor ipd) {
        if (ipd == null) {
            CdiInjectionUtils.$$$reportNull$$$0(10);
        }
        Set<CdiBeanDescriptor> set = CdiInjectionUtils.getInjectedBeans(ipd, true, true, true);
        if (set == null) {
            CdiInjectionUtils.$$$reportNull$$$0(11);
        }
        return set;
    }

    @NotNull
    public static Set<CdiBeanDescriptor> getInjectedBeans(@NotNull InjectionPointDescriptor ipd, boolean checkVetoed, boolean checkDiscoveryMode, boolean checkExcludeFilters) {
        if (ipd == null) {
            CdiInjectionUtils.$$$reportNull$$$0(12);
        }
        Set<CdiBeanDescriptor> set = CdiInjectionUtils.getInjectedBeans(ipd.getOwner(), ipd.getType(), checkVetoed, checkDiscoveryMode, checkExcludeFilters);
        if (set == null) {
            CdiInjectionUtils.$$$reportNull$$$0(13);
        }
        return set;
    }

    public static Set<CdiBeanDescriptor> filterVetoedBeans(@NotNull Set<CdiBeanDescriptor> allBeans, @NotNull Module module) {
        if (allBeans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(14);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(15);
        }
        return allBeans.stream().filter(descriptor -> {
            if (module == null) {
                CdiInjectionUtils.$$$reportNull$$$0(59);
            }
            if (descriptor instanceof CdiExtensionBeanDescriptor) {
                return true;
            }
            PsiClass psiClass = CdiInjectionUtils.getContaingClass(descriptor);
            return psiClass != null && !CdiInjectionUtils.isVetoedClass(module, psiClass);
        }).collect(Collectors.toSet());
    }

    @NotNull
    public static Set<CdiBeanDescriptor> filterBeanDiscoveryMode(@NotNull Set<CdiBeanDescriptor> allBeans, @NotNull Module module) {
        if (allBeans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(16);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(17);
        }
        HashSet productionDescriptors = ContainerUtil.newHashSet();
        HashSet jarDescriptors = ContainerUtil.newHashSet();
        for (CdiBeanDescriptor bean : allBeans) {
            if (CdiInjectionUtils.isJarDescriptor(bean)) {
                jarDescriptors.add(bean);
                continue;
            }
            productionDescriptors.add(bean);
        }
        List<String> cdiBeansAnnotations = CdiCommonUtils.collectCdiBeansAnnotations(module);
        cdiBeansAnnotations.removeAll(CdiInjectionUtils.getNonScannedBeanDiscoveryModeAnnos());
        HashSet filtered = ContainerUtil.newHashSet();
        filtered.addAll(CdiInjectionUtils.filterProductionBeanDescriptors(productionDescriptors, module, cdiBeansAnnotations));
        filtered.addAll(CdiInjectionUtils.filterJarBeanDescriptors(jarDescriptors, cdiBeansAnnotations));
        HashSet hashSet = filtered;
        if (hashSet == null) {
            CdiInjectionUtils.$$$reportNull$$$0(18);
        }
        return hashSet;
    }

    @NotNull
    private static Set<CdiBeanDescriptor> filterJarBeanDescriptors(@NotNull Set<CdiBeanDescriptor> jarBeans, @NotNull Collection<String> cdiBeansAnnotations) {
        if (jarBeans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(19);
        }
        if (cdiBeansAnnotations == null) {
            CdiInjectionUtils.$$$reportNull$$$0(20);
        }
        HashSet filtered = ContainerUtil.newHashSet();
        for (CdiBeanDescriptor jarBean : jarBeans) {
            BeanDiscoveryMode discoveryMode = CdiInjectionUtils.getJarBeansDiscoveryMode(jarBean.getIdentifyingElement().getContainingFile());
            if (discoveryMode == BeanDiscoveryMode.NONE) continue;
            if (discoveryMode == BeanDiscoveryMode.ALL) {
                filtered.add(jarBean);
                continue;
            }
            if (discoveryMode != BeanDiscoveryMode.ANNOTATED || !CdiInjectionUtils.isAnnotatedToBeDiscovered(cdiBeansAnnotations, jarBean)) continue;
            filtered.add(jarBean);
        }
        HashSet hashSet = filtered;
        if (hashSet == null) {
            CdiInjectionUtils.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    @NotNull
    private static BeanDiscoveryMode getJarBeansDiscoveryMode(@Nullable PsiFile containingFile) {
        PsiFile file;
        VirtualFile root;
        VirtualFile beansXmlVF;
        VirtualFileSystem fileFileSystem;
        VirtualFile virtualFile;
        if (containingFile != null && (virtualFile = containingFile.getVirtualFile()) != null && (fileFileSystem = virtualFile.getFileSystem()) instanceof JarFileSystem && (beansXmlVF = (root = VfsUtil.getRootFile((VirtualFile)virtualFile)).findFileByRelativePath("META-INF/beans.xml")) != null && (file = containingFile.getManager().findFile(beansXmlVF)) instanceof XmlFile) {
            Beans beans = CdiInjectionUtils.getBeans(CdiBeansXmlDomModelManager.getInstance(containingFile.getProject()).getBeansXmlModel((XmlFile)file));
            BeanDiscoveryMode beanDiscoveryMode = CdiInjectionUtils.getBeansDiscoveryMode(beans);
            if (beanDiscoveryMode == null) {
                CdiInjectionUtils.$$$reportNull$$$0(22);
            }
            return beanDiscoveryMode;
        }
        BeanDiscoveryMode beanDiscoveryMode = BeanDiscoveryMode.ANNOTATED;
        if (beanDiscoveryMode == null) {
            CdiInjectionUtils.$$$reportNull$$$0(23);
        }
        return beanDiscoveryMode;
    }

    @NotNull
    public static Set<CdiBeanDescriptor> filterProductionBeanDescriptors(@NotNull Set<CdiBeanDescriptor> allBeans, @NotNull Module module, @NotNull Collection<String> cdiBeansAnnotations) {
        if (allBeans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(24);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(25);
        }
        if (cdiBeansAnnotations == null) {
            CdiInjectionUtils.$$$reportNull$$$0(26);
        }
        if (allBeans.isEmpty()) {
            Set<CdiBeanDescriptor> set = allBeans;
            if (set == null) {
                CdiInjectionUtils.$$$reportNull$$$0(27);
            }
            return set;
        }
        BeanDiscoveryMode value = CdiInjectionUtils.getBeanDiscoveryMode(module);
        if (value == BeanDiscoveryMode.NONE) {
            Set<CdiBeanDescriptor> set = Collections.emptySet();
            if (set == null) {
                CdiInjectionUtils.$$$reportNull$$$0(28);
            }
            return set;
        }
        if (value == BeanDiscoveryMode.ALL) {
            Set<CdiBeanDescriptor> set = allBeans;
            if (set == null) {
                CdiInjectionUtils.$$$reportNull$$$0(29);
            }
            return set;
        }
        HashSet filtered = ContainerUtil.newHashSet();
        for (CdiBeanDescriptor beanDescriptor : allBeans) {
            if (!CdiInjectionUtils.isAnnotatedToBeDiscovered(cdiBeansAnnotations, beanDescriptor)) continue;
            filtered.add(beanDescriptor);
        }
        HashSet hashSet = filtered;
        if (hashSet == null) {
            CdiInjectionUtils.$$$reportNull$$$0(30);
        }
        return hashSet;
    }

    public static boolean isAnnotatedToBeDiscovered(@NotNull Collection<String> cdiBeansAnnotations, CdiBeanDescriptor beanDescriptor) {
        Object identifyingElement;
        if (cdiBeansAnnotations == null) {
            CdiInjectionUtils.$$$reportNull$$$0(31);
        }
        if ((identifyingElement = beanDescriptor.getIdentifyingElement()) instanceof PsiMember && AnnotationUtil.findAnnotations((PsiModifierListOwner)((PsiModifierListOwner)identifyingElement), cdiBeansAnnotations).length > 0) {
            return true;
        }
        return identifyingElement instanceof PsiClass && (CdiManagedBeanValidationUtils.isEjbBean((PsiClass)identifyingElement) || CdiManagedBeanValidationUtils.isJpaEntity((PsiClass)identifyingElement));
    }

    private static boolean isJarDescriptor(CdiBeanDescriptor bean) {
        PsiFile file = bean.getIdentifyingElement().getContainingFile();
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile != null && virtualFile.getFileSystem() instanceof JarFileSystem;
    }

    private static Collection<String> getNonScannedBeanDiscoveryModeAnnos() {
        return Collections.singleton("javax.inject.Named");
    }

    @NotNull
    public static BeanDiscoveryMode getBeanDiscoveryMode(@NotNull Module module) {
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(32);
        }
        Beans xml = CdiInjectionUtils.getBeansXml(module);
        BeanDiscoveryMode beanDiscoveryMode = CdiInjectionUtils.getBeansDiscoveryMode(xml);
        if (beanDiscoveryMode == null) {
            CdiInjectionUtils.$$$reportNull$$$0(33);
        }
        return beanDiscoveryMode;
    }

    @NotNull
    public static BeanDiscoveryMode getBeansDiscoveryMode(@Nullable Beans beans) {
        if (beans != null) {
            if (DomUtil.hasXml(beans.getBeanDiscoveryMode())) {
                BeanDiscoveryMode discoveryMode = (BeanDiscoveryMode)((Object)beans.getBeanDiscoveryMode().getValue());
                if (discoveryMode != null) {
                    BeanDiscoveryMode beanDiscoveryMode = discoveryMode;
                    if (beanDiscoveryMode == null) {
                        CdiInjectionUtils.$$$reportNull$$$0(34);
                    }
                    return beanDiscoveryMode;
                }
                BeanDiscoveryMode beanDiscoveryMode = BeanDiscoveryMode.ANNOTATED;
                if (beanDiscoveryMode == null) {
                    CdiInjectionUtils.$$$reportNull$$$0(35);
                }
                return beanDiscoveryMode;
            }
            if (!DomUtil.hasXml(beans.getVersion())) {
                BeanDiscoveryMode beanDiscoveryMode = BeanDiscoveryMode.ALL;
                if (beanDiscoveryMode == null) {
                    CdiInjectionUtils.$$$reportNull$$$0(36);
                }
                return beanDiscoveryMode;
            }
        }
        BeanDiscoveryMode beanDiscoveryMode = BeanDiscoveryMode.ALL;
        if (beanDiscoveryMode == null) {
            CdiInjectionUtils.$$$reportNull$$$0(37);
        }
        return beanDiscoveryMode;
    }

    @NotNull
    public static Set<CdiBeanDescriptor> filterScanExcludedBeans(@NotNull Set<CdiBeanDescriptor> allBeans, @NotNull Module module) {
        Beans beans;
        if (allBeans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(38);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(39);
        }
        if ((beans = CdiInjectionUtils.getBeansXml(module)) != null) {
            com.intellij.util.containers.hash.HashSet patterns = new com.intellij.util.containers.hash.HashSet();
            for (Scan scan : beans.getScans()) {
                for (Exclude exclude : scan.getExcludes()) {
                    String text = exclude.getName().getRawText();
                    if (text == null) continue;
                    try {
                        String regexp = FileUtil.convertAntToRegexp((String)text);
                        patterns.add(Pattern.compile(regexp));
                    }
                    catch (PatternSyntaxException patternSyntaxException) {}
                }
            }
            if (patterns.size() != 0) {
                com.intellij.util.containers.hash.HashSet filtered = new com.intellij.util.containers.hash.HashSet();
                for (CdiBeanDescriptor descriptor : allBeans) {
                    PsiClass psiClass = CdiInjectionUtils.getContaingClass(descriptor);
                    if (psiClass == null || CdiInjectionUtils.isExcludeClass((Set<Pattern>)patterns, psiClass)) continue;
                    filtered.add(descriptor);
                }
                com.intellij.util.containers.hash.HashSet hashSet = filtered;
                if (hashSet == null) {
                    CdiInjectionUtils.$$$reportNull$$$0(40);
                }
                return hashSet;
            }
        }
        Set<CdiBeanDescriptor> set = allBeans;
        if (set == null) {
            CdiInjectionUtils.$$$reportNull$$$0(41);
        }
        return set;
    }

    private static PsiClass getContaingClass(CdiBeanDescriptor descriptor) {
        Object identifyingElement = descriptor.getIdentifyingElement();
        if (identifyingElement instanceof PsiClass) {
            return (PsiClass)identifyingElement;
        }
        return identifyingElement instanceof PsiMember ? ((PsiMember)identifyingElement).getContainingClass() : null;
    }

    private static boolean isExcludeClass(Set<Pattern> patterns, PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName != null) {
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(qualifiedName).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canBeInjected(@NotNull PsiClass psiClass, @NotNull Module module) {
        if (psiClass == null) {
            CdiInjectionUtils.$$$reportNull$$$0(42);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(43);
        }
        if (!CdiInjectionUtils.isManagedBean(psiClass)) {
            return false;
        }
        if (CdiInjectionUtils.isVetoedClass(module, psiClass)) {
            return false;
        }
        Set<CdiBeanDescriptor> descriptors = Collections.singleton(CdiDescriptorsFactory.createCdiBeanDescriptor(psiClass));
        return CdiInjectionUtils.filterDescriptors(module, descriptors, true, true, true).size() > 0;
    }

    public static boolean isManagedBean(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiInjectionUtils.$$$reportNull$$$0(44);
        }
        return !CdiManagedBeanValidationUtils.isParameterizedType(psiClass) && (CdiManagedBeanValidationUtils.isConcreteClass(psiClass) || CdiManagedBeanValidationUtils.isDecoratorClass(psiClass)) && !CdiManagedBeanValidationUtils.isNonStaticInner(psiClass);
    }

    @Nullable
    private static Beans getBeansXml(@NotNull Module module) {
        List<CdiBeansXmlModel> models;
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(45);
        }
        if ((models = CdiBeansXmlDomModelManager.getInstance(module.getProject()).getAllModels(module)).size() == 1) {
            return CdiInjectionUtils.getBeans(models.iterator().next());
        }
        return null;
    }

    @Nullable
    private static Beans getBeans(@Nullable CdiBeansXmlModel beansXmlModel) {
        if (beansXmlModel == null) {
            return null;
        }
        List roots = beansXmlModel.getRoots();
        return roots.size() == 1 ? (Beans)((DomFileElement)roots.get(0)).getRootElement() : null;
    }

    public static boolean isVetoedClass(@NotNull Module module, @NotNull PsiClass psiClass) {
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(46);
        }
        if (psiClass == null) {
            CdiInjectionUtils.$$$reportNull$$$0(47);
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"javax.enterprise.inject.Vetoed", (int)1)) {
            return true;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        for (PsiPackage vetoedPackage : CdiCommonUtils.getVetoedPackages(module)) {
            if (!facade.isInPackage((PsiElement)psiClass, vetoedPackage)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Set<CdiBeanDescriptor> getInjectedBeans(@NotNull PsiModifierListOwner owner, PsiType type, boolean checkVetoed, boolean checkDiscoveryMode, boolean checkExcludeFilters) {
        Module module;
        if (owner == null) {
            CdiInjectionUtils.$$$reportNull$$$0(48);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)owner)) == null) {
            Set<CdiBeanDescriptor> set = Collections.emptySet();
            if (set == null) {
                CdiInjectionUtils.$$$reportNull$$$0(49);
            }
            return set;
        }
        Set<CdiBeanDescriptor> set = CdiInjectionUtils.filterDescriptors(module, CdiInjectionUtils.getInjectedBeans(owner, module, type), checkVetoed, checkDiscoveryMode, checkExcludeFilters);
        if (set == null) {
            CdiInjectionUtils.$$$reportNull$$$0(50);
        }
        return set;
    }

    private static Set<CdiBeanDescriptor> filterDescriptors(Module module, Set<CdiBeanDescriptor> allBeans, boolean checkVetoed, boolean checkDiscoveryMode, boolean checkExcludeFilters) {
        allBeans = CdiInjectionUtils.filterUnsatisfiedDescriptors(allBeans);
        allBeans = CdiInjectionUtils.chooseAlternatives(allBeans, module);
        if (checkVetoed) {
            allBeans = CdiInjectionUtils.filterVetoedBeans(allBeans, module);
        }
        if (checkDiscoveryMode) {
            allBeans = CdiInjectionUtils.filterBeanDiscoveryMode(allBeans, module);
        }
        if (checkExcludeFilters) {
            allBeans = CdiInjectionUtils.filterScanExcludedBeans(allBeans, module);
        }
        return allBeans;
    }

    private static Set<CdiBeanDescriptor> filterUnsatisfiedDescriptors(@NotNull Set<CdiBeanDescriptor> beans) {
        if (beans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(51);
        }
        return new LinkedHashSet<CdiBeanDescriptor>(ContainerUtil.filter(beans, descriptor -> CdiInjectionUtils.isLoadedInContainer(descriptor)));
    }

    private static boolean isLoadedInContainer(@NotNull CdiBeanDescriptor descriptor) {
        Module module;
        Object identifyingElement;
        if (descriptor == null) {
            CdiInjectionUtils.$$$reportNull$$$0(52);
        }
        if ((identifyingElement = descriptor.getIdentifyingElement()) != null && (module = ModuleUtilCore.findModuleForPsiElement(identifyingElement)) != null && CdiCommonUtils.isCdiInstalled(module, CdiVersion.CDI_1_1) && CdiBeansXmlDomModelManager.getInstance(module.getProject()).getAllModels(module).isEmpty()) {
            return CdiCommonUtils.hasImplicitArchive(module);
        }
        return true;
    }

    @NotNull
    private static Set<CdiBeanDescriptor> chooseAlternatives(@NotNull Set<CdiBeanDescriptor> allBeans, @NotNull Module module) {
        Beans beans;
        if (allBeans == null) {
            CdiInjectionUtils.$$$reportNull$$$0(53);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(54);
        }
        com.intellij.util.containers.hash.HashSet alternatives = new com.intellij.util.containers.hash.HashSet();
        com.intellij.util.containers.hash.HashSet nonAlternatives = new com.intellij.util.containers.hash.HashSet();
        for (CdiBeanDescriptor descriptor : allBeans) {
            Object annotatedItem;
            if (descriptor instanceof AbstractCdiBeanDescriptor && CdiCommonUtils.isAlternativeAnnotated(annotatedItem = ((AbstractCdiBeanDescriptor)descriptor).getAnnotatedItem())) {
                alternatives.add((AbstractCdiBeanDescriptor)descriptor);
                continue;
            }
            nonAlternatives.add(descriptor);
        }
        if (alternatives.size() > 0 && (beans = CdiInjectionUtils.getBeansXml(module)) != null) {
            com.intellij.util.containers.hash.HashSet result = new com.intellij.util.containers.hash.HashSet();
            for (Alternatives definedAlternatives : beans.getAlternativeses()) {
                for (AlternativeClass alternativeClass : definedAlternatives.getClasses()) {
                    String alternativeClassFQN = alternativeClass.getStringValue();
                    if (StringUtil.isEmptyOrSpaces((String)alternativeClassFQN)) continue;
                    for (CdiBeanDescriptor beanDescriptor : alternatives) {
                        PsiClass psiClass;
                        if (beanDescriptor instanceof CdiExtensionBeanDescriptor || (psiClass = beanDescriptor instanceof CdiBeanPsiClassDescriptor ? ((CdiBeanPsiClassDescriptor)beanDescriptor).getAnnotatedItem() : ((AbstractCdiBeanDescriptor)beanDescriptor).getAnnotatedItem().getContainingClass()) == null || !alternativeClassFQN.equals(psiClass.getQualifiedName())) continue;
                        result.add(beanDescriptor);
                    }
                }
                for (StereotypeClass stereotypeClass : definedAlternatives.getStereotypes()) {
                    String stereotypeClassValue = stereotypeClass.getStringValue();
                    if (stereotypeClassValue == null) continue;
                    for (CdiBeanDescriptor beanDescriptor : alternatives) {
                        Object psiMember = ((AbstractCdiBeanDescriptor)beanDescriptor).getAnnotatedItem();
                        if (!AnnotationUtil.isAnnotated(psiMember, (String)stereotypeClassValue, (int)0)) continue;
                        result.add(beanDescriptor);
                    }
                }
            }
            if (result.size() > 0) {
                com.intellij.util.containers.hash.HashSet hashSet = result;
                if (hashSet == null) {
                    CdiInjectionUtils.$$$reportNull$$$0(55);
                }
                return hashSet;
            }
        }
        com.intellij.util.containers.hash.HashSet hashSet = nonAlternatives;
        if (hashSet == null) {
            CdiInjectionUtils.$$$reportNull$$$0(56);
        }
        return hashSet;
    }

    public static Set<CdiBeanDescriptor> getInjectedBeans(@NotNull PsiModifierListOwner psiMember, @NotNull Module module, PsiType type) {
        if (psiMember == null) {
            CdiInjectionUtils.$$$reportNull$$$0(57);
        }
        if (module == null) {
            CdiInjectionUtils.$$$reportNull$$$0(58);
        }
        return CdiManager.getService(module).resolveBeanByType(psiMember, module, type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 49: 
            case 50: 
            case 55: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 49: 
            case 50: 
            case 55: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inject";
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 49: 
            case 50: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/utils/CdiInjectionUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 5: 
            case 15: 
            case 17: 
            case 25: 
            case 32: 
            case 39: 
            case 43: 
            case 45: 
            case 46: 
            case 54: 
            case 58: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 42: 
            case 44: 
            case 47: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ipd";
                break;
            }
            case 14: 
            case 16: 
            case 24: 
            case 38: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allBeans";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarBeans";
                break;
            }
            case 20: 
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cdiBeansAnnotations";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/utils/CdiInjectionUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectionPointOfType";
                break;
            }
            case 11: 
            case 13: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedBeans";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "filterBeanDiscoveryMode";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "filterJarBeanDescriptors";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarBeansDiscoveryMode";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "filterProductionBeanDescriptors";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanDiscoveryMode";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeansDiscoveryMode";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "filterScanExcludedBeans";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseAlternatives";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionPointOfType";
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 49: 
            case 50: 
            case 55: 
            case 56: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionPoints";
                break;
            }
            case 10: 
            case 12: 
            case 48: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedBeans";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterVetoedBeans";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "filterBeanDiscoveryMode";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "filterJarBeanDescriptors";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "filterProductionBeanDescriptors";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatedToBeDiscovered";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getBeanDiscoveryMode";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "filterScanExcludedBeans";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "canBeInjected";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isManagedBean";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getBeansXml";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isVetoedClass";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "filterUnsatisfiedDescriptors";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isLoadedInContainer";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "chooseAlternatives";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$filterVetoedBeans$2";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getInjectionPoints$1";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getInjectionPoints$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: 
            case 13: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 49: 
            case 50: 
            case 55: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

