/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.ui;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.jediterm.terminal.HyperlinkStyle;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.StyledTextConsumer;
import com.jediterm.terminal.SubstringFinder;
import com.jediterm.terminal.TerminalDisplay;
import com.jediterm.terminal.TerminalOutputStream;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.emulator.ColorPalette;
import com.jediterm.terminal.emulator.charset.CharacterSets;
import com.jediterm.terminal.emulator.mouse.MouseMode;
import com.jediterm.terminal.emulator.mouse.TerminalMouseListener;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.LinesBuffer;
import com.jediterm.terminal.model.SelectionUtil;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalModelListener;
import com.jediterm.terminal.model.TerminalSelection;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.model.hyperlinks.LinkInfo;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionProvider;
import com.jediterm.terminal.ui.TerminalCoordinates;
import com.jediterm.terminal.ui.TerminalPanelListener;
import com.jediterm.terminal.ui.UIUtil;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import com.jediterm.terminal.util.CharUtils;
import com.jediterm.terminal.util.Pair;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.text.AttributedCharacterIterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TerminalPanel
extends JComponent
implements TerminalDisplay,
ClipboardOwner,
TerminalActionProvider {
    private static final Logger LOG = Logger.getLogger(TerminalPanel.class);
    private static final long serialVersionUID = -1048763516632093014L;
    public static final double SCROLL_SPEED = 0.05;
    private Font myNormalFont;
    private Font myItalicFont;
    private Font myBoldFont;
    private Font myBoldItalicFont;
    private int myDescent = 0;
    protected Dimension myCharSize = new Dimension();
    private boolean myMonospaced;
    protected Dimension myTermSize = new Dimension(80, 24);
    private TerminalStarter myTerminalStarter = null;
    private MouseMode myMouseMode = MouseMode.MOUSE_REPORTING_NONE;
    private Point mySelectionStartPoint = null;
    private TerminalSelection mySelection = null;
    private Clipboard mySelectionClipboard;
    private Clipboard myClipboard;
    private TerminalPanelListener myTerminalPanelListener;
    private SettingsProvider mySettingsProvider;
    private final TerminalTextBuffer myTerminalTextBuffer;
    private final StyleState myStyleState;
    private final TerminalCursor myCursor = new TerminalCursor();
    private final BoundedRangeModel myBoundedRangeModel = new DefaultBoundedRangeModel(0, 80, 0, 80);
    private boolean myScrollingEnabled = true;
    protected int myClientScrollOrigin;
    protected KeyListener myKeyListener;
    private String myWindowTitle = "Terminal";
    private TerminalActionProvider myNextActionProvider;
    private String myInputMethodUncommittedChars;
    private Timer myRepaintTimer;
    private AtomicInteger scrollDy = new AtomicInteger(0);
    private AtomicBoolean needRepaint = new AtomicBoolean(true);
    private int myMaxFPS = 50;
    private int myBlinkingPeriod = 500;
    private TerminalCoordinates myCoordsAccessor;
    private String myCurrentPath;
    private SubstringFinder.FindResult myFindResult;
    private LinkInfo myHoveredHyperlink = null;
    private int myCursorType = 0;

    public TerminalPanel(@NotNull SettingsProvider settingsProvider, @NotNull TerminalTextBuffer terminalTextBuffer, @NotNull StyleState styleState) {
        this.mySettingsProvider = settingsProvider;
        this.myTerminalTextBuffer = terminalTextBuffer;
        this.myStyleState = styleState;
        this.myTermSize.width = terminalTextBuffer.getWidth();
        this.myTermSize.height = terminalTextBuffer.getHeight();
        this.myMaxFPS = this.mySettingsProvider.maxRefreshRate();
        this.updateScrolling(true);
        this.enableEvents(2056L);
        this.enableInputMethods(true);
        terminalTextBuffer.addModelListener(new TerminalModelListener(){

            @Override
            public void modelChanged() {
                TerminalPanel.this.repaint();
            }
        });
    }

    @Override
    public void repaint() {
        this.needRepaint.set(true);
    }

    private void doRepaint() {
        super.repaint();
    }

    @Deprecated
    protected void reinitFontAndResize() {
        this.initFont();
        this.sizeTerminalFromComponent();
    }

    protected void initFont() {
        this.myNormalFont = this.createFont();
        this.myBoldFont = this.myNormalFont.deriveFont(1);
        this.myItalicFont = this.myNormalFont.deriveFont(2);
        this.myBoldItalicFont = this.myBoldFont.deriveFont(2);
        this.establishFontMetrics();
    }

    public void init() {
        this.initFont();
        this.setUpClipboard();
        this.setPreferredSize(new Dimension(this.getPixelWidth(), this.getPixelHeight()));
        this.setFocusable(true);
        this.enableInputMethods(true);
        this.setDoubleBuffered(true);
        this.setFocusTraversalKeysEnabled(false);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                TerminalPanel.this.handleHyperlinks(e.getPoint(), e.isControlDown());
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!TerminalPanel.this.isLocalMouseAction(e)) {
                    return;
                }
                Point charCoords = TerminalPanel.this.panelToCharCoords(e.getPoint());
                if (TerminalPanel.this.mySelection == null) {
                    if (TerminalPanel.this.mySelectionStartPoint == null) {
                        TerminalPanel.this.mySelectionStartPoint = charCoords;
                    }
                    TerminalPanel.this.mySelection = new TerminalSelection(new Point(TerminalPanel.this.mySelectionStartPoint));
                }
                TerminalPanel.this.repaint();
                TerminalPanel.this.mySelection.updateEnd(charCoords);
                if (TerminalPanel.this.mySettingsProvider.copyOnSelect()) {
                    TerminalPanel.this.handleCopyOnSelect();
                }
                if (e.getPoint().y < 0) {
                    TerminalPanel.this.moveScrollBar((int)((double)e.getPoint().y * 0.05));
                }
                if (e.getPoint().y > TerminalPanel.this.getPixelHeight()) {
                    TerminalPanel.this.moveScrollBar((int)((double)(e.getPoint().y - TerminalPanel.this.getPixelHeight()) * 0.05));
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (TerminalPanel.this.isLocalMouseAction(e)) {
                    int notches = e.getWheelRotation();
                    TerminalPanel.this.moveScrollBar(notches);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 1) {
                    TerminalPanel.this.mySelectionStartPoint = TerminalPanel.this.panelToCharCoords(e.getPoint());
                    TerminalPanel.this.mySelection = null;
                    TerminalPanel.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TerminalPanel.this.requestFocusInWindow();
                TerminalPanel.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TerminalPanel.this.requestFocusInWindow();
                HyperlinkStyle hyperlink = TerminalPanel.this.findHyperlink(e.getPoint());
                if (hyperlink != null && TerminalPanel.this.myCursorType == 12) {
                    hyperlink.run();
                } else if (e.getButton() == 1 && TerminalPanel.this.isLocalMouseAction(e)) {
                    int count = e.getClickCount();
                    if (count != 1) {
                        if (count == 2) {
                            Point charCoords = TerminalPanel.this.panelToCharCoords(e.getPoint());
                            Point start = SelectionUtil.getPreviousSeparator(charCoords, TerminalPanel.this.myTerminalTextBuffer);
                            Point stop = SelectionUtil.getNextSeparator(charCoords, TerminalPanel.this.myTerminalTextBuffer);
                            TerminalPanel.this.mySelection = new TerminalSelection(start);
                            TerminalPanel.this.mySelection.updateEnd(stop);
                            if (TerminalPanel.this.mySettingsProvider.copyOnSelect()) {
                                TerminalPanel.this.handleCopyOnSelect();
                            }
                        } else if (count == 3) {
                            int endLine;
                            int startLine;
                            Point charCoords = TerminalPanel.this.panelToCharCoords(e.getPoint());
                            for (startLine = charCoords.y; startLine > -TerminalPanel.this.getScrollBuffer().getLineCount() && TerminalPanel.this.myTerminalTextBuffer.getLine(startLine - 1).isWrapped(); --startLine) {
                            }
                            for (endLine = charCoords.y; endLine < TerminalPanel.this.myTerminalTextBuffer.getHeight() && TerminalPanel.this.myTerminalTextBuffer.getLine(endLine).isWrapped(); ++endLine) {
                            }
                            TerminalPanel.this.mySelection = new TerminalSelection(new Point(0, startLine));
                            TerminalPanel.this.mySelection.updateEnd(new Point(TerminalPanel.this.myTermSize.width, endLine));
                            if (TerminalPanel.this.mySettingsProvider.copyOnSelect()) {
                                TerminalPanel.this.handleCopyOnSelect();
                            }
                        }
                    }
                } else if (e.getButton() == 2 && TerminalPanel.this.mySettingsProvider.pasteOnMiddleMouseClick() && TerminalPanel.this.isLocalMouseAction(e)) {
                    TerminalPanel.this.handlePasteSelection();
                } else if (e.getButton() == 3) {
                    JPopupMenu popup = TerminalPanel.this.createPopupMenu();
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
                TerminalPanel.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TerminalPanel.this.sizeTerminalFromComponent();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TerminalPanel.this.myCursor.cursorChanged();
            }

            @Override
            public void focusLost(FocusEvent e) {
                TerminalPanel.this.myCursor.cursorChanged();
                TerminalPanel.this.handleHyperlinks(e.getComponent(), false);
            }
        });
        this.myBoundedRangeModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TerminalPanel.this.myClientScrollOrigin = TerminalPanel.this.myBoundedRangeModel.getValue();
                TerminalPanel.this.repaint();
            }
        });
        this.createRepaintTimer();
    }

    private void handleHyperlinks(Point p, boolean isControlDown) {
        HyperlinkStyle hyperlinkStyle = this.findHyperlink(p);
        if (hyperlinkStyle != null && (hyperlinkStyle.getHighlightMode() == HyperlinkStyle.HighlightMode.ALWAYS || hyperlinkStyle.getHighlightMode() == HyperlinkStyle.HighlightMode.HOVER && isControlDown)) {
            this.updateCursor(12);
            this.myHoveredHyperlink = hyperlinkStyle.getLinkInfo();
            return;
        }
        this.myHoveredHyperlink = null;
        if (this.myCursorType != 0) {
            this.updateCursor(0);
            this.repaint();
        }
    }

    private void handleHyperlinks(Component component, boolean controlDown) {
        PointerInfo a = MouseInfo.getPointerInfo();
        if (a != null) {
            Point b = a.getLocation();
            SwingUtilities.convertPointFromScreen(b, component);
            this.handleHyperlinks(b, controlDown);
        }
    }

    @Nullable
    private HyperlinkStyle findHyperlink(Point p) {
        TextStyle style;
        p = this.panelToCharCoords(p);
        if (p.x >= 0 && p.y >= 0 && p.x < this.myTerminalTextBuffer.getWidth() && p.y <= this.myTerminalTextBuffer.getHeight() && (style = this.myTerminalTextBuffer.getStyleAt(p.x, p.y)) instanceof HyperlinkStyle) {
            return (HyperlinkStyle)style;
        }
        return null;
    }

    private void updateCursor(int cursorType) {
        if (cursorType != this.myCursorType) {
            this.myCursorType = cursorType;
            this.setCursor(new Cursor(this.myCursorType));
        }
    }

    private void createRepaintTimer() {
        if (this.myRepaintTimer != null) {
            this.myRepaintTimer.stop();
        }
        this.myRepaintTimer = new Timer(1000 / this.myMaxFPS, new WeakRedrawTimer(this));
        this.myRepaintTimer.start();
    }

    public boolean isLocalMouseAction(MouseEvent e) {
        return this.mySettingsProvider.forceActionOnMouseReporting() || this.isMouseReporting() == e.isShiftDown();
    }

    public boolean isRemoteMouseAction(MouseEvent e) {
        return this.isMouseReporting() && !e.isShiftDown();
    }

    protected boolean isRetina() {
        return UIUtil.isRetina();
    }

    public void setBlinkingPeriod(int blinkingPeriod) {
        this.myBlinkingPeriod = blinkingPeriod;
    }

    public void setCoordAccessor(TerminalCoordinates coordAccessor) {
        this.myCoordsAccessor = coordAccessor;
    }

    public void setFindResult(SubstringFinder.FindResult findResult) {
        this.myFindResult = findResult;
        this.repaint();
    }

    public SubstringFinder.FindResult getFindResult() {
        return this.myFindResult;
    }

    public SubstringFinder.FindResult.FindItem selectPrevFindResultItem() {
        return this.selectPrevOrNextFindResultItem(false);
    }

    public SubstringFinder.FindResult.FindItem selectNextFindResultItem() {
        return this.selectPrevOrNextFindResultItem(true);
    }

    protected SubstringFinder.FindResult.FindItem selectPrevOrNextFindResultItem(boolean next) {
        if (this.myFindResult != null) {
            SubstringFinder.FindResult.FindItem item;
            SubstringFinder.FindResult.FindItem findItem = item = next ? this.myFindResult.nextFindItem() : this.myFindResult.prevFindItem();
            if (item != null) {
                this.mySelection = new TerminalSelection(new Point(item.getStart().x, item.getStart().y - this.myTerminalTextBuffer.getHistoryLinesCount()), new Point(item.getEnd().x, item.getEnd().y - this.myTerminalTextBuffer.getHistoryLinesCount()));
                if (this.mySelection.getStart().y < this.getTerminalTextBuffer().getHeight() / 2) {
                    this.myBoundedRangeModel.setValue(this.mySelection.getStart().y - this.getTerminalTextBuffer().getHeight() / 2);
                } else {
                    this.myBoundedRangeModel.setValue(0);
                }
                this.repaint();
                return item;
            }
        }
        return null;
    }

    @Override
    public void terminalMouseModeSet(MouseMode mode) {
        this.myMouseMode = mode;
    }

    private boolean isMouseReporting() {
        return this.myMouseMode != MouseMode.MOUSE_REPORTING_NONE;
    }

    private void scrollToBottom() {
        this.myBoundedRangeModel.setValue(this.myTermSize.height);
    }

    private void pageUp() {
        int val = this.myBoundedRangeModel.getValue() - this.myTermSize.height;
        this.myBoundedRangeModel.setValue(val >= this.myBoundedRangeModel.getMinimum() ? val : this.myBoundedRangeModel.getMinimum());
    }

    private void pageDown() {
        int val = this.myBoundedRangeModel.getValue() + this.myTermSize.height;
        this.myBoundedRangeModel.setValue(val <= this.myBoundedRangeModel.getMaximum() ? val : this.myBoundedRangeModel.getMaximum());
    }

    private void moveScrollBar(int k) {
        this.myBoundedRangeModel.setValue(this.myBoundedRangeModel.getValue() + k);
    }

    protected Font createFont() {
        return this.mySettingsProvider.getTerminalFont();
    }

    protected Point panelToCharCoords(Point p) {
        int x = Math.min(p.x / this.myCharSize.width, this.getColumnCount() - 1);
        x = Math.max(0, x);
        int y = Math.min(p.y / this.myCharSize.height, this.getRowCount() - 1) + this.myClientScrollOrigin;
        return new Point(x, y);
    }

    protected Point charToPanelCoords(Point p) {
        return new Point(p.x * this.myCharSize.width, (p.y - this.myClientScrollOrigin) * this.myCharSize.height);
    }

    void setUpClipboard() {
        this.mySelectionClipboard = Toolkit.getDefaultToolkit().getSystemSelection();
        if (this.mySelectionClipboard == null) {
            this.mySelectionClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        this.myClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    }

    protected void copySelection(Point selectionStart, Point selectionEnd, @NotNull Consumer<StringSelection> copyHandler) {
        if (selectionStart == null || selectionEnd == null) {
            return;
        }
        String selectionText = SelectionUtil.getSelectionText(selectionStart, selectionEnd, this.myTerminalTextBuffer);
        if (selectionText.length() != 0) {
            try {
                copyHandler.accept(new StringSelection(selectionText));
            }
            catch (IllegalStateException e) {
                LOG.error((Object)"Could not set clipboard:", (Throwable)e);
            }
        }
    }

    protected void setCopyContents(StringSelection selection) {
        this.myClipboard.setContents(selection, this);
    }

    protected void setCopySelectionContents(StringSelection selection) {
        if (this.mySelectionClipboard != null) {
            this.mySelectionClipboard.setContents(selection, this);
        }
    }

    protected void pasteFromClipboard(Supplier<String> clipboardStringSupplier) {
        String text = clipboardStringSupplier.get();
        if (text == null) {
            return;
        }
        try {
            if (!UIUtil.isWindows) {
                text = text.replace("\r\n", "\n");
            }
            text = text.replace('\n', '\r');
            this.myTerminalStarter.sendString(text);
        }
        catch (RuntimeException e) {
            LOG.info((Object)e);
        }
    }

    private String getClipboardString() {
        try {
            return this.getClipboardContent(this.myClipboard);
        }
        catch (Exception e) {
            LOG.info((Object)e);
            return null;
        }
    }

    private String getSelectionClipboardString() {
        try {
            if (this.mySelectionClipboard != null) {
                return this.getClipboardContent(this.mySelectionClipboard);
            }
            return this.getClipboardContent(this.myClipboard);
        }
        catch (Exception e) {
            LOG.info((Object)e);
            return null;
        }
    }

    protected String getClipboardContent(Clipboard clipboard) throws IOException, UnsupportedFlavorException {
        try {
            return (String)clipboard.getData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            LOG.info((Object)e);
            return null;
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    protected void drawImage(Graphics2D gfx, BufferedImage image, int x, int y, ImageObserver observer) {
        gfx.drawImage(image, x, y, image.getWidth(), image.getHeight(), observer);
    }

    protected BufferedImage createBufferedImage(int width, int height) {
        return new BufferedImage(width, height, 1);
    }

    private void sizeTerminalFromComponent() {
        if (this.myTerminalStarter != null) {
            int newWidth = this.getWidth() / this.myCharSize.width;
            int newHeight = this.getHeight() / this.myCharSize.height;
            if (newHeight > 0 && newWidth > 0) {
                Dimension newSize = new Dimension(newWidth, newHeight);
                this.myTerminalStarter.postResize(newSize, RequestOrigin.User);
            }
        }
    }

    public void setTerminalStarter(TerminalStarter terminalStarter) {
        this.myTerminalStarter = terminalStarter;
        this.sizeTerminalFromComponent();
    }

    public void setKeyListener(KeyListener keyListener) {
        this.myKeyListener = keyListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension requestResize(Dimension newSize, RequestOrigin origin, int cursorY, JediTerminal.ResizeHandler resizeHandler) {
        if (!newSize.equals(this.myTermSize)) {
            this.myTerminalTextBuffer.lock();
            try {
                this.myTerminalTextBuffer.resize(newSize, origin, cursorY, resizeHandler, this.mySelection);
                this.myTermSize = (Dimension)newSize.clone();
                Dimension pixelDimension = new Dimension(this.getPixelWidth(), this.getPixelHeight());
                this.setPreferredSize(pixelDimension);
                if (this.myTerminalPanelListener != null) {
                    this.myTerminalPanelListener.onPanelResize(pixelDimension, origin);
                }
                SwingUtilities.invokeLater(() -> this.updateScrolling(true));
            }
            finally {
                this.myTerminalTextBuffer.unlock();
            }
        }
        return new Dimension(this.getPixelWidth(), this.getPixelHeight());
    }

    public void setTerminalPanelListener(TerminalPanelListener resizeDelegate) {
        this.myTerminalPanelListener = resizeDelegate;
    }

    private void establishFontMetrics() {
        BufferedImage img = this.createBufferedImage(1, 1);
        Graphics2D graphics = img.createGraphics();
        graphics.setFont(this.myNormalFont);
        float lineSpace = this.mySettingsProvider.getLineSpace();
        FontMetrics fo = graphics.getFontMetrics();
        this.myDescent = fo.getDescent();
        this.myCharSize.width = fo.charWidth('W');
        this.myCharSize.height = fo.getHeight() + (int)(lineSpace * 2.0f) + 2;
        this.myDescent = (int)((float)this.myDescent + lineSpace);
        this.myMonospaced = TerminalPanel.isMonospaced(fo);
        if (!this.myMonospaced) {
            LOG.info((Object)("WARNING: Font " + this.myNormalFont.getName() + " is non-monospaced"));
        }
        img.flush();
        graphics.dispose();
    }

    private static boolean isMonospaced(FontMetrics fontMetrics) {
        boolean isMonospaced = true;
        int charWidth = -1;
        for (int codePoint = 0; codePoint < 128; ++codePoint) {
            char character;
            if (!Character.isValidCodePoint(codePoint) || !TerminalPanel.isWordCharacter(character = (char)codePoint)) continue;
            int w = fontMetrics.charWidth(character);
            if (charWidth != -1) {
                if (w == charWidth) continue;
                isMonospaced = false;
                break;
            }
            charWidth = w;
        }
        return isMonospaced;
    }

    private static boolean isWordCharacter(char character) {
        return Character.isLetterOrDigit(character);
    }

    protected void setupAntialiasing(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            Graphics2D myGfx = (Graphics2D)graphics;
            Object mode = this.mySettingsProvider.useAntialiasing() ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, mode);
            myGfx.setRenderingHints(hints);
        }
    }

    @Override
    public Color getBackground() {
        return this.getPalette().getColor(this.myStyleState.getBackground());
    }

    @Override
    public Color getForeground() {
        return this.getPalette().getColor(this.myStyleState.getForeground());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        final Graphics2D gfx = (Graphics2D)g;
        this.setupAntialiasing(gfx);
        gfx.setColor(this.getBackground());
        gfx.fillRect(0, 0, this.getWidth(), this.getHeight());
        try {
            this.myTerminalTextBuffer.lock();
            this.updateScrolling(false);
            this.myTerminalTextBuffer.processHistoryAndScreenLines(this.myClientScrollOrigin, this.myTermSize.height, new StyledTextConsumer(){
                final int columnCount;
                {
                    this.columnCount = TerminalPanel.this.getColumnCount();
                }

                @Override
                public void consume(int x, int y, @NotNull TextStyle style, @NotNull CharBuffer characters, int startRow) {
                    Pair<Integer, Integer> interval;
                    List<Pair<Integer, Integer>> ranges;
                    int row = y - startRow;
                    TerminalPanel.this.drawCharacters(x, row, style, characters, gfx);
                    if (TerminalPanel.this.myFindResult != null && (ranges = TerminalPanel.this.myFindResult.getRanges(characters)) != null) {
                        for (Pair<Integer, Integer> range : ranges) {
                            TextStyle foundPatternStyle = TerminalPanel.this.getFoundPattern(style);
                            CharBuffer foundPatternChars = characters.subBuffer(range);
                            TerminalPanel.this.drawCharacters(x + (Integer)range.first, row, foundPatternStyle, foundPatternChars, gfx);
                        }
                    }
                    if (TerminalPanel.this.mySelection != null && (interval = TerminalPanel.this.mySelection.intersect(x, row + TerminalPanel.this.myClientScrollOrigin, characters.length())) != null) {
                        TextStyle selectionStyle = TerminalPanel.this.getSelectionStyle(style);
                        CharBuffer selectionChars = characters.subBuffer((Integer)interval.first - x, (Integer)interval.second);
                        TerminalPanel.this.drawCharacters((Integer)interval.first, row, selectionStyle, selectionChars, gfx);
                    }
                }

                @Override
                public void consumeNul(int x, int y, int nulIndex, TextStyle style, CharBuffer characters, int startRow) {
                    Pair<Integer, Integer> interval;
                    int row = y - startRow;
                    if (TerminalPanel.this.mySelection != null && (interval = TerminalPanel.this.mySelection.intersect(nulIndex, row + TerminalPanel.this.myClientScrollOrigin, this.columnCount - nulIndex)) != null) {
                        TextStyle selectionStyle = TerminalPanel.this.getSelectionStyle(style);
                        TerminalPanel.this.drawCharacters(x, row, selectionStyle, characters, gfx);
                        return;
                    }
                    TerminalPanel.this.drawCharacters(x, row, style, characters, gfx);
                }

                @Override
                public void consumeQueue(int x, int y, int nulIndex, int startRow) {
                    if (x < this.columnCount) {
                        this.consumeNul(x, y, nulIndex, TextStyle.EMPTY, new CharBuffer(' ', this.columnCount - x), startRow);
                    }
                }
            });
            int cursorY = this.myCursor.getCoordY();
            if (this.myClientScrollOrigin + this.getRowCount() > cursorY && !this.hasUncommittedChars()) {
                int cursorX = this.myCursor.getCoordX();
                Pair<Character, TextStyle> sc = this.myTerminalTextBuffer.getStyledCharAt(cursorX, cursorY);
                String cursorChar = "" + sc.first;
                if (Character.isHighSurrogate(((Character)sc.first).charValue())) {
                    cursorChar = cursorChar + this.myTerminalTextBuffer.getStyledCharAt((int)(cursorX + 1), (int)cursorY).first;
                }
                TextStyle normalStyle = sc.second != null ? (TextStyle)sc.second : this.myStyleState.getCurrent();
                TextStyle selectionStyle = this.getSelectionStyle(normalStyle);
                boolean inSelection = this.inSelection(cursorX, cursorY);
                this.myCursor.drawCursor(cursorChar, gfx, inSelection ? selectionStyle : normalStyle);
            }
        }
        finally {
            this.myTerminalTextBuffer.unlock();
        }
        this.drawInputMethodUncommitedChars(gfx);
        this.drawMargins(gfx, this.getWidth(), this.getHeight());
    }

    private TextStyle getSelectionStyle(TextStyle style) {
        TextStyle selectionStyle = style.clone();
        if (this.mySettingsProvider.useInverseSelectionColor()) {
            selectionStyle = this.getInversedStyle(style);
        } else {
            TextStyle mySelectionStyle = this.mySettingsProvider.getSelectionColor();
            selectionStyle.setBackground(mySelectionStyle.getBackground());
            selectionStyle.setForeground(mySelectionStyle.getForeground());
        }
        return selectionStyle;
    }

    private TextStyle getFoundPattern(TextStyle style) {
        TextStyle foundPatternStyle = style.clone();
        TextStyle myFoundPattern = this.mySettingsProvider.getFoundPatternColor();
        foundPatternStyle.setBackground(myFoundPattern.getBackground());
        foundPatternStyle.setForeground(myFoundPattern.getForeground());
        return foundPatternStyle;
    }

    private void drawInputMethodUncommitedChars(Graphics2D gfx) {
        if (this.hasUncommittedChars()) {
            int xCoord = (this.myCursor.getCoordX() + 1) * this.myCharSize.width;
            int y = this.myCursor.getCoordY() + 1;
            int yCoord = y * this.myCharSize.height - 3;
            int len = this.myInputMethodUncommittedChars.length() * this.myCharSize.width;
            gfx.setColor(this.getBackground());
            gfx.fillRect(xCoord, (y - 1) * this.myCharSize.height - 3, len, this.myCharSize.height);
            gfx.setColor(this.getForeground());
            gfx.setFont(this.myNormalFont);
            gfx.drawString(this.myInputMethodUncommittedChars, xCoord, yCoord);
            Stroke saved = gfx.getStroke();
            BasicStroke dotted = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);
            gfx.setStroke(dotted);
            gfx.drawLine(xCoord, yCoord, xCoord + len, yCoord);
            gfx.setStroke(saved);
        }
    }

    private boolean hasUncommittedChars() {
        return this.myInputMethodUncommittedChars != null && this.myInputMethodUncommittedChars.length() > 0;
    }

    private boolean inSelection(int x, int y) {
        return this.mySelection != null && this.mySelection.contains(new Point(x, y));
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        this.handleKeyEvent(e);
        this.handleHyperlinks(e.getComponent(), e.isControlDown());
        e.consume();
    }

    public void handleKeyEvent(KeyEvent e) {
        int id = e.getID();
        if (id == 401) {
            this.myKeyListener.keyPressed(e);
        } else if (id != 402 && id == 400) {
            this.myKeyListener.keyTyped(e);
        }
    }

    public int getPixelWidth() {
        return this.myCharSize.width * this.myTermSize.width + this.getInsetX();
    }

    public int getPixelHeight() {
        return this.myCharSize.height * this.myTermSize.height;
    }

    @Override
    public int getColumnCount() {
        return this.myTermSize.width;
    }

    @Override
    public int getRowCount() {
        return this.myTermSize.height;
    }

    public String getWindowTitle() {
        return this.myWindowTitle;
    }

    private int getInsetX() {
        return 4;
    }

    public void addTerminalMouseListener(final TerminalMouseListener listener) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (TerminalPanel.this.mySettingsProvider.enableMouseReporting() && TerminalPanel.this.isRemoteMouseAction(e)) {
                    Point p = TerminalPanel.this.panelToCharCoords(e.getPoint());
                    listener.mousePressed(p.x, p.y, e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TerminalPanel.this.mySettingsProvider.enableMouseReporting() && TerminalPanel.this.isRemoteMouseAction(e)) {
                    Point p = TerminalPanel.this.panelToCharCoords(e.getPoint());
                    listener.mouseReleased(p.x, p.y, e);
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (TerminalPanel.this.mySettingsProvider.enableMouseReporting() && TerminalPanel.this.isRemoteMouseAction(e)) {
                    TerminalPanel.this.mySelection = null;
                    Point p = TerminalPanel.this.panelToCharCoords(e.getPoint());
                    listener.mouseWheelMoved(p.x, p.y, e);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (TerminalPanel.this.mySettingsProvider.enableMouseReporting() && TerminalPanel.this.isRemoteMouseAction(e)) {
                    Point p = TerminalPanel.this.panelToCharCoords(e.getPoint());
                    listener.mouseMoved(p.x, p.y, e);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TerminalPanel.this.mySettingsProvider.enableMouseReporting() && TerminalPanel.this.isRemoteMouseAction(e)) {
                    Point p = TerminalPanel.this.panelToCharCoords(e.getPoint());
                    listener.mouseDragged(p.x, p.y, e);
                }
            }
        });
    }

    public void initKeyHandler() {
        this.setKeyListener(new TerminalKeyHandler());
    }

    private int getBlinkingPeriod() {
        if (this.myBlinkingPeriod != this.mySettingsProvider.caretBlinkingMs()) {
            this.setBlinkingPeriod(this.mySettingsProvider.caretBlinkingMs());
        }
        return this.myBlinkingPeriod;
    }

    protected void drawImage(Graphics2D g, BufferedImage image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    private TextStyle getInversedStyle(TextStyle style) {
        TextStyle selectionStyle;
        selectionStyle.setOption(TextStyle.Option.INVERSE, !(selectionStyle = style.clone()).hasOption(TextStyle.Option.INVERSE));
        if (selectionStyle.getForeground() == null) {
            selectionStyle.setForeground(this.myStyleState.getForeground());
        }
        if (selectionStyle.getBackground() == null) {
            selectionStyle.setBackground(this.myStyleState.getBackground());
        }
        return selectionStyle;
    }

    private void drawCharacters(int x, int y, TextStyle style, CharBuffer buf, Graphics2D gfx) {
        int xCoord = x * this.myCharSize.width + this.getInsetX();
        int yCoord = y * this.myCharSize.height;
        if (xCoord < 0 || xCoord > this.getWidth() || yCoord < 0 || yCoord > this.getHeight()) {
            return;
        }
        int textLength = CharUtils.getTextLengthDoubleWidthAware(buf.getBuf(), buf.getStart(), buf.length(), this.mySettingsProvider.ambiguousCharsAreDoubleWidth());
        int height = Math.min(this.myCharSize.height, this.getHeight() - yCoord);
        int width = Math.min(textLength * this.myCharSize.width, this.getWidth() - xCoord);
        if (style instanceof HyperlinkStyle) {
            Rectangle rectangle = new Rectangle(xCoord, yCoord, width, height);
            HyperlinkStyle hyperlinkStyle = (HyperlinkStyle)style;
            if (hyperlinkStyle.getHighlightMode() == HyperlinkStyle.HighlightMode.ALWAYS || this.isHoveredHyperlink(hyperlinkStyle) && hyperlinkStyle.getHighlightMode() == HyperlinkStyle.HighlightMode.HOVER) {
                style = hyperlinkStyle.getHighlightStyle();
            }
        }
        Color backgroundColor = this.getPalette().getColor(this.myStyleState.getBackground(style.getBackgroundForRun()));
        gfx.setColor(backgroundColor);
        gfx.fillRect(xCoord, yCoord, width, height);
        if (buf.isNul()) {
            return;
        }
        this.drawChars(x, y, buf, style, gfx);
        gfx.setColor(this.getPalette().getColor(this.myStyleState.getForeground(style.getForegroundForRun())));
        int baseLine = (y + 1) * this.myCharSize.height - this.myDescent;
        if (style.hasOption(TextStyle.Option.UNDERLINED)) {
            gfx.drawLine(xCoord, baseLine + 3, (x + textLength) * this.myCharSize.width + this.getInsetX(), baseLine + 3);
        }
    }

    private boolean isHoveredHyperlink(@NotNull HyperlinkStyle link) {
        return this.myHoveredHyperlink == link.getLinkInfo();
    }

    private void drawChars(int x, int y, CharBuffer buf, TextStyle style, Graphics2D gfx) {
        int blockLen = 1;
        int offset = 0;
        int drawCharsOffset = 0;
        CharBuffer renderingBuffer = this.mySettingsProvider.DECCompatibilityMode() && style.hasOption(TextStyle.Option.BOLD) ? CharUtils.heavyDecCompatibleBuffer(buf) : buf;
        while (offset + blockLen <= buf.length()) {
            if (renderingBuffer.getBuf()[buf.getStart() + offset] == '\ue000') {
                offset += blockLen;
                drawCharsOffset += blockLen;
                continue;
            }
            Font font = this.getFontToDisplay(buf.charAt(offset + blockLen - 1), style);
            if (offset + 2 <= buf.length() && Character.isSurrogatePair(renderingBuffer.getBuf()[buf.getStart() + offset], renderingBuffer.getBuf()[buf.getStart() + offset + 1])) {
                blockLen = 2;
            }
            gfx.setFont(font);
            int descent = gfx.getFontMetrics(font).getDescent();
            int baseLine = (y + 1) * this.myCharSize.height - descent;
            int xCoord = (x + drawCharsOffset) * this.myCharSize.width + this.getInsetX();
            int textLength = CharUtils.getTextLengthDoubleWidthAware(buf.getBuf(), buf.getStart() + offset, blockLen, this.mySettingsProvider.ambiguousCharsAreDoubleWidth());
            int yCoord = y * this.myCharSize.height;
            gfx.setClip(xCoord, yCoord, this.getWidth() - xCoord, this.getHeight() - yCoord);
            gfx.setColor(this.getPalette().getColor(this.myStyleState.getForeground(style.getForegroundForRun())));
            gfx.drawChars(renderingBuffer.getBuf(), buf.getStart() + offset, blockLen, xCoord, baseLine);
            drawCharsOffset += blockLen;
            offset += blockLen;
            blockLen = 1;
        }
        gfx.setClip(null);
    }

    protected Font getFontToDisplay(char c, TextStyle style) {
        boolean bold = style.hasOption(TextStyle.Option.BOLD);
        boolean italic = style.hasOption(TextStyle.Option.ITALIC);
        if (bold && this.mySettingsProvider.DECCompatibilityMode() && CharacterSets.isDecBoxChar(c)) {
            return this.myNormalFont;
        }
        return bold ? (italic ? this.myBoldItalicFont : this.myBoldFont) : (italic ? this.myItalicFont : this.myNormalFont);
    }

    private ColorPalette getPalette() {
        return this.mySettingsProvider.getTerminalColorPalette();
    }

    private void drawMargins(Graphics2D gfx, int width, int height) {
        gfx.setColor(this.getBackground());
        gfx.fillRect(0, height, this.getWidth(), this.getHeight() - height);
        gfx.fillRect(width, 0, this.getWidth() - width, this.getHeight());
    }

    @Override
    public void scrollArea(int scrollRegionTop, int scrollRegionSize, int dy) {
        this.scrollDy.addAndGet(dy);
        this.mySelection = null;
    }

    private void updateScrolling(boolean forceUpdate) {
        int dy = this.scrollDy.getAndSet(0);
        if (dy == 0 && !forceUpdate) {
            return;
        }
        if (this.myScrollingEnabled) {
            int value = this.myBoundedRangeModel.getValue();
            int historyLineCount = this.myTerminalTextBuffer.getHistoryLinesCount();
            if (value == 0) {
                this.myBoundedRangeModel.setRangeProperties(0, this.myTermSize.height, -historyLineCount, this.myTermSize.height, false);
            } else {
                this.myBoundedRangeModel.setRangeProperties(Math.min(Math.max(value + dy, -historyLineCount), this.myTermSize.height), this.myTermSize.height, -historyLineCount, this.myTermSize.height, false);
            }
        } else {
            this.myBoundedRangeModel.setRangeProperties(0, this.myTermSize.height, 0, this.myTermSize.height, false);
        }
    }

    @Override
    public void setCursor(int x, int y) {
        this.myCursor.setX(x);
        this.myCursor.setY(y);
    }

    @Override
    public void beep() {
        if (this.mySettingsProvider.audibleBell()) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public BoundedRangeModel getBoundedRangeModel() {
        return this.myBoundedRangeModel;
    }

    public TerminalTextBuffer getTerminalTextBuffer() {
        return this.myTerminalTextBuffer;
    }

    @Override
    public TerminalSelection getSelection() {
        return this.mySelection;
    }

    @Override
    public boolean ambiguousCharsAreDoubleWidth() {
        return this.mySettingsProvider.ambiguousCharsAreDoubleWidth();
    }

    public LinesBuffer getScrollBuffer() {
        return this.myTerminalTextBuffer.getHistoryBuffer();
    }

    @Override
    public void setCursorVisible(boolean shouldDrawCursor) {
        this.myCursor.setShouldDrawCursor(shouldDrawCursor);
    }

    protected JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        TerminalAction.addToMenu(popup, this);
        return popup;
    }

    @Override
    public void setScrollingEnabled(boolean scrollingEnabled) {
        this.myScrollingEnabled = scrollingEnabled;
        SwingUtilities.invokeLater(() -> this.updateScrolling(true));
    }

    @Override
    public void setBlinkingCursor(boolean enabled) {
        this.myCursor.setBlinking(enabled);
    }

    public TerminalCursor getTerminalCursor() {
        return this.myCursor;
    }

    public TerminalOutputStream getTerminalOutputStream() {
        return this.myTerminalStarter;
    }

    @Override
    public void setWindowTitle(String name) {
        this.myWindowTitle = name;
        if (this.myTerminalPanelListener != null) {
            this.myTerminalPanelListener.onTitleChanged(this.myWindowTitle);
        }
    }

    @Override
    public void setCurrentPath(String path) {
        this.myCurrentPath = path;
    }

    @Override
    public List<TerminalAction> getActions() {
        return Lists.newArrayList((Object[])new TerminalAction[]{new TerminalAction("Open as URL", new KeyStroke[0], (Predicate<KeyEvent>)((Predicate)input -> this.openSelectionAsURL())).withEnabledSupplier((com.google.common.base.Supplier<Boolean>)((com.google.common.base.Supplier)this::selectionTextIsUrl)), new TerminalAction("Copy", this.mySettingsProvider.getCopyKeyStrokes(), (Predicate<KeyEvent>)((Predicate)input -> this.handleCopy())).withMnemonicKey(67).withEnabledSupplier((com.google.common.base.Supplier<Boolean>)((com.google.common.base.Supplier)() -> this.mySelection != null)), new TerminalAction("Paste", this.mySettingsProvider.getPasteKeyStrokes(), (Predicate<KeyEvent>)((Predicate)input -> {
            this.handlePaste();
            return true;
        })).withMnemonicKey(80).withEnabledSupplier((com.google.common.base.Supplier<Boolean>)((com.google.common.base.Supplier)() -> this.getClipboardString() != null)), new TerminalAction("Clear Buffer", this.mySettingsProvider.getClearBufferKeyStrokes(), (Predicate<KeyEvent>)((Predicate)input -> {
            this.clearBuffer();
            return true;
        })).withMnemonicKey(75).withEnabledSupplier((com.google.common.base.Supplier<Boolean>)((com.google.common.base.Supplier)() -> !this.myTerminalTextBuffer.isUsingAlternateBuffer())).separatorBefore(true), new TerminalAction("Page Up", this.mySettingsProvider.getPageUpKeyStrokes(), (Predicate<KeyEvent>)((Predicate)input -> {
            this.pageUp();
            return true;
        })).withEnabledSupplier((com.google.common.base.Supplier<Boolean>)((com.google.common.base.Supplier)() -> !this.myTerminalTextBuffer.isUsingAlternateBuffer())).separatorBefore(true), new TerminalAction("Page Down", this.mySettingsProvider.getPageDownKeyStrokes(), (Predicate<KeyEvent>)((Predicate)input -> {
            this.pageDown();
            return true;
        })).withEnabledSupplier((com.google.common.base.Supplier<Boolean>)((com.google.common.base.Supplier)() -> !this.myTerminalTextBuffer.isUsingAlternateBuffer()))});
    }

    @NotNull
    private Boolean selectionTextIsUrl() {
        String selectionText = this.getSelectionText();
        if (selectionText != null) {
            try {
                URI uri = new URI(selectionText);
                uri.toURL();
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    private String getSelectionText() {
        if (this.mySelection != null) {
            Pair<Point, Point> points = this.mySelection.pointsForRun(this.myTermSize.width);
            if (points.first != null || points.second != null) {
                return SelectionUtil.getSelectionText((Point)points.first, (Point)points.second, this.myTerminalTextBuffer);
            }
        }
        return null;
    }

    protected boolean openSelectionAsURL() {
        if (Desktop.isDesktopSupported()) {
            try {
                String selectionText = this.getSelectionText();
                if (selectionText != null) {
                    Desktop.getDesktop().browse(new URI(selectionText));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void clearBuffer() {
        if (!this.myTerminalTextBuffer.isUsingAlternateBuffer()) {
            this.myTerminalTextBuffer.clearHistory();
            if (this.myCoordsAccessor != null && this.myCoordsAccessor.getY() > 0) {
                TerminalLine line = this.myTerminalTextBuffer.getLine(this.myCoordsAccessor.getY() - 1);
                this.myTerminalTextBuffer.clearAll();
                this.myCoordsAccessor.setY(0);
                this.myCursor.setY(1);
                this.myTerminalTextBuffer.addLine(line);
            }
            this.myBoundedRangeModel.setValue(0);
            this.updateScrolling(true);
            this.myClientScrollOrigin = this.myBoundedRangeModel.getValue();
        }
    }

    @Override
    public TerminalActionProvider getNextProvider() {
        return this.myNextActionProvider;
    }

    @Override
    public void setNextProvider(TerminalActionProvider provider) {
        this.myNextActionProvider = provider;
    }

    private void processTerminalKeyPressed(KeyEvent e) {
        if (this.hasUncommittedChars()) {
            return;
        }
        try {
            int keycode = e.getKeyCode();
            char keychar = e.getKeyChar();
            if (keycode == 127 && keychar == '.') {
                this.myTerminalStarter.sendBytes(new byte[]{46});
                return;
            }
            if (keychar == ' ' && (e.getModifiers() & 2) != 0) {
                this.myTerminalStarter.sendBytes(new byte[]{0});
                return;
            }
            byte[] code = this.myTerminalStarter.getCode(keycode, e.getModifiers());
            if (code != null) {
                this.myTerminalStarter.sendBytes(code);
                if (this.mySettingsProvider.scrollToBottomOnTyping() && TerminalPanel.isCodeThatScrolls(keycode)) {
                    this.scrollToBottom();
                }
            } else if (Character.isISOControl(keychar)) {
                this.processCharacter(keychar, e.getModifiers());
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error sending pressed key to emulator", (Throwable)ex);
        }
    }

    private void processCharacter(char keychar, int modifiers) {
        char[] obuffer = this.mySettingsProvider.altSendsEscape() && (modifiers & 8) != 0 ? new char[]{'\u001b', keychar} : new char[]{keychar};
        if (keychar == '`' && (modifiers & 4) != 0) {
            return;
        }
        this.myTerminalStarter.sendString(new String(obuffer));
        if (this.mySettingsProvider.scrollToBottomOnTyping()) {
            this.scrollToBottom();
        }
    }

    private static boolean isCodeThatScrolls(int keycode) {
        return keycode == 38 || keycode == 40 || keycode == 37 || keycode == 39 || keycode == 8 || keycode == 127;
    }

    private void processTerminalKeyTyped(KeyEvent e) {
        if (this.hasUncommittedChars()) {
            return;
        }
        char keychar = e.getKeyChar();
        if (!Character.isISOControl(keychar)) {
            try {
                this.processCharacter(keychar, e.getModifiers());
            }
            catch (Exception ex) {
                LOG.error((Object)"Error sending typed key to emulator", (Throwable)ex);
            }
        }
    }

    private void handlePaste() {
        this.pasteFromClipboard(this::getClipboardString);
    }

    private void handlePasteSelection() {
        this.pasteFromClipboard(this::getSelectionClipboardString);
    }

    private boolean handleCopy(boolean unselect, Consumer<StringSelection> copyHandler) {
        if (this.mySelection != null) {
            Pair<Point, Point> points = this.mySelection.pointsForRun(this.myTermSize.width);
            this.copySelection((Point)points.first, (Point)points.second, copyHandler);
            if (unselect) {
                this.mySelection = null;
                this.repaint();
            }
            return true;
        }
        return false;
    }

    private boolean handleCopy() {
        return this.handleCopy(true, this::setCopyContents);
    }

    private boolean handleCopyOnSelect() {
        return this.handleCopy(false, this::setCopySelectionContents);
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent e) {
        int commitCount = e.getCommittedCharacterCount();
        if (commitCount > 0) {
            this.myInputMethodUncommittedChars = null;
            AttributedCharacterIterator text = e.getText();
            if (text != null) {
                StringBuilder sb = new StringBuilder();
                char c = text.first();
                while (commitCount > 0) {
                    if (c >= ' ' && c != '\u007f') {
                        sb.append(c);
                    }
                    c = text.next();
                    --commitCount;
                }
                if (sb.length() > 0) {
                    this.myTerminalStarter.sendString(sb.toString());
                }
            }
        } else {
            this.myInputMethodUncommittedChars = TerminalPanel.uncommittedChars(e.getText());
        }
    }

    private static String uncommittedChars(@Nullable AttributedCharacterIterator text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        char c = text.first();
        while (c != '\uffff') {
            if (c >= ' ' && c != '\u007f') {
                sb.append(c);
            }
            c = text.next();
        }
        return sb.toString();
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return new MyInputMethodRequests();
    }

    public void dispose() {
        this.myRepaintTimer.stop();
    }

    private class MyInputMethodRequests
    implements InputMethodRequests {
        private MyInputMethodRequests() {
        }

        @Override
        public Rectangle getTextLocation(TextHitInfo offset) {
            Rectangle r = new Rectangle(TerminalPanel.this.myCursor.getCoordX() * TerminalPanel.this.myCharSize.width, (TerminalPanel.this.myCursor.getCoordY() + 1) * TerminalPanel.this.myCharSize.height, 0, 0);
            Point p = TerminalPanel.this.getLocationOnScreen();
            r.translate(p.x, p.y);
            return r;
        }

        @Override
        @Nullable
        public TextHitInfo getLocationOffset(int x, int y) {
            return null;
        }

        @Override
        public int getInsertPositionOffset() {
            return 0;
        }

        @Override
        public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        public int getCommittedTextLength() {
            return 0;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }

        @Override
        @Nullable
        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
            return null;
        }
    }

    public class TerminalKeyHandler
    implements KeyListener {
        @Override
        public void keyPressed(KeyEvent e) {
            if (!TerminalAction.processEvent(TerminalPanel.this, e)) {
                TerminalPanel.this.processTerminalKeyPressed(e);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            TerminalPanel.this.processTerminalKeyTyped(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    public class TerminalCursor {
        private boolean myCursorIsShown;
        protected Point myCursorCoordinates = new Point();
        private boolean myShouldDrawCursor = true;
        private boolean myBlinking = true;
        private long myLastCursorChange;
        private boolean myCursorHasChanged;

        public void setX(int x) {
            this.myCursorCoordinates.x = x;
            this.cursorChanged();
        }

        public void setY(int y) {
            this.myCursorCoordinates.y = y;
            this.cursorChanged();
        }

        public int getCoordX() {
            return this.myCursorCoordinates.x;
        }

        public int getCoordY() {
            return this.myCursorCoordinates.y - 1 - TerminalPanel.this.myClientScrollOrigin;
        }

        public void setShouldDrawCursor(boolean shouldDrawCursor) {
            this.myShouldDrawCursor = shouldDrawCursor;
        }

        public void setBlinking(boolean blinking) {
            this.myBlinking = blinking;
        }

        public boolean isBlinking() {
            return this.myBlinking && TerminalPanel.this.getBlinkingPeriod() > 0;
        }

        public void cursorChanged() {
            this.myCursorHasChanged = true;
            this.myLastCursorChange = System.currentTimeMillis();
            TerminalPanel.this.repaint();
        }

        private boolean cursorShouldChangeBlinkState(long currentTime) {
            return currentTime - this.myLastCursorChange > (long)TerminalPanel.this.getBlinkingPeriod();
        }

        public void changeStateIfNeeded() {
            if (!TerminalPanel.this.isFocusOwner()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this.cursorShouldChangeBlinkState(currentTime)) {
                this.myCursorIsShown = !this.myCursorIsShown;
                this.myLastCursorChange = currentTime;
                this.myCursorHasChanged = false;
                TerminalPanel.this.repaint();
            }
        }

        private TerminalCursorState computeBlinkingState() {
            if (!this.isBlinking() || this.myCursorHasChanged || this.myCursorIsShown) {
                return TerminalCursorState.SHOWING;
            }
            return TerminalCursorState.HIDDEN;
        }

        private TerminalCursorState computeCursorState() {
            if (!this.myShouldDrawCursor) {
                return TerminalCursorState.HIDDEN;
            }
            if (!TerminalPanel.this.isFocusOwner()) {
                return TerminalCursorState.NO_FOCUS;
            }
            return this.computeBlinkingState();
        }

        public void drawCursor(String c, Graphics2D gfx, TextStyle style) {
            TerminalCursorState state = this.computeCursorState();
            if (state == TerminalCursorState.HIDDEN) {
                return;
            }
            int x = this.getCoordX();
            int y = this.getCoordY();
            if (y >= 0 && y < TerminalPanel.this.myTermSize.height) {
                if (state == TerminalCursorState.SHOWING) {
                    TextStyle styleToDraw = TerminalPanel.this.getInversedStyle(style);
                    TerminalPanel.this.drawCharacters(x, y, styleToDraw, new CharBuffer(c), gfx);
                } else if (state == TerminalCursorState.NO_FOCUS) {
                    int xCoord = x * TerminalPanel.this.myCharSize.width;
                    int yCoord = y * TerminalPanel.this.myCharSize.height;
                    gfx.setColor(TerminalPanel.this.getPalette().getColor(TerminalPanel.this.myStyleState.getForeground(style.getForegroundForRun())));
                    gfx.drawRect(xCoord, yCoord, c.length() * TerminalPanel.this.myCharSize.width - 1, TerminalPanel.this.myCharSize.height - 1);
                }
            }
        }
    }

    public static enum TerminalCursorState {
        SHOWING,
        HIDDEN,
        NO_FOCUS;

    }

    static class WeakRedrawTimer
    implements ActionListener {
        private WeakReference<TerminalPanel> ref;

        public WeakRedrawTimer(TerminalPanel terminalPanel) {
            this.ref = new WeakReference<TerminalPanel>(terminalPanel);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TerminalPanel terminalPanel = (TerminalPanel)this.ref.get();
            if (terminalPanel != null) {
                terminalPanel.myCursor.changeStateIfNeeded();
                terminalPanel.updateScrolling(false);
                if (terminalPanel.needRepaint.getAndSet(false)) {
                    try {
                        terminalPanel.doRepaint();
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Error while terminal panel redraw", (Throwable)ex);
                    }
                }
            } else {
                Timer timer = (Timer)e.getSource();
                timer.removeActionListener(this);
                timer.stop();
            }
        }
    }
}

