/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.highlighting.syntax;

import com.intellij.codeInsight.daemon.impl.analysis.InsertRequiredAttributeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.TilesModel;
import com.intellij.struts.dom.Action;
import com.intellij.struts.dom.Controller;
import com.intellij.struts.dom.FormBean;
import com.intellij.struts.dom.PlugIn;
import com.intellij.struts.dom.StrutsConfig;
import com.intellij.struts.highlighting.syntax.DomAnnotatorComponentBase;
import com.intellij.struts.highlighting.syntax.DomAnnotatorVisitor;
import com.intellij.struts.util.PsiClassUtil;
import com.intellij.util.xml.GenericAttributeValue;

public class StrutsSyntaxAnnotator
extends DomAnnotatorComponentBase<StrutsConfig> {
    public StrutsSyntaxAnnotator() {
        super(StrutsConfig.class);
    }

    private static boolean isStruts13(Project project) {
        PsiClass composableRequestProcessor = PsiClassUtil.findClassInProjectScope("org.apache.struts.chain.ComposableRequestProcessor", project);
        return composableRequestProcessor != null;
    }

    @Override
    protected DomAnnotatorVisitor buildVisitor(final AnnotationHolder holder) {
        return new DomAnnotatorVisitor(holder){

            public void visitAction(Action action) {
                PsiClass dispatchActionClazz;
                String actionPath = action.getPath().getStringValue();
                if (actionPath != null && actionPath.contains("#")) {
                    holder.createErrorAnnotation((PsiElement)action.getPath().ensureXmlElementExists(), "Illegal character '#'");
                }
                GenericAttributeValue<FormBean> formBean = action.getName();
                this.checkRequiredAttribute(action.getAttribute(), formBean);
                this.checkRequiredAttribute(action.getInput(), formBean);
                this.checkRequiredAttribute(action.getScope(), formBean);
                this.checkRequiredAttribute(action.getPrefix(), formBean);
                this.checkRequiredAttribute(action.getSuffix(), formBean);
                this.checkRequiredAttribute(action.getValidate(), formBean);
                this.checkMutuallyExclusiveAttributes(action.getForward(), action.getInclude(), action.getType());
                PsiClass actionClazz = (PsiClass)action.getType().getValue();
                if (actionClazz != null && (dispatchActionClazz = PsiClassUtil.findClassInProjectScope("org.apache.struts.actions.DispatchAction", action.ensureTagExists().getProject())) != null && actionClazz.isInheritor(dispatchActionClazz, true)) {
                    XmlAttributeValue element;
                    XmlAttribute parameterAttribute = action.getParameter().getXmlAttribute();
                    if (parameterAttribute == null) {
                        Annotation annotation = holder.createErrorAnnotation((PsiElement)action.ensureTagExists(), "Attribute parameter is mandatory for Action-class of type DispatchAction");
                        if (!holder.isBatchMode()) {
                            annotation.registerFix((IntentionAction)new InsertRequiredAttributeFix(action.getXmlTag(), "parameter", new String[0]));
                        }
                    } else if (StringUtil.isEmptyOrSpaces((String)parameterAttribute.getValue()) && (element = parameterAttribute.getValueElement()) != null) {
                        holder.createErrorAnnotation((PsiElement)element, "Attribute parameter must not be empty for Action-class of type DispatchAction");
                    }
                }
            }

            public void visitController(Controller controller) {
                XmlElement controllerElement = controller.getXmlElement();
                if (controllerElement == null) {
                    return;
                }
                Project project = controllerElement.getProject();
                if (StrutsSyntaxAnnotator.isStruts13(project)) {
                    return;
                }
                TilesModel tilesModel = StrutsManager.getInstance().getTiles((PsiElement)controllerElement);
                if (tilesModel == null) {
                    return;
                }
                PsiClass processorClass = (PsiClass)controller.getProcessorClass().getValue();
                PsiClass tilesRequestProcessor = PsiClassUtil.findClassInProjectScope("org.apache.struts.tiles.TilesRequestProcessor", project);
                if (processorClass == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)processorClass, (PsiClass)tilesRequestProcessor, (boolean)true)) {
                    holder.createErrorAnnotation((PsiElement)controller.ensureTagExists(), "Wrong processor class for use with Tiles, use org.apache.struts.tiles.TilesRequestProcessor or subclass thereof");
                }
            }

            public void visitPlugIn(PlugIn plugIn) {
                PsiClass tilesPluginClass;
                XmlElement pluginElement = plugIn.getXmlElement();
                if (pluginElement == null) {
                    return;
                }
                Project project = pluginElement.getProject();
                if (StrutsSyntaxAnnotator.isStruts13(project)) {
                    return;
                }
                PsiClass pluginClass = (PsiClass)plugIn.getClassName().getValue();
                if (pluginClass == null | !InheritanceUtil.isInheritorOrSelf((PsiClass)pluginClass, (PsiClass)(tilesPluginClass = PsiClassUtil.findClassInProjectScope("org.apache.struts.tiles.TilesPlugin", project)), (boolean)true)) {
                    return;
                }
                TilesModel tilesModel = StrutsManager.getInstance().getTiles((PsiElement)pluginElement);
                if (tilesModel != null) {
                    StrutsConfig strutsConfig = StrutsManager.getInstance().getStrutsConfig(pluginElement.getContainingFile());
                    assert (strutsConfig != null);
                    Controller controller = strutsConfig.getController();
                    if (controller.getXmlTag() == null) {
                        holder.createErrorAnnotation((PsiElement)pluginElement, "Missing <controller> definition for use with Tiles");
                    }
                }
            }
        };
    }
}

