/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.psi;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.jsp.WebDirectoryUtil;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.StrutsProjectComponent;
import com.intellij.struts.TilesModel;
import com.intellij.struts.ValidationModel;
import com.intellij.struts.dom.StrutsConfig;
import com.intellij.struts.dom.StrutsRootElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ExtendClass;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsManagerImpl
extends StrutsManager {
    @Override
    @Nullable
    public StrutsModel getStrutsModel(@Nullable PsiElement psiElement) {
        StrutsModel model;
        Module module;
        String modulePrefix;
        if (psiElement == null) {
            return null;
        }
        PsiElement p = psiElement.getParent();
        if (p == null) {
            return null;
        }
        PsiElement parent = p.getParent();
        if (parent instanceof XmlTag && (modulePrefix = ((XmlTag)parent).getAttributeValue("module")) != null && (module = ModuleUtil.findModuleForPsiElement((PsiElement)psiElement)) != null && (model = this.getModelByPrefix(module, modulePrefix)) != null) {
            return model;
        }
        PsiFile file = psiElement.getContainingFile();
        if (file == null) {
            return null;
        }
        return this.getModelByFile(file);
    }

    @Override
    @NotNull
    public StrutsConfig getContext(@NotNull StrutsRootElement element) {
        StrutsConfig strutsConfig;
        if (element == null) {
            StrutsManagerImpl.$$$reportNull$$$0(0);
        }
        XmlElement xmlElement = element.getXmlElement();
        StrutsModel model = this.getStrutsModel((PsiElement)xmlElement);
        assert (xmlElement != null);
        StrutsConfig strutsConfig2 = strutsConfig = model == null ? this.getStrutsConfig(xmlElement.getContainingFile()) : (StrutsConfig)model.getMergedModel();
        assert (strutsConfig != null);
        StrutsConfig strutsConfig3 = strutsConfig;
        if (strutsConfig3 == null) {
            StrutsManagerImpl.$$$reportNull$$$0(1);
        }
        return strutsConfig3;
    }

    @Nullable
    private StrutsModel getModelByFile(PsiFile file) {
        FileType fileType = (file = file.getOriginalFile()).getFileType();
        if (fileType == StdFileTypes.XML) {
            return (StrutsModel)StrutsProjectComponent.getInstance(file.getProject()).getStrutsFactory().getModel((PsiElement)file);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module != null) {
            VirtualFile virtualFile = file.getVirtualFile();
            assert (virtualFile != null);
            WebDirectoryElement dir = WebDirectoryUtil.findParentWebDirectory((Project)module.getProject(), (VirtualFile)virtualFile);
            if (dir != null) {
                List<StrutsModel> strutsModels = this.getAllStrutsModels(module);
                String path = dir.getPath();
                while (true) {
                    for (StrutsModel model : strutsModels) {
                        WebDirectoryElement moduleRoot = model.getModuleRoot();
                        if (moduleRoot == null || !path.equals(moduleRoot.getPath())) continue;
                        return model;
                    }
                    int lastSlash = path.lastIndexOf(47);
                    if (lastSlash == -1) break;
                    path = path.substring(0, lastSlash);
                }
            }
            return this.getCombinedStrutsModel(module);
        }
        return null;
    }

    @Override
    @NotNull
    public List<StrutsModel> getAllStrutsModels(@NotNull Module module) {
        if (module == null) {
            StrutsManagerImpl.$$$reportNull$$$0(2);
        }
        List list = StrutsProjectComponent.getInstance(module.getProject()).getStrutsFactory().getAllModels((UserDataHolder)module);
        if (list == null) {
            StrutsManagerImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nullable
    public StrutsConfig getStrutsConfig(@NotNull PsiFile configFile) {
        if (configFile == null) {
            StrutsManagerImpl.$$$reportNull$$$0(4);
        }
        return configFile instanceof XmlFile ? (StrutsConfig)StrutsProjectComponent.getInstance(configFile.getProject()).getStrutsFactory().getDom((XmlFile)configFile) : null;
    }

    @Override
    @Nullable
    public StrutsModel getCombinedStrutsModel(@Nullable Module module) {
        return module == null ? null : (StrutsModel)StrutsProjectComponent.getInstance(module.getProject()).getStrutsFactory().getCombinedModel((UserDataHolder)module);
    }

    @Override
    @Nullable
    public StrutsModel getModelByPrefix(@NotNull Module module, @NotNull @NonNls String modulePrefix) {
        if (module == null) {
            StrutsManagerImpl.$$$reportNull$$$0(5);
        }
        if (modulePrefix == null) {
            StrutsManagerImpl.$$$reportNull$$$0(6);
        }
        List<StrutsModel> models = this.getAllStrutsModels(module);
        for (StrutsModel model : models) {
            if (!model.getModulePrefix().equals(modulePrefix)) continue;
            return model;
        }
        return null;
    }

    @Override
    @Nullable
    public ValidationModel getValidation(@Nullable PsiElement psiElement) {
        return psiElement == null ? null : (ValidationModel)StrutsProjectComponent.getInstance(psiElement.getProject()).getValidatorFactory().getModel(psiElement);
    }

    @Override
    @NotNull
    public List<ValidationModel> getAllValidationModels(@NotNull Module module) {
        if (module == null) {
            StrutsManagerImpl.$$$reportNull$$$0(7);
        }
        List list = StrutsProjectComponent.getInstance(module.getProject()).getValidatorFactory().getAllModels((UserDataHolder)module);
        if (list == null) {
            StrutsManagerImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    @Nullable
    public String getDefaultClassname(String attrName, XmlTag tag) {
        ExtendClass annotation;
        DomAttributeChildDescription childDescription;
        DomElement domElement = DomManager.getDomManager((Project)tag.getProject()).getDomElement(tag);
        if (domElement != null && (childDescription = domElement.getGenericInfo().getAttributeChildDescription(attrName)) != null && (annotation = (ExtendClass)childDescription.getAnnotation(ExtendClass.class)) != null) {
            return annotation.value();
        }
        return null;
    }

    @Override
    @Nullable
    public TilesModel getTiles(@Nullable PsiElement psiElement) {
        return psiElement == null ? null : (TilesModel)StrutsProjectComponent.getInstance(psiElement.getProject()).getTilesFactory().getModel(psiElement);
    }

    @Override
    @NotNull
    public List<TilesModel> getAllTilesModels(@NotNull Module module) {
        if (module == null) {
            StrutsManagerImpl.$$$reportNull$$$0(9);
        }
        List list = StrutsProjectComponent.getInstance(module.getProject()).getTilesFactory().getAllModels((UserDataHolder)module);
        if (list == null) {
            StrutsManagerImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    public boolean isStrutsConfig(@NotNull XmlFile file) {
        if (file == null) {
            StrutsManagerImpl.$$$reportNull$$$0(11);
        }
        return DomManager.getDomManager((Project)file.getProject()).getFileElement(file, StrutsConfig.class) != null;
    }

    @Override
    @NotNull
    public Set<XmlFile> getStrutsConfigFiles(@Nullable PsiElement psiElement) {
        StrutsModel model = this.getStrutsModel(psiElement);
        if (model == null) {
            Set<XmlFile> set = Collections.emptySet();
            if (set == null) {
                StrutsManagerImpl.$$$reportNull$$$0(12);
            }
            return set;
        }
        Set set = model.getConfigFiles();
        if (set == null) {
            StrutsManagerImpl.$$$reportNull$$$0(13);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/struts/psi/StrutsManagerImpl";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePrefix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/struts/psi/StrutsManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllStrutsModels";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllValidationModels";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTilesModels";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrutsConfigFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllStrutsModels";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getStrutsConfig";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModelByPrefix";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAllValidationModels";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllTilesModels";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isStrutsConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

