/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.utils.model;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalAnnotationModelDependentModelsProvider;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.PairProcessor;

public class EnableSpringDataWebModelsProvider
extends LocalAnnotationModelDependentModelsProvider {
    private static final String ENABLE_SPRING_DATA_WEB_ANNO = "org.springframework.data.web.config.EnableSpringDataWebSupport";
    private static final String SPRING_DATA_WEB_CONFIGURATION = "org.springframework.data.web.config.SpringDataWebConfiguration";

    public boolean processCustomDependentLocalModels(LocalAnnotationModel localAnnotationModel, PairProcessor<LocalModel, LocalModelDependency> processor) {
        Module module = localAnnotationModel.getModule();
        if (module == null) {
            return true;
        }
        if (!ENABLE_SPRING_DATA_WEB_ANNO.equals(((PsiClass)localAnnotationModel.getConfig()).getQualifiedName())) {
            return true;
        }
        PsiClass dataWebConfigurationClass = SpringCommonUtils.findLibraryClass((Module)module, (String)SPRING_DATA_WEB_CONFIGURATION);
        if (dataWebConfigurationClass == null) {
            return true;
        }
        LocalAnnotationModel model = SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(dataWebConfigurationClass, module, localAnnotationModel.getActiveProfiles());
        return processor.process((Object)model, (Object)LocalModelDependency.create((LocalModelDependencyType)LocalModelDependencyType.IMPORT, (PsiElement)dataWebConfigurationClass));
    }
}

