/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.model.common;

import com.intellij.ide.TypePresentationService;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiPresentableMetaData;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.SmartList;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.ModelMergerUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JamSupportMetaData<T extends CommonModelElement>
implements PsiWritableMetaData,
PsiPresentableMetaData {
    private static final Logger LOG = Logger.getInstance((String)JamSupportMetaData.class.getName());
    private T myElement;

    protected final void setElement(T element) {
        this.myElement = element;
    }

    protected final T getElement() {
        return this.myElement;
    }

    public final PsiElement getDeclaration() {
        T element = this.myElement;
        if (element == null) {
            LOG.error(this.getClass());
        }
        return element.getIdentifyingPsiElement();
    }

    @NotNull
    public Object[] getDependences() {
        if (this.myElement != null) {
            SmartList deps = new SmartList();
            deps.add(this.getDeclaration());
            deps.add(PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
            for (DomElement domElement : ModelMergerUtil.getImplementations(this.myElement, DomElement.class)) {
                if (!domElement.isValid()) continue;
                deps.add(DomUtil.getFileElement(domElement));
            }
            Object[] objectArray = deps.toArray();
            if (objectArray == null) {
                JamSupportMetaData.$$$reportNull$$$0(0);
            }
            return objectArray;
        }
        Object[] objectArray = new Object[]{this.getDeclaration(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT};
        if (objectArray == null) {
            JamSupportMetaData.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    @NonNls
    public final String getName() {
        return StringUtil.notNullize((String)ElementPresentationManager.getElementName(this.myElement));
    }

    @NonNls
    public String getName(PsiElement context) {
        return this.getName();
    }

    public String getTypeName() {
        return TypePresentationService.getService().getTypePresentableName(this.myElement.getClass());
    }

    public Icon getIcon() {
        return ElementPresentationManager.getIcon(this.myElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/model/common/JamSupportMetaData", "getDependences"));
    }
}

