/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.reflect;

import com.intellij.jam.JamClassGenerator;
import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamMemberArchetype;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemElement;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JamMemberMeta<Psi extends PsiModifierListOwner, Jam extends JamElement>
extends JamMemberArchetype<Psi, Jam>
implements SemElement {
    private final SemKey<Jam> myJamKey;
    private final SemKey<JamMemberMeta> myMetaKey;
    private final NotNullFunction<PsiElementRef, ? extends Jam> myCreator;
    private final List<JamAnnotationMeta> myRootAnnos = new SmartList();

    protected JamMemberMeta(Class<? extends Jam> jamClass) {
        this(null, jamClass);
    }

    public JamMemberMeta(@Nullable JamMemberArchetype<? super Psi, ? super Jam> parent, Class<? extends Jam> jamClass) {
        this(parent, jamClass, JamService.JAM_ELEMENT_KEY.subKey(jamClass.getSimpleName(), new SemKey[0]));
    }

    public JamMemberMeta(@Nullable JamMemberArchetype<? super Psi, ? super Jam> parent, Class<? extends Jam> jamClass, SemKey<Jam> jamKey) {
        super(parent);
        this.myJamKey = jamKey;
        this.myCreator = JamClassGenerator.getInstance().generateJamElementFactory(jamClass);
        this.myMetaKey = JamService.getMetaKey(this.myJamKey);
    }

    public SemKey<Jam> getJamKey() {
        return this.myJamKey;
    }

    public SemKey<JamMemberMeta> getMetaKey() {
        return this.myMetaKey;
    }

    public List<JamAnnotationMeta> getRootAnnotations() {
        return this.myRootAnnos;
    }

    public void register(SemRegistrar registrar, ElementPattern<? extends Psi> pattern) {
        registrar.registerSemElementProvider(this.myMetaKey, pattern, (NullableFunction)new ConstantFunction((Object)this));
        registrar.registerSemElementProvider(this.myJamKey, pattern, psi -> this.createJamElement(PsiElementRef.real((PsiElement)psi)));
        this.registerChildren(registrar, pattern);
        for (JamMemberArchetype cur = this; cur != null; cur = cur.getParent()) {
            for (JamAnnotationMeta anno : cur.getAnnotations()) {
                anno.registerTopLevelSem(registrar, pattern, this);
            }
        }
    }

    @Override
    public JamMemberMeta<Psi, Jam> addPomTargetProducer(@NotNull PairConsumer<Jam, Consumer<PomTarget>> producer) {
        if (producer == null) {
            JamMemberMeta.$$$reportNull$$$0(0);
        }
        super.addPomTargetProducer(producer);
        return this;
    }

    @Nullable
    public final Jam getJamElement(@NotNull Psi member) {
        if (member == null) {
            JamMemberMeta.$$$reportNull$$$0(1);
        }
        return (Jam)((JamElement)SemService.getSemService((Project)member.getProject()).getSemElement(this.myJamKey, member));
    }

    @Nullable
    public Jam createJamElement(PsiElementRef<Psi> ref) {
        return (Jam)((JamElement)this.myCreator.fun(ref));
    }

    @Override
    public JamMemberMeta<Psi, Jam> addAnnotation(JamAnnotationMeta meta) {
        super.addAnnotation(meta);
        return this;
    }

    public JamMemberMeta<Psi, Jam> addRootAnnotation(JamAnnotationMeta meta) {
        super.addAnnotation(meta);
        this.myRootAnnos.add(meta);
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jam/reflect/JamMemberMeta";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addPomTargetProducer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getJamElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

