/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam.view;

import com.intellij.jam.JamMessages;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.view.JamUserResponse;
import com.intellij.jam.view.ui.SelectElementsToDeleteDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;

public class DefaultUserResponse
implements JamUserResponse {
    protected final Project myProject;
    private final List<DeleteError> myErrors = new ArrayList<DeleteError>();

    public DefaultUserResponse(Project project) {
        this.myProject = project;
    }

    public DefaultUserResponse(CommonModelElement element) {
        this.myProject = element.getPsiManager().getProject();
    }

    @Override
    public Collection<PsiElement> askUserToDeletePsiElements(Collection<PsiElement> ownedReferences, String elementDisplayName) {
        SelectElementsToDeleteDialog dialog = new SelectElementsToDeleteDialog(new ArrayList<PsiElement>(ownedReferences), this.myProject);
        if (dialog.showAndGet()) {
            return dialog.getSelectedItems();
        }
        return new ArrayList<PsiElement>();
    }

    @Override
    public void logErrorWhileDeletingModelElement(IncorrectOperationException e, CommonModelElement object) {
        throw new RuntimeException(e);
    }

    @Override
    public void logErrorWhileDeletingPsiElement(IncorrectOperationException e, String source, PsiElement current) {
        this.myErrors.add(new DeleteError(e, source));
    }

    @Override
    public int showYesNoDialog(String message, String title, Icon icon) {
        return Messages.showYesNoDialog((String)message, (String)title, (Icon)icon);
    }

    @Override
    public void onDeletingHasBeenFinished() {
        if (!this.myErrors.isEmpty()) {
            StringBuffer errors = new StringBuffer();
            for (DeleteError deleteError : this.myErrors) {
                errors.append(deleteError.getLocalizedMessage());
                errors.append("\n");
            }
            Messages.showErrorDialog((String)errors.toString(), (String)JamMessages.message("message.title.deleting.element", this.myErrors.get(0).getSourceDisplayString()));
        }
    }

    private static class DeleteError
    extends RuntimeException {
        private final String mySourceDisplayString;

        public DeleteError(Throwable cause, String sourceDisplayString) {
            super(cause);
            this.mySourceDisplayString = sourceDisplayString;
        }

        public String getSourceDisplayString() {
            return this.mySourceDisplayString;
        }
    }
}

