/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScriptingLibraryModel {
    public static final ScriptingLibraryModel[] EMPTY_ARRAY = new ScriptingLibraryModel[0];
    private String myName;
    private final Set<VirtualFile> mySourceFiles;
    private final Set<VirtualFile> myCompactFiles;
    private final Set<String> myDocUrls;
    private LibraryLevel myLibraryLevel;
    private ScriptingFrameworkDescriptor myFrameworkDescriptor;
    private Library myOriginalLibrary;
    private Set<Module> myAssociatedModules;
    private boolean myIsOnByDefault;

    public ScriptingLibraryModel(@NotNull String name, @NotNull VirtualFile[] sourceFiles, @NotNull VirtualFile[] compactFiles, @NotNull String[] docUrls, @NotNull LibraryLevel level, boolean isOnByDefault) {
        if (name == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(0);
        }
        if (sourceFiles == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(1);
        }
        if (compactFiles == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(2);
        }
        if (docUrls == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(3);
        }
        if (level == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(4);
        }
        this(name, level);
        this.setSourceFiles(sourceFiles);
        this.myCompactFiles.addAll(Arrays.asList(compactFiles));
        this.myDocUrls.addAll(Arrays.asList(docUrls));
        this.myIsOnByDefault = isOnByDefault;
    }

    public static ScriptingLibraryModel createPredefinedLibrary(String name, VirtualFile[] sourceFiles, boolean isOnByDefault) {
        return new ScriptingLibraryModel(name, sourceFiles, VirtualFile.EMPTY_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, LibraryLevel.PREDEFINED, isOnByDefault);
    }

    public static ScriptingLibraryModel createPredefinedLibrary(String name, VirtualFile[] sourceFiles, String extDocUrl, boolean isOnByDefault) {
        return new ScriptingLibraryModel(name, sourceFiles, VirtualFile.EMPTY_ARRAY, new String[]{extDocUrl}, LibraryLevel.PREDEFINED, isOnByDefault);
    }

    public ScriptingLibraryModel(@Nullable String name, LibraryLevel libraryLevel) {
        this.mySourceFiles = new HashSet<VirtualFile>();
        this.myCompactFiles = new HashSet<VirtualFile>();
        this.myDocUrls = new TreeSet<String>();
        this.myName = name;
        this.myLibraryLevel = libraryLevel;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public void setSourceFiles(VirtualFile[] files) {
        this.mySourceFiles.clear();
        Collections.addAll(this.mySourceFiles, files);
    }

    public void setCompactFiles(VirtualFile[] files) {
        this.myCompactFiles.clear();
        this.myCompactFiles.addAll(Arrays.asList(files));
    }

    public void setDocUrls(String[] docUrls) {
        this.myDocUrls.clear();
        this.myDocUrls.addAll(Arrays.asList(docUrls));
    }

    @NotNull
    public Set<VirtualFile> getSourceFiles() {
        Set<VirtualFile> set = this.mySourceFiles;
        if (set == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(5);
        }
        return set;
    }

    public Set<VirtualFile> getCompactFiles() {
        return this.myCompactFiles;
    }

    public Set<String> getDocUrls() {
        return this.myDocUrls;
    }

    @NotNull
    public Set<VirtualFile> getAllFiles() {
        HashSet compactAndSourceFiles = ContainerUtil.newHashSet(this.getSourceFiles());
        compactAndSourceFiles.addAll(this.myCompactFiles);
        HashSet hashSet = compactAndSourceFiles;
        if (hashSet == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean containsFile(VirtualFile file) {
        return this.getSourceFiles().contains(file) || this.myCompactFiles.contains(file);
    }

    public boolean isEmpty() {
        return this.getSourceFiles().isEmpty() && this.myCompactFiles.isEmpty();
    }

    public String toString() {
        return this.myName + (this.isPredefined() ? " (Predefined)" : "");
    }

    public boolean isPredefined() {
        return this.myLibraryLevel == LibraryLevel.PREDEFINED;
    }

    public LibraryLevel getLibraryLevel() {
        return this.myLibraryLevel;
    }

    public ScriptingFrameworkDescriptor getFrameworkDescriptor() {
        return this.myFrameworkDescriptor;
    }

    public void setFrameworkDescriptor(ScriptingFrameworkDescriptor frameworkDescriptor) {
        this.myFrameworkDescriptor = frameworkDescriptor;
    }

    void setOriginalLibrary(@Nullable Library originalLibrary) {
        this.myOriginalLibrary = originalLibrary;
    }

    @Nullable
    public Library getOriginalLibrary() {
        return this.myOriginalLibrary;
    }

    public void setLibraryLevel(LibraryLevel libraryLevel) {
        assert (libraryLevel == LibraryLevel.PROJECT || libraryLevel == LibraryLevel.GLOBAL) : "Only Global or Project level is allowed here";
        if (libraryLevel != this.myLibraryLevel) {
            this.myLibraryLevel = libraryLevel;
            this.myOriginalLibrary = null;
        }
    }

    public void setAssociatedModules(Set<Module> modules) {
        this.myAssociatedModules = modules;
    }

    public boolean hasAssociatedModules() {
        return this.myAssociatedModules != null && !this.myAssociatedModules.isEmpty();
    }

    public boolean isAssociatedWith(Module module) {
        return this.myAssociatedModules != null && this.myAssociatedModules.contains(module);
    }

    public Set<Module> getAssociatedModules() {
        return this.myAssociatedModules;
    }

    public boolean isOnByDefault() {
        return this.myIsOnByDefault;
    }

    @NotNull
    public static ScriptingLibraryModel[] toArray(@NotNull Collection<ScriptingLibraryModel> collection) {
        if (collection == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(8);
        }
        ScriptingLibraryModel[] scriptingLibraryModelArray = collection.toArray(new ScriptingLibraryModel[0]);
        if (scriptingLibraryModelArray == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(9);
        }
        return scriptingLibraryModelArray;
    }

    public void addSignificantFiles(Collection<VirtualFile> result) {
        Set<VirtualFile> sourceFiles = this.getSourceFiles();
        if (!sourceFiles.isEmpty()) {
            result.addAll(sourceFiles);
        } else {
            result.addAll(this.myCompactFiles);
        }
    }

    public boolean shouldIndexSourcesWithoutMappings() {
        return true;
    }

    public void collectFilesWithGlobalDefinitions(@NotNull Collection<VirtualFile> result) {
        if (result == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(10);
        }
        this.addSignificantFiles(result);
    }

    @NotNull
    public List<VirtualFile> getDefaultMappings() {
        List<Object> list = this.myIsOnByDefault ? Collections.singletonList(null) : Collections.emptyList();
        if (list == null) {
            ScriptingLibraryModel.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compactFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docUrls";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ScriptingLibraryModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ScriptingLibraryModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectFilesWithGlobalDefinitions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum LibraryLevel {
        PREDEFINED,
        GLOBAL,
        PROJECT;

    }
}

