/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.qunit;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JstdRunElement;
import com.intellij.javascript.testFramework.qunit.AbstractQUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.DefaultQUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitTestMethodStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QUnitFileStructure
extends AbstractTestFileStructure {
    private final List<QUnitModuleStructure> myNonDefaultModuleStructures;
    private final Map<String, QUnitModuleStructure> myNonDefaultModuleStructureByNameMap;
    private final DefaultQUnitModuleStructure myDefaultModuleStructure;
    private Map<JSCallExpression, String> myNameByPsiElementMap;

    public QUnitFileStructure(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            QUnitFileStructure.$$$reportNull$$$0(0);
        }
        super(jsFile);
        this.myNonDefaultModuleStructures = Lists.newArrayList();
        this.myNonDefaultModuleStructureByNameMap = Maps.newHashMap();
        this.myDefaultModuleStructure = new DefaultQUnitModuleStructure(this);
    }

    @Override
    public boolean isEmpty() {
        return !this.hasQUnitSymbols();
    }

    @NotNull
    public List<QUnitModuleStructure> getNonDefaultModuleStructures() {
        List<QUnitModuleStructure> list = this.myNonDefaultModuleStructures;
        if (list == null) {
            QUnitFileStructure.$$$reportNull$$$0(1);
        }
        return list;
    }

    public int getAllModuleCount() {
        return this.myNonDefaultModuleStructures.size() + 1;
    }

    public int getNonDefaultModuleCount() {
        return this.myNonDefaultModuleStructures.size();
    }

    public void addModuleStructure(@NotNull QUnitModuleStructure moduleStructure) {
        if (moduleStructure == null) {
            QUnitFileStructure.$$$reportNull$$$0(2);
        }
        this.myNonDefaultModuleStructureByNameMap.put(moduleStructure.getName(), moduleStructure);
        this.myNonDefaultModuleStructures.add(moduleStructure);
    }

    @Nullable
    public String getNameByPsiElement(@NotNull JSCallExpression psiElement) {
        if (psiElement == null) {
            QUnitFileStructure.$$$reportNull$$$0(3);
        }
        return this.myNameByPsiElementMap.get(psiElement);
    }

    @Nullable
    public AbstractQUnitModuleStructure findQUnitModuleByName(@NotNull String qunitModuleName) {
        AbstractQUnitModuleStructure moduleStructure;
        if (qunitModuleName == null) {
            QUnitFileStructure.$$$reportNull$$$0(4);
        }
        if ((moduleStructure = (AbstractQUnitModuleStructure)this.myNonDefaultModuleStructureByNameMap.get(qunitModuleName)) == null && this.myDefaultModuleStructure.getName().equals(qunitModuleName)) {
            moduleStructure = this.myDefaultModuleStructure;
        }
        return moduleStructure;
    }

    @NotNull
    public DefaultQUnitModuleStructure getDefaultModuleStructure() {
        DefaultQUnitModuleStructure defaultQUnitModuleStructure = this.myDefaultModuleStructure;
        if (defaultQUnitModuleStructure == null) {
            QUnitFileStructure.$$$reportNull$$$0(5);
        }
        return defaultQUnitModuleStructure;
    }

    public boolean hasQUnitSymbols() {
        return this.myDefaultModuleStructure.getTestCount() > 0 || this.getNonDefaultModuleCount() > 0;
    }

    @Nullable
    public QUnitModuleStructure findModuleStructureContainingOffset(int offset) {
        for (QUnitModuleStructure moduleStructure : this.myNonDefaultModuleStructures) {
            TextRange moduleTextRange = moduleStructure.getEnclosingCallExpression().getTextRange();
            if (!JsPsiUtils.containsOffsetStrictly(moduleTextRange, offset)) continue;
            return moduleStructure;
        }
        return null;
    }

    @Nullable
    public QUnitTestMethodStructure findTestMethodStructureContainingOffset(int offset) {
        QUnitTestMethodStructure testMethodStructure = this.myDefaultModuleStructure.findTestMethodStructureContainingOffset(offset);
        if (testMethodStructure != null) {
            return testMethodStructure;
        }
        for (QUnitModuleStructure moduleStructure : this.myNonDefaultModuleStructures) {
            testMethodStructure = moduleStructure.findTestMethodStructureContainingOffset(offset);
            if (testMethodStructure == null) continue;
            return testMethodStructure;
        }
        return null;
    }

    @Override
    @Nullable
    public JstdRunElement findJstdRunElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            QUnitFileStructure.$$$reportNull$$$0(6);
        }
        for (QUnitModuleStructure nonDefaultModuleStructure : this.myNonDefaultModuleStructures) {
            JstdRunElement jstdRunElement = nonDefaultModuleStructure.findJstdRunElement(textRange);
            if (jstdRunElement == null) continue;
            return jstdRunElement;
        }
        return this.myDefaultModuleStructure.findJstdRunElement(textRange);
    }

    @Override
    public PsiElement findPsiElement(@NotNull String testCaseName, @Nullable String testMethodName) {
        AbstractQUnitModuleStructure qunitModuleStructure;
        if (testCaseName == null) {
            QUnitFileStructure.$$$reportNull$$$0(7);
        }
        if ((qunitModuleStructure = this.findQUnitModuleByName(testCaseName)) != null) {
            if (testMethodName != null) {
                QUnitTestMethodStructure test = qunitModuleStructure.getTestMethodStructureByName(testMethodName);
                if (test != null) {
                    return test.getCallExpression();
                }
            } else {
                QUnitModuleStructure nonDefault = (QUnitModuleStructure)ObjectUtils.tryCast((Object)qunitModuleStructure, QUnitModuleStructure.class);
                if (nonDefault != null) {
                    return nonDefault.getEnclosingCallExpression();
                }
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> getTopLevelElements() {
        ArrayList<String> out = new ArrayList<String>(this.myNonDefaultModuleStructures.size() + 1);
        if (this.myDefaultModuleStructure.getTestCount() > 0) {
            out.add(this.myDefaultModuleStructure.getName());
        }
        for (QUnitModuleStructure structure : this.myNonDefaultModuleStructures) {
            out.add(structure.getName());
        }
        ArrayList<String> arrayList = out;
        if (arrayList == null) {
            QUnitFileStructure.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<String> getChildrenOf(@NotNull String topLevelElementName) {
        AbstractQUnitModuleStructure moduleStructure;
        if (topLevelElementName == null) {
            QUnitFileStructure.$$$reportNull$$$0(9);
        }
        if ((moduleStructure = this.findQUnitModuleByName(topLevelElementName)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                QUnitFileStructure.$$$reportNull$$$0(10);
            }
            return list;
        }
        ArrayList<String> out = new ArrayList<String>(moduleStructure.getTestCount());
        for (QUnitTestMethodStructure methodStructure : moduleStructure.getTestMethodStructures()) {
            out.add("test " + methodStructure.getName());
        }
        ArrayList<String> arrayList = out;
        if (arrayList == null) {
            QUnitFileStructure.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Override
    public boolean contains(@NotNull String testCaseName, @Nullable String testMethodName) {
        AbstractQUnitModuleStructure qunitModuleStructure;
        if (testCaseName == null) {
            QUnitFileStructure.$$$reportNull$$$0(12);
        }
        if ((qunitModuleStructure = this.findQUnitModuleByName(testCaseName)) == null) {
            return false;
        }
        if (testMethodName != null) {
            QUnitTestMethodStructure test = qunitModuleStructure.getTestMethodStructureByName(testMethodName);
            return test != null;
        }
        return true;
    }

    void postProcess() {
        this.myNameByPsiElementMap = this.createNameByPsiElementMap();
    }

    @NotNull
    private Map<JSCallExpression, String> createNameByPsiElementMap() {
        int count = this.myDefaultModuleStructure.getTestCount();
        for (QUnitModuleStructure nonDefaultModuleStructure : this.myNonDefaultModuleStructures) {
            count += nonDefaultModuleStructure.getTestCount() + 1;
        }
        if (count == 0) {
            Map<JSCallExpression, String> map = Collections.emptyMap();
            if (map == null) {
                QUnitFileStructure.$$$reportNull$$$0(13);
            }
            return map;
        }
        IdentityHashMap<JSCallExpression, String> nameMap = new IdentityHashMap<JSCallExpression, String>(count);
        for (QUnitModuleStructure moduleStructure : this.myNonDefaultModuleStructures) {
            JSCallExpression moduleElement = moduleStructure.getEnclosingCallExpression();
            nameMap.put(moduleElement, moduleStructure.getName());
            QUnitFileStructure.handleModuleStructure(moduleStructure, nameMap);
        }
        QUnitFileStructure.handleModuleStructure(this.myDefaultModuleStructure, nameMap);
        IdentityHashMap<JSCallExpression, String> identityHashMap = nameMap;
        if (identityHashMap == null) {
            QUnitFileStructure.$$$reportNull$$$0(14);
        }
        return identityHashMap;
    }

    private static void handleModuleStructure(@NotNull AbstractQUnitModuleStructure moduleStructure, @NotNull Map<JSCallExpression, String> nameMap) {
        if (moduleStructure == null) {
            QUnitFileStructure.$$$reportNull$$$0(15);
        }
        if (nameMap == null) {
            QUnitFileStructure.$$$reportNull$$$0(16);
        }
        for (QUnitTestMethodStructure testMethodStructure : moduleStructure.getTestMethodStructures()) {
            JSCallExpression methodElement = testMethodStructure.getCallExpression();
            nameMap.put(methodElement, testMethodStructure.getName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/qunit/QUnitFileStructure";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleStructure";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qunitModuleName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCaseName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelElementName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/qunit/QUnitFileStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonDefaultModuleStructures";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultModuleStructure";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelElements";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOf";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createNameByPsiElementMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addModuleStructure";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNameByPsiElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findQUnitModuleByName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findJstdRunElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findPsiElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOf";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "handleModuleStructure";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

