/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.GotItPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotItMessage {
    @NotNull
    private final String myTitle;
    @NotNull
    private final String myMessage;
    private Disposable myDisposable;
    private Runnable myCallback;
    private HyperlinkListener myHyperlinkListener;
    private boolean myShowCallout;

    private GotItMessage(@NotNull String title, @NotNull String message) {
        if (title == null) {
            GotItMessage.$$$reportNull$$$0(0);
        }
        if (message == null) {
            GotItMessage.$$$reportNull$$$0(1);
        }
        this.myHyperlinkListener = BrowserHyperlinkListener.INSTANCE;
        this.myShowCallout = true;
        this.myTitle = title;
        this.myMessage = "<html><body><div style='font-family: " + UIUtil.getLabelFont().getFontName() + "; font-size: " + JBUI.scale((int)12) + "pt; color: " + "#BBDDFF" + ";'>" + StringUtil.replace((String)message, (String)"\n", (String)"<br>") + "</div></body></html>";
    }

    public static GotItMessage createMessage(@NotNull String title, @NotNull String message) {
        if (title == null) {
            GotItMessage.$$$reportNull$$$0(2);
        }
        if (message == null) {
            GotItMessage.$$$reportNull$$$0(3);
        }
        return new GotItMessage(title, message);
    }

    public GotItMessage setDisposable(Disposable disposable) {
        this.myDisposable = disposable;
        return this;
    }

    public GotItMessage setCallback(@Nullable Runnable callback) {
        this.myCallback = callback;
        return this;
    }

    public GotItMessage setHyperlinkListener(@Nullable HyperlinkListener hyperlinkListener) {
        this.myHyperlinkListener = hyperlinkListener;
        return this;
    }

    public GotItMessage setShowCallout(boolean showCallout) {
        this.myShowCallout = showCallout;
        return this;
    }

    public void show(RelativePoint point, Balloon.Position position) {
        if (this.myDisposable != null && Disposer.isDisposed((Disposable)this.myDisposable)) {
            return;
        }
        GotItPanel panel = new GotItPanel();
        panel.myTitle.setText(this.myTitle);
        panel.myMessage.setText(this.myMessage);
        if (this.myHyperlinkListener != null) {
            panel.myMessage.addHyperlinkListener(this.myHyperlinkListener);
        }
        panel.myRoot.setBackground((Color)GotItPanel.BACKGROUND);
        panel.myMessagePanel.setOpaque(false);
        panel.myButton.setCursor(Cursor.getPredefinedCursor(12));
        panel.myButtonLabel.setText(panel.myButtonLabel.getText().toUpperCase());
        BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)panel.myRoot);
        if (this.myDisposable != null) {
            builder.setDisposable(this.myDisposable);
        }
        final Balloon balloon = builder.setFillColor((Color)GotItPanel.BACKGROUND).setHideOnClickOutside(false).setHideOnAction(false).setHideOnFrameResize(false).setHideOnKeyOutside(false).setShowCallout(this.myShowCallout).setBlockClicksThroughBalloon(true).createBalloon();
        panel.myButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                balloon.hide();
                if (GotItMessage.this.myCallback != null) {
                    GotItMessage.this.myCallback.run();
                }
            }
        });
        balloon.show(point, position);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/GotItMessage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

