/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.RowSorter;
import javax.swing.Scrollable;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ColumnTreeBuilder {
    @NotNull
    private final JTree myTree;
    @NotNull
    private final ColumnTreeCellRenderer myCellRenderer;
    @NotNull
    private final JTable myTable;
    @NotNull
    private final TableRowSorter<TableModel> myRowSorter;
    @NotNull
    private final DefaultTableModel myTableModel;
    private TreeSorter myTreeSorter;
    @NotNull
    private List<ColumnBuilder> myColumnBuilders;
    private Border myBorder;
    private Color myBackground;
    private Color myHoverColor;

    public ColumnTreeBuilder(@NotNull JTree tree) {
        if (tree == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(0);
        }
        this(tree, null);
    }

    public ColumnTreeBuilder(@NotNull JTree tree, TableColumnModel tableColumnModel) {
        if (tree == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(1);
        }
        this.myTree = tree;
        this.myTableModel = new DefaultTableModel();
        this.myTable = new JBTable((TableModel)this.myTableModel, tableColumnModel);
        this.myTable.setAutoCreateColumnsFromModel(true);
        this.myTable.setShowVerticalLines(false);
        this.myTable.setFocusable(false);
        this.myCellRenderer = new ColumnTreeCellRenderer(this.myTree, this.myTable.getColumnModel());
        this.myRowSorter = new TableRowSorter<TableModel>(this.myTable.getModel());
        this.myColumnBuilders = new LinkedList<ColumnBuilder>();
    }

    public ColumnTreeBuilder setTreeSorter(@NotNull TreeSorter<?> sorter) {
        if (sorter == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(2);
        }
        this.myTreeSorter = sorter;
        return this;
    }

    public ColumnTreeBuilder setBorder(@NotNull Border border) {
        if (border == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(3);
        }
        this.myBorder = border;
        return this;
    }

    public ColumnTreeBuilder setBackground(@NotNull Color background) {
        if (background == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(4);
        }
        this.myBackground = background;
        return this;
    }

    public ColumnTreeBuilder setHoverColor(@NotNull Color hoverColor) {
        if (hoverColor == null) {
            ColumnTreeBuilder.$$$reportNull$$$0(5);
        }
        this.myHoverColor = hoverColor;
        return this;
    }

    public ColumnTreeBuilder setShowVerticalLines(boolean showVerticalLines) {
        this.myTable.setShowVerticalLines(showVerticalLines);
        return this;
    }

    public ColumnTreeBuilder setTableFocusable(boolean focusable) {
        this.myTable.setFocusable(focusable);
        return this;
    }

    public JComponent build() {
        boolean showsRootHandles = this.myTree.getShowsRootHandles();
        ColumnTreeHoverListener hoverListener = this.myHoverColor != null ? ColumnTreeHoverListener.create(this.myTree) : null;
        this.myTree.setUI((TreeUI)((Object)new ColumnTreeUI(this.myHoverColor, hoverListener, this.myTable)));
        this.myTree.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("UI") && !(evt.getNewValue() instanceof ColumnTreeUI)) {
                this.myTree.setUI((TreeUI)((Object)new ColumnTreeUI(this.myHoverColor, hoverListener, this.myTable)));
            }
        });
        this.myTree.setShowsRootHandles(showsRootHandles);
        this.myTree.setCellRenderer(this.myCellRenderer);
        this.myTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
                ColumnTreeBuilder.this.myTree.revalidate();
                ColumnTreeBuilder.this.myTree.repaint();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
        this.myTable.setRowSorter(this.myRowSorter);
        this.myRowSorter.addRowSorterListener(event -> {
            if (this.myTreeSorter != null && !this.myRowSorter.getSortKeys().isEmpty()) {
                RowSorter.SortKey key = this.myRowSorter.getSortKeys().get(0);
                Comparator<?> comparator = this.myRowSorter.getComparator(key.getColumn());
                Enumeration<TreePath> expanded = this.myTree.getExpandedDescendants(new TreePath(this.myTree.getModel().getRoot()));
                comparator = key.getSortOrder() == SortOrder.ASCENDING ? comparator : Collections.reverseOrder(comparator);
                this.myTreeSorter.sort(comparator, key.getSortOrder());
                if (expanded != null) {
                    while (expanded.hasMoreElements()) {
                        this.myTree.expandPath(expanded.nextElement());
                    }
                }
            }
        });
        this.myTable.setAutoResizeMode(1);
        for (ColumnBuilder column : this.myColumnBuilders) {
            column.create(this.myTableModel);
        }
        for (int i = 0; i < this.myColumnBuilders.size(); ++i) {
            ColumnBuilder column;
            column = this.myColumnBuilders.get(i);
            column.configure(i, this.myTable, this.myRowSorter, this.myCellRenderer);
        }
        TreeWrapperPanel panel = new TreeWrapperPanel(this.myTable, this.myTree);
        if (this.myBackground != null) {
            panel.setBackground(this.myBackground);
        }
        JTableHeader header = this.myTable.getTableHeader();
        header.setReorderingAllowed(false);
        JViewport viewport = new JViewport();
        viewport.setView(header);
        JBScrollPane scrollPane = new JBScrollPane((Component)panel);
        scrollPane.setColumnHeader(viewport);
        scrollPane.setHorizontalScrollBarPolicy(31);
        if (this.myBorder != null) {
            scrollPane.setBorder(this.myBorder);
        }
        return scrollPane;
    }

    public ColumnTreeBuilder addColumn(ColumnBuilder column) {
        this.myColumnBuilders.add(column);
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sorter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "border";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hoverColor";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/adtui/common/ColumnTreeBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setTreeSorter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setBorder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setBackground";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setHoverColor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ColumnTreeHoverListener
    extends MouseAdapter {
        public static final ColumnTreeHoverListener EMPTY_LISTENER = new ColumnTreeHoverListener(){

            @Override
            public int getHoveredRow() {
                return -1;
            }
        };
        private int myHoveredRow = -1;

        private ColumnTreeHoverListener() {
        }

        public static ColumnTreeHoverListener create(@NotNull JTree tree) {
            if (tree == null) {
                ColumnTreeHoverListener.$$$reportNull$$$0(0);
            }
            ColumnTreeHoverListener config = new ColumnTreeHoverListener();
            tree.addMouseListener(config);
            tree.addMouseMotionListener(config);
            return config;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            int row = ColumnTreeHoverListener.getRowForLocation(tree, e.getX(), e.getY());
            if (row != this.myHoveredRow) {
                int oldHoveredRow = this.myHoveredRow;
                this.myHoveredRow = row;
                if (oldHoveredRow != -1) {
                    tree.repaint(ColumnTreeHoverListener.getHoverBounds(tree, oldHoveredRow));
                }
                if (this.myHoveredRow != -1) {
                    tree.repaint(ColumnTreeHoverListener.getHoverBounds(tree, this.myHoveredRow));
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            if (this.myHoveredRow != -1) {
                int oldHoveredRow = this.myHoveredRow;
                this.myHoveredRow = -1;
                tree.repaint(ColumnTreeHoverListener.getHoverBounds(tree, oldHoveredRow));
            }
        }

        public int getHoveredRow() {
            return this.myHoveredRow;
        }

        private static Rectangle getHoverBounds(JTree tree, int row) {
            Rectangle bounds = tree.getRowBounds(row);
            return new Rectangle(0, bounds.y, bounds.width + bounds.x, bounds.height);
        }

        private static int getRowForLocation(JTree tree, int x, int y) {
            int row = tree.getClosestRowForLocation(x, y);
            if (row != -1 && ColumnTreeHoverListener.getHoverBounds(tree, row).contains(x, y)) {
                return row;
            }
            return -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/adtui/common/ColumnTreeBuilder$ColumnTreeHoverListener", "create"));
        }
    }

    private static class TreeWrapperPanel
    extends JPanel
    implements Scrollable {
        @NotNull
        private final JTree myTree;

        public TreeWrapperPanel(JTable table, JTree tree) {
            super(new BorderLayout());
            this.myTree = tree;
            this.add((Component)table, "North");
            this.add((Component)this.myTree, "Center");
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.myTree.getPreferredScrollableViewportSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.myTree.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return this.myTree.getScrollableUnitIncrement(visibleRect, orientation, direction);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            Container parent = SwingUtilities.getUnwrappedParent(this);
            if (parent instanceof JViewport) {
                return parent.getWidth() > this.myTree.getPreferredSize().width;
            }
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            Container parent = SwingUtilities.getUnwrappedParent(this);
            if (parent instanceof JViewport) {
                return parent.getHeight() > this.myTree.getPreferredSize().height;
            }
            return false;
        }
    }

    public static class ColumnBuilder {
        private String myName;
        private int myWidth;
        private int myHeaderAlignment;
        private Border myHeaderBorder;
        private Comparator<?> myComparator;
        private ColoredTreeCellRenderer myRenderer;
        private SortOrder myInitialOrder = SortOrder.UNSORTED;

        public ColumnBuilder setName(String name) {
            this.myName = name;
            return this;
        }

        public ColumnBuilder setPreferredWidth(int width) {
            this.myWidth = width;
            return this;
        }

        public ColumnBuilder setHeaderAlignment(int alignment) {
            this.myHeaderAlignment = alignment;
            return this;
        }

        public ColumnBuilder setHeaderBorder(Border border) {
            this.myHeaderBorder = border;
            return this;
        }

        public void create(DefaultTableModel model) {
            model.addColumn(this.myName);
        }

        private void configure(int index, JTable table, TableRowSorter<TableModel> sorter, ColumnTreeCellRenderer renderer) {
            TableColumn column = table.getColumnModel().getColumn(index);
            column.setPreferredWidth(this.myWidth);
            final TableCellRenderer tableCellRenderer = table.getTableHeader().getDefaultRenderer();
            column.setHeaderRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (component instanceof JLabel) {
                        ((JLabel)component).setHorizontalAlignment(myHeaderAlignment);
                    }
                    if (component instanceof JComponent) {
                        ((JComponent)component).setBorder(myHeaderBorder);
                    }
                    return component;
                }
            });
            if (this.myComparator != null) {
                sorter.setComparator(column.getModelIndex(), this.myComparator);
                if (this.myInitialOrder != SortOrder.UNSORTED) {
                    sorter.setSortKeys(Collections.singletonList(new RowSorter.SortKey(column.getModelIndex(), this.myInitialOrder)));
                }
            } else {
                sorter.setSortable(column.getModelIndex(), false);
            }
            assert (this.myRenderer != null);
            renderer.add((Component)this.myRenderer);
        }

        public ColumnBuilder setComparator(@NotNull Comparator<?> comparator) {
            if (comparator == null) {
                ColumnBuilder.$$$reportNull$$$0(0);
            }
            this.myComparator = comparator;
            return this;
        }

        public ColumnBuilder setRenderer(@NotNull ColoredTreeCellRenderer renderer) {
            if (renderer == null) {
                ColumnBuilder.$$$reportNull$$$0(1);
            }
            this.myRenderer = renderer;
            return this;
        }

        public ColumnBuilder setInitialOrder(@NotNull SortOrder initialOrder) {
            if (initialOrder == null) {
                ColumnBuilder.$$$reportNull$$$0(2);
            }
            this.myInitialOrder = initialOrder;
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comparator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialOrder";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/adtui/common/ColumnTreeBuilder$ColumnBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setComparator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setRenderer";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setInitialOrder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ColumnTreeUI
    extends WideSelectionTreeUI {
        private int myWidth = -1;
        @NotNull
        private final Color myHoverColor;
        @NotNull
        private final ColumnTreeHoverListener myHoverConfig;
        private final JTable myTable;

        ColumnTreeUI() {
            this(null, null, null);
        }

        ColumnTreeUI(Color hoverColor, ColumnTreeHoverListener hoverConfig, JTable table) {
            this.myHoverColor = hoverColor != null ? hoverColor : new JBColor(new Color(0, 0, 0, 0), new Color(0, 0, 0, 0));
            this.myHoverConfig = hoverConfig != null ? hoverConfig : ColumnTreeHoverListener.EMPTY_LISTENER;
            this.myTable = table;
        }

        public void paint(Graphics g, JComponent c) {
            if (this.myWidth != c.getWidth()) {
                this.treeState.invalidateSizes();
                this.myWidth = c.getWidth();
            }
            super.paint(g, c);
            if (this.myTable != null && this.myTable.getShowVerticalLines()) {
                g.setColor(this.myTable.getGridColor());
                int x = 0;
                for (int i = 0; i < this.myTable.getColumnModel().getColumnCount() - 1; ++i) {
                    TableColumn column = this.myTable.getColumnModel().getColumn(i);
                    g.drawLine((x += column.getWidth()) - 1, 0, x - 1, c.getHeight());
                }
            }
        }

        protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
            return new BasicTreeUI.NodeDimensionsHandler(){

                @Override
                public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle size) {
                    Rectangle dimensions = super.getNodeDimensions(value, row, depth, expanded, size);
                    dimensions.width = tree.getWidth() - this.getRowX(row, depth);
                    return dimensions;
                }
            };
        }

        protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
            if (row == this.myHoverConfig.getHoveredRow() && !this.tree.isPathSelected(path)) {
                Color originalColor = g.getColor();
                g.setColor(this.myHoverColor);
                g.fillRect(0, bounds.y, this.tree.getWidth(), bounds.height);
                g.setColor(originalColor);
            }
            super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    private static class ColumnTreeCellRenderer
    extends JPanel
    implements TreeCellRenderer {
        public ColumnTreeCellRenderer(JTree tree, TableColumnModel columnModel) {
            super(new ColumnLayout(tree, columnModel));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setFont(tree.getFont());
            String toolTip = null;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component c;
                Component component = this.getComponent(i);
                if (!(component instanceof ColoredTreeCellRenderer) || !((c = ((ColoredTreeCellRenderer)component).getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus)) instanceof JComponent) || toolTip != null) continue;
                toolTip = ((JComponent)c).getToolTipText();
            }
            this.setToolTipText(toolTip);
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension();
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Dimension size = this.getComponent(i).getPreferredSize();
                dimension.width += size.width;
                dimension.height = Math.max(dimension.height, size.height);
            }
            return dimension;
        }
    }

    private static class ColumnLayout
    implements LayoutManager {
        @NotNull
        private final TableColumnModel myColumnModel;
        @NotNull
        private final JTree myTree;

        public ColumnLayout(@NotNull JTree tree, @NotNull TableColumnModel columnModel) {
            if (tree == null) {
                ColumnLayout.$$$reportNull$$$0(0);
            }
            if (columnModel == null) {
                ColumnLayout.$$$reportNull$$$0(1);
            }
            this.myTree = tree;
            this.myColumnModel = columnModel;
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            int size = parent.getComponentCount();
            int columns = this.myColumnModel.getColumnCount();
            Insets insets = this.myTree.getInsets();
            assert (size == columns);
            int padding = this.myTree.getWidth();
            for (int i = 0; i < size && i < columns; ++i) {
                padding -= this.myColumnModel.getColumn(i).getWidth();
            }
            int offset = parent.getWidth() - (insets.left + insets.right);
            for (int i = size - 1; i >= 0; --i) {
                Component component = parent.getComponent(i);
                int columnWidth = this.myColumnModel.getColumn(i).getWidth();
                if (i == size - 1) {
                    columnWidth -= insets.right;
                }
                if (i == 0) {
                    columnWidth -= insets.left;
                }
                int width = Math.min(columnWidth + padding, offset);
                component.setBounds(offset - width, 0, width, parent.getHeight());
                offset -= width;
                padding = 0;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "columnModel";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/adtui/common/ColumnTreeBuilder$ColumnLayout";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface TreeSorter<T> {
        public void sort(Comparator<T> var1, SortOrder var2);
    }
}

