/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.common;

import com.google.common.collect.Maps;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class EnumColors<E extends Enum<E>> {
    @NotNull
    private final Map<E, List<Color>> myColors;
    private int myColorIndex;

    public EnumColors(@NotNull Map<E, Color> colors) {
        if (colors == null) {
            EnumColors.$$$reportNull$$$0(0);
        }
        this.myColors = Maps.newHashMap();
        colors.forEach((e, c) -> this.myColors.put(e, Collections.singletonList(c)));
    }

    private EnumColors(@NotNull Builder<E> builder) {
        if (builder == null) {
            EnumColors.$$$reportNull$$$0(1);
        }
        this.myColors = ((Builder)builder).myColors;
    }

    @NotNull
    public Color getColor(@NotNull E type) {
        List<Color> colorList;
        if (type == null) {
            EnumColors.$$$reportNull$$$0(2);
        }
        if ((colorList = this.myColors.get(type)) == null) {
            throw new IllegalStateException("No colors for value " + type);
        }
        Color color = colorList.get(this.myColorIndex % colorList.size());
        if (color == null) {
            EnumColors.$$$reportNull$$$0(3);
        }
        return color;
    }

    public void setColorIndex(int colorIndex) {
        this.myColorIndex = colorIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/common/EnumColors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/common/EnumColors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getColor";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Builder<E extends Enum<E>> {
        private final int myNumColorsPerType;
        private Map<E, List<Color>> myColors = Maps.newHashMap();

        public Builder(int numColorsPerType) {
            this.myNumColorsPerType = numColorsPerType;
        }

        @NotNull
        public Builder<E> add(@NotNull E type, Color ... colors) {
            if (type == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (colors.length != this.myNumColorsPerType) {
                throw new IllegalArgumentException(String.format("Attempting to initialize colors for %1$s with %2$d color(s), should be %3$d", type, colors.length, this.myNumColorsPerType));
            }
            this.myColors.put(type, Arrays.asList(colors));
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public EnumColors<E> build() {
            EnumColors enumColors = new EnumColors(this);
            if (enumColors == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return enumColors;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/common/EnumColors$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/common/EnumColors$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "add";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

