/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.Updater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AxisComponentModel
extends AspectModel<Aspect>
implements Updatable {
    @NotNull
    private final Range myRange;
    @NotNull
    private final BaseAxisFormatter myFormatter;
    @Nullable
    private Range myGlobalRange;
    private boolean myClampToMajorTicks;
    @NotNull
    private String myLabel;
    private boolean myFirstUpdate;

    public AxisComponentModel(@NotNull Range range, @NotNull BaseAxisFormatter formatter) {
        if (range == null) {
            AxisComponentModel.$$$reportNull$$$0(0);
        }
        if (formatter == null) {
            AxisComponentModel.$$$reportNull$$$0(1);
        }
        this.myClampToMajorTicks = false;
        this.myLabel = "";
        this.myFirstUpdate = true;
        this.myRange = range;
        this.myFormatter = formatter;
    }

    @Override
    public void update(long elapsedNs) {
        if (this.myClampToMajorTicks) {
            double maxTarget = this.myRange.getMax() - this.getZero();
            double rangeTarget = this.myRange.getLength();
            long majorInterval = this.myFormatter.getMajorInterval(rangeTarget);
            float majorNumTicksTarget = (float)Math.ceil(maxTarget / (double)majorInterval);
            double clampedMaxTarget = majorNumTicksTarget * (float)majorInterval;
            float fraction = this.myFirstUpdate ? 1.0f : 0.99f;
            this.myRange.setMax(Updater.lerp(this.myRange.getMax(), clampedMaxTarget += this.getZero(), fraction, elapsedNs, (double)((float)(clampedMaxTarget * (double)0.001f))));
        }
        this.myFirstUpdate = false;
        this.changed(Aspect.AXIS);
    }

    public void setGlobalRange(@NotNull Range globalRange) {
        if (globalRange == null) {
            AxisComponentModel.$$$reportNull$$$0(2);
        }
        this.myGlobalRange = globalRange;
    }

    public void setLabel(@NotNull String label) {
        if (label == null) {
            AxisComponentModel.$$$reportNull$$$0(3);
        }
        this.myLabel = label;
    }

    public void setClampToMajorTicks(boolean clampToMajorTicks) {
        this.myClampToMajorTicks = clampToMajorTicks;
    }

    @NotNull
    public String getLabel() {
        String string = this.myLabel;
        if (string == null) {
            AxisComponentModel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public Range getRange() {
        Range range = this.myRange;
        if (range == null) {
            AxisComponentModel.$$$reportNull$$$0(5);
        }
        return range;
    }

    @Nullable
    public Range getGlobalRange() {
        return this.myGlobalRange;
    }

    @NotNull
    public BaseAxisFormatter getFormatter() {
        BaseAxisFormatter baseAxisFormatter = this.myFormatter;
        if (baseAxisFormatter == null) {
            AxisComponentModel.$$$reportNull$$$0(6);
        }
        return baseAxisFormatter;
    }

    public double getZero() {
        return this.myGlobalRange != null ? this.myGlobalRange.getMin() : this.myRange.getMin();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/model/AxisComponentModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/model/AxisComponentModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setGlobalRange";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setLabel";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Aspect {
        AXIS;

    }
}

