/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.workbench;

import com.android.tools.adtui.workbench.WorkBench;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.intellij.openapi.components.ServiceManager;
import java.util.Collection;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class WorkBenchManager {
    private Multimap<String, WorkBench> myWorkBenches = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());

    public static WorkBenchManager getInstance() {
        return (WorkBenchManager)ServiceManager.getService(WorkBenchManager.class);
    }

    public void register(@NotNull WorkBench workBench) {
        if (workBench == null) {
            WorkBenchManager.$$$reportNull$$$0(0);
        }
        this.myWorkBenches.put((Object)workBench.getName(), (Object)workBench);
    }

    public void unregister(@NotNull WorkBench workBench) {
        if (workBench == null) {
            WorkBenchManager.$$$reportNull$$$0(1);
        }
        this.myWorkBenches.remove((Object)workBench.getName(), (Object)workBench);
    }

    public void storeDefaultLayout() {
        for (String name : this.myWorkBenches.keySet()) {
            Optional workbench = this.myWorkBenches.get((Object)name).stream().findFirst();
            if (!workbench.isPresent()) continue;
            ((WorkBench)((Object)workbench.get())).storeDefaultLayout();
            this.updateOtherWorkBenches((WorkBench)((Object)workbench.get()));
        }
    }

    public void restoreDefaultLayout() {
        for (String name : this.myWorkBenches.keySet()) {
            Optional workbench = this.myWorkBenches.get((Object)name).stream().findFirst();
            if (!workbench.isPresent()) continue;
            ((WorkBench)((Object)workbench.get())).restoreDefaultLayout();
            this.updateOtherWorkBenches((WorkBench)((Object)workbench.get()));
        }
    }

    public void updateOtherWorkBenches(@NotNull WorkBench workBench) {
        if (workBench == null) {
            WorkBenchManager.$$$reportNull$$$0(2);
        }
        Collection workBenches = this.myWorkBenches.get((Object)workBench.getName());
        workBenches.stream().filter(bench -> {
            if (workBench == null) {
                WorkBenchManager.$$$reportNull$$$0(3);
            }
            return bench != workBench;
        }).forEach(WorkBench::updateModel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "workBench";
        objectArray2[1] = "com/android/tools/adtui/workbench/WorkBenchManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "unregister";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updateOtherWorkBenches";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$updateOtherWorkBenches$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

