/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JList;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.driver.BasicCellRendererReader;
import org.fest.swing.driver.CellRendererReader;
import org.fest.swing.driver.ModelValueToString;
import org.fest.util.Preconditions;

public class BasicJListCellReader
implements JListCellReader {
    private final CellRendererReader rendererReader;

    public BasicJListCellReader() {
        this(new BasicCellRendererReader());
    }

    public BasicJListCellReader(@Nonnull CellRendererReader rendererReader) {
        this.rendererReader = (CellRendererReader)Preconditions.checkNotNull((Object)rendererReader);
    }

    @Override
    @Nullable
    @RunsInCurrentThread
    public String valueAt(@Nonnull JList list, int index) {
        String value;
        Object element = list.getModel().getElementAt(index);
        Component c = list.getCellRenderer().getListCellRendererComponent(list, element, index, true, true);
        String string = value = c != null ? this.rendererReader.valueFrom(c) : null;
        if (value != null) {
            return value;
        }
        return ModelValueToString.asText(element);
    }
}

