/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JLabel;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JLabelTextQuery;
import org.fest.swing.driver.TextAssert;
import org.fest.swing.driver.TextDisplayDriver;
import org.fest.util.InternalApi;

@InternalApi
public class JLabelDriver
extends JComponentDriver
implements TextDisplayDriver<JLabel> {
    private static final String TEXT_PROPERTY = "text";

    public JLabelDriver(@Nonnull Robot robot) {
        super(robot);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull JLabel label, @Nullable String expected) {
        TextAssert.verifyThat(this.textOf(label)).as(JLabelDriver.propertyName(label, TEXT_PROPERTY)).isEqualOrMatches(expected);
    }

    @Override
    @RunsInEDT
    public void requireText(@Nonnull JLabel label, @Nonnull Pattern pattern) {
        TextAssert.verifyThat(this.textOf(label)).as(JLabelDriver.propertyName(label, TEXT_PROPERTY)).matches(pattern);
    }

    @Override
    @Nullable
    @RunsInEDT
    public String textOf(@Nonnull JLabel label) {
        return JLabelTextQuery.textOf(label);
    }
}

