/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.driver.JTableCellPreconditions;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiTask;
import org.fest.util.Preconditions;

final class JTableStopCellEditingTask {
    @RunsInEDT
    static void stopEditing(final @Nonnull TableCellEditor cellEditor) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JTableStopCellEditingTask.doStopCellEditing(cellEditor);
            }
        });
    }

    @RunsInEDT
    static void stopEditing(final @Nonnull JTable table, final int row, final int column) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JTableStopCellEditingTask.doStopCellEditing(table, row, column);
            }
        });
    }

    @RunsInEDT
    static void checkStateAndStopEditing(final @Nonnull JTable table, final int row, final int column) {
        GuiActionRunner.execute(new GuiTask(){

            @Override
            protected void executeInEDT() {
                JTableCellPreconditions.checkCellIndicesInBounds(table, row, column);
                JTableCellPreconditions.validateCellIsEditable(table, row, column);
                JTableStopCellEditingTask.doStopCellEditing(table, row, column);
            }
        });
    }

    @RunsInCurrentThread
    private static void doStopCellEditing(@Nonnull JTable table, int row, int column) {
        TableCellEditor editor = (TableCellEditor)Preconditions.checkNotNull((Object)table.getCellEditor(row, column));
        JTableStopCellEditingTask.doStopCellEditing(editor);
    }

    @RunsInCurrentThread
    private static void doStopCellEditing(@Nonnull TableCellEditor cellEditor) {
        Preconditions.checkNotNull((Object)cellEditor);
        cellEditor.stopCellEditing();
    }

    private JTableStopCellEditingTask() {
    }
}

