/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.main;

import com.intellij.rt.coverage.util.URLsUtil;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class CoveragePremain {
    public static void premain(String argsString, Instrumentation instrumentation) throws Exception {
        CoveragePremain.premain(argsString, instrumentation, "com.intellij.rt.coverage.instrumentation.Instrumentator", "coverage-instrumenter.jar");
    }

    public static void premain(String argsString, Instrumentation instrumentation, String instrumenterName, String ... jars) throws Exception {
        File lib = new File(CoveragePremain.getArchivePath()).getParentFile();
        URL[] urls = new URL[jars.length + 2];
        for (int idx = 0; idx < jars.length; ++idx) {
            urls[idx] = CoveragePremain.fileToURL(new File(lib, jars[idx]));
        }
        urls[jars.length] = CoveragePremain.fileToURL(new File(lib, "asm-all.jar"));
        urls[jars.length + 1] = CoveragePremain.fileToURL(new File(lib, "trove4j.jar"));
        Class<?> instrumentator = Class.forName(instrumenterName, true, new URLClassLoader(urls){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
                1 var3_3 = this;
                synchronized (var3_3) {
                    Class<?> result = this.findLoadedClass(name);
                    if (result == null) {
                        try {
                            result = this.findClass(name);
                        }
                        catch (ClassNotFoundException e) {
                            // empty catch block
                        }
                    }
                    if (result != null && resolve) {
                        this.resolveClass(result);
                    }
                    if (result != null) {
                        return result;
                    }
                }
                return this.getParent().loadClass(name);
            }
        });
        Method premainMethod = instrumentator.getDeclaredMethod("premain", String.class, Instrumentation.class);
        premainMethod.invoke(null, argsString, instrumentation);
    }

    private static URL fileToURL(File file) throws MalformedURLException {
        return file.getAbsoluteFile().toURI().toURL();
    }

    private static String getArchivePath() {
        String className = CoveragePremain.class.getName().replace('.', '/') + ".class";
        URL resourceURL = CoveragePremain.class.getResource("/" + className);
        if (resourceURL == null) {
            resourceURL = ClassLoader.getSystemResource(className);
        }
        return URLsUtil.extractRoot(resourceURL, "/" + className);
    }
}

