/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.FtlBuiltInDescriptor;
import com.intellij.freemarker.inspections.FtlSuppressableInspection;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlEnumReference;
import com.intellij.freemarker.psi.FtlExistsExpression;
import com.intellij.freemarker.psi.FtlIndexExpression;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlReferenceExpression;
import com.intellij.freemarker.psi.FtlReferenceQualifier;
import com.intellij.freemarker.psi.FtlResolveResult;
import com.intellij.freemarker.psi.FtlStringLiteral;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.variables.FtlImplicitVariable;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.resolve.JavaMethodResolveHelper;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlReferencesInspection
extends FtlSuppressableInspection {
    private static final ElementPattern<PsiElement> IN_MACRO_END = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)PsiJavaPatterns.psiElement((IElementType)FtlElementTypes.END_MACRO_START));
    public static final String SHORT_NAME = "FtlReferencesInspection";
    public boolean fieldsExposed = false;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FtlReferencesInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                FtlEnumReference enumReference;
                if (element instanceof FtlReferenceExpression) {
                    if (!IN_MACRO_END.accepts((Object)element)) {
                        FtlReferencesInspection.checkReference(((FtlReferenceExpression)element).getReference(), holder);
                    }
                } else if (element instanceof FtlIndexExpression) {
                    if (!IN_MACRO_END.accepts((Object)element)) {
                        FtlReferencesInspection.checkReference(((FtlIndexExpression)element).getQualifiedReference(), holder);
                    }
                } else if (element instanceof FtlStringLiteral && (enumReference = (FtlEnumReference)((Object)ContainerUtil.findInstance((Object[])element.getReferences(), FtlEnumReference.class))) != null) {
                    FtlReferencesInspection.checkEnumReference(enumReference, holder);
                }
            }
        };
        if (psiElementVisitor == null) {
            FtlReferencesInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static void checkEnumReference(FtlEnumReference reference, ProblemsHolder holder) {
        PsiClass enumClass = reference.getEnumClass();
        if (enumClass == null) {
            return;
        }
        if (reference.resolve() == null) {
            holder.registerProblem((PsiReference)reference, "Unknown enum constant '#ref' in class " + enumClass.getName(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    private static void checkReference(@Nullable FtlQualifiedReference reference, ProblemsHolder holder) {
        boolean hasResolveError;
        if (reference == null || reference.getAssignDeclaration() != null || FtlReferencesInspection.isDynamicReference(reference)) {
            return;
        }
        ResolveResult[] results = reference.multiResolve(false);
        JavaMethodResolveHelper.ErrorType resolveError = results.length > 0 && results[0] instanceof FtlResolveResult ? ((FtlResolveResult)results[0]).getResolveError() : JavaMethodResolveHelper.ErrorType.NONE;
        boolean bl = hasResolveError = resolveError != JavaMethodResolveHelper.ErrorType.NONE;
        if (!hasResolveError && FtlReferencesInspection.resolvesCorrectly(reference, results)) {
            FtlReferencesInspection.checkQualifierAccessibility(reference, holder);
            return;
        }
        holder.registerProblem((PsiReference)reference, reference.getUnresolvedMessage(resolveError), hasResolveError ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
    }

    private static void checkQualifierAccessibility(FtlQualifiedReference reference, ProblemsHolder holder) {
        if (reference.getElement().getParent() instanceof FtlInterpolation) {
            return;
        }
        FtlPsiType ftlPsiType = FtlPsiUtil.asInstanceOf(reference.getType(), FtlPsiType.class);
        if (ftlPsiType == null) {
            return;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)ftlPsiType.getPsiType());
        if (psiClass == null) {
            return;
        }
        if (!psiClass.hasModifierProperty("public")) {
            holder.registerProblem((PsiReference)reference, "Accessing non-public class '" + psiClass.getQualifiedName() + "'", ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    private static boolean resolvesCorrectly(FtlQualifiedReference reference, ResolveResult[] results) {
        if (reference.resolve() != null) {
            return true;
        }
        return results.length == 2 && ContainerUtil.find((Object[])results, result -> result.getElement() instanceof FtlImplicitVariable) != null;
    }

    private static boolean isDynamicReference(@NotNull FtlQualifiedReference reference) {
        FtlReferenceQualifier qualifier;
        if (reference == null) {
            FtlReferencesInspection.$$$reportNull$$$0(2);
        }
        if ((qualifier = reference.getReferenceQualifier()) != null) {
            FtlType qualifierType = qualifier.getType();
            if (qualifierType == null || FtlBuiltInDescriptor.HashBuiltIn.isHash(qualifierType)) {
                return true;
            }
            if (FtlReferencesInspection.isCustomNumberFormat(reference)) {
                return true;
            }
        }
        if (reference.isNodeChildrenAccessor()) {
            return true;
        }
        return reference.getElement().getParent() instanceof FtlExistsExpression;
    }

    private static boolean isCustomNumberFormat(@NotNull FtlQualifiedReference reference) {
        String name;
        if (reference == null) {
            FtlReferencesInspection.$$$reportNull$$$0(3);
        }
        return (name = reference.getReferenceName()) != null && name.startsWith("@");
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FreeMarkerBundle.message("freemarker.inspections.group", new Object[0]);
        if (string == null) {
            FtlReferencesInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FreeMarkerBundle.message("ftl.references.inspection", new Object[0]);
        if (string == null) {
            FtlReferencesInspection.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            FtlReferencesInspection.$$$reportNull$$$0(6);
        }
        return SHORT_NAME;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        final JCheckBox cbExpose = new JCheckBox("Public fields are exposed");
        cbExpose.setSelected(this.fieldsExposed);
        panel.add((Component)cbExpose, "North");
        cbExpose.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FtlReferencesInspection.this.fieldsExposed = cbExpose.isSelected();
            }
        });
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/inspections/FtlReferencesInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/inspections/FtlReferencesInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isDynamicReference";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCustomNumberFormat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

