/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.utils.ui;

import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class MethodDeploymentTableModel
extends AbstractTableModel {
    private final Boolean[] skipDeploymentTable;
    private final List<PsiMethod> methodsAllowedForDeployment;
    private final List<PsiMethod> methodsNotAllowedForDeployment;

    public MethodDeploymentTableModel(List<PsiMethod> methodsAllowedForDeployment, List<PsiMethod> methodsNotAllowedForDeployment) {
        this.methodsAllowedForDeployment = methodsAllowedForDeployment;
        this.methodsNotAllowedForDeployment = methodsNotAllowedForDeployment;
        this.skipDeploymentTable = new Boolean[methodsAllowedForDeployment.size()];
    }

    @Override
    public int getRowCount() {
        return this.methodsAllowedForDeployment.size() + this.methodsNotAllowedForDeployment.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            if (rowIndex < this.methodsAllowedForDeployment.size()) {
                return this.methodsAllowedForDeployment.get(rowIndex);
            }
            return this.methodsNotAllowedForDeployment.get(rowIndex - this.methodsAllowedForDeployment.size());
        }
        if (rowIndex < this.methodsAllowedForDeployment.size()) {
            Boolean aBoolean = this.skipDeploymentTable[rowIndex];
            if (aBoolean == null) {
                return Boolean.TRUE;
            }
            return aBoolean == false;
        }
        return Boolean.FALSE;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0 && rowIndex < this.skipDeploymentTable.length) {
            this.skipDeploymentTable[rowIndex] = Boolean.valueOf((Boolean)aValue) == false;
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0 && rowIndex < this.skipDeploymentTable.length;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "Add to deployment";
        }
        return "Method to expose";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return PsiMethod.class;
        }
        return Boolean.class;
    }

    public PsiMethod[] getSelectedMethods() {
        ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>(this.getRowCount());
        for (int i = 0; i < this.getRowCount(); ++i) {
            Boolean selected = (Boolean)this.getValueAt(i, 0);
            if (!Boolean.TRUE.equals(selected)) continue;
            methods.add((PsiMethod)this.getValueAt(i, 1));
        }
        return methods.toArray(PsiMethod.EMPTY_ARRAY);
    }
}

