/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.beans;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelGraphElementWrapper;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelWrapper;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalAnnotationModelWrapper
extends LocalModelWrapper<LocalAnnotationModel> {
    private static final Logger LOG = Logger.getInstance(LocalAnnotationModelWrapper.class);

    LocalAnnotationModelWrapper(@NotNull LocalAnnotationModel element) {
        if (element == null) {
            LocalAnnotationModelWrapper.$$$reportNull$$$0(0);
        }
        super(element);
    }

    @Override
    protected void addImportsInformation(StringBuilder sb) {
        PsiClass psiClass = (PsiClass)((LocalAnnotationModel)this.myElement).getConfig();
        LocalAnnotationModelWrapper.addTr(sb, "Imported Resources", SpringJamUtils.getInstance().getImportedResources(psiClass, new Module[0]).size());
        LocalAnnotationModelWrapper.addTr(sb, "Imported Configurations", SpringJamUtils.getInstance().getImportedClasses(psiClass, null).size());
    }

    @Override
    @NotNull
    protected String getLocalModelQualifiedName() {
        PsiClass config = (PsiClass)((LocalAnnotationModel)this.myElement).getConfig();
        String name = config.getQualifiedName();
        if (name != null) {
            String string = name;
            if (string == null) {
                LocalAnnotationModelWrapper.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (config instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymousConfig = (PsiAnonymousClass)config;
            LOG.warn(String.format("Anonymous class with base class '%s' contatined in class '%s' is considered a local model", anonymousConfig.getBaseClassType().getClassName(), anonymousConfig.getContainingClass()));
        } else if (config instanceof PsiTypeParameter) {
            PsiTypeParameter typeParameterConfig = (PsiTypeParameter)config;
            LOG.warn(String.format("Type parameter '%s' is considered a local model", typeParameterConfig.toString()));
        } else {
            LOG.warn(String.format("Config '%s' doesn't have a qualified name and is not PsiAnonymousClass nor PsiTypeParameter", config.toString()));
        }
        if ("???" == null) {
            LocalAnnotationModelWrapper.$$$reportNull$$$0(2);
        }
        return "???";
    }

    @Override
    public String getTitle() {
        return ((PsiClass)((LocalAnnotationModel)this.myElement).getConfig()).getName();
    }

    @Override
    public String getQualifiedName() {
        return ((PsiClass)((LocalAnnotationModel)this.myElement).getConfig()).getQualifiedName();
    }

    @Nullable
    public static LocalAnnotationModelWrapper create(@Nullable LocalAnnotationModel element) {
        return element == null ? null : new LocalAnnotationModelWrapper(element);
    }

    @Nullable
    public static LocalModelGraphElementWrapper resolveByFQN(String fqn, Project project) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(fqn, GlobalSearchScope.allScope((Project)project));
        if (aClass == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass);
        if (module == null) {
            return null;
        }
        return LocalAnnotationModelWrapper.create(SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(aClass, module, Collections.emptySet()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/diagram/beans/LocalAnnotationModelWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/diagram/beans/LocalAnnotationModelWrapper";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalModelQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

