/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelProvider;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringFileSetServiceImpl
extends SpringFileSetService {
    @NonNls
    private static final String ID_PREFIX = "fileset";
    @NonNls
    private static final String DEPENDENCY_DELIMITER = "==";
    private static final Function<SpringFileSet, String> FILESET_ID = SpringFileSet::getId;

    @Override
    public String getUniqueId(Set<SpringFileSet> existing) {
        return UniqueNameGenerator.generateUniqueName((String)ID_PREFIX, (Collection)ContainerUtil.map(existing, FILESET_ID));
    }

    @Override
    public String getUniqueName(String prefix, Set<SpringFileSet> existing) {
        UniqueNameGenerator generator = new UniqueNameGenerator(existing, SpringFileSet::getName);
        return generator.generateUniqueName(prefix, "", "", " (", ")");
    }

    @Override
    @NotNull
    public Set<SpringFileSet> getAllSets(@NotNull SpringFacet facet) {
        if (facet == null) {
            SpringFileSetServiceImpl.$$$reportNull$$$0(0);
        }
        Set<SpringFileSet> fileSets = SpringFileSetServiceImpl.getFileSets(facet);
        Set existing = ContainerUtil.map2Set(fileSets, FILESET_ID);
        for (SpringFileSet provided : this.getModelProviderSets(facet)) {
            if (existing.contains(provided.getId())) continue;
            fileSets.add(provided);
        }
        Set<SpringFileSet> set = fileSets;
        if (set == null) {
            SpringFileSetServiceImpl.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public List<SpringFileSet> getModelProviderSets(@NotNull SpringFacet facet) {
        if (facet == null) {
            SpringFileSetServiceImpl.$$$reportNull$$$0(2);
        }
        if (facet.getModule().isDisposed() || DumbService.isDumb((Project)facet.getModule().getProject())) {
            List<SpringFileSet> list = Collections.emptyList();
            if (list == null) {
                SpringFileSetServiceImpl.$$$reportNull$$$0(3);
            }
            return list;
        }
        SmartList result = new SmartList();
        for (SpringModelProvider modelProvider : (SpringModelProvider[])Extensions.getExtensions(SpringModelProvider.EP_NAME)) {
            List<SpringFileSet> modelProviderFilesets = modelProvider.getFilesets(facet);
            result.addAll(modelProviderFilesets);
        }
        SmartList smartList = result;
        if (smartList == null) {
            SpringFileSetServiceImpl.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    @Override
    @Nullable
    public SpringFileSet findFileSet(Module module, PsiFile psiFile) {
        SpringFacet springFacet = SpringFacet.getInstance(module);
        if (springFacet == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        for (SpringFileSet fileSet : this.getAllSets(springFacet)) {
            if (!fileSet.hasFile(virtualFile)) continue;
            return fileSet;
        }
        for (SpringModel model : SpringManager.getInstance(module.getProject()).getAllModels(module)) {
            if (model.getFileSet() == null) {
                return null;
            }
            if (!model.hasConfigFile(psiFile)) continue;
            return model.getFileSet();
        }
        return null;
    }

    @Override
    String getQualifiedName(@NotNull SpringFileSet fileset) {
        if (fileset == null) {
            SpringFileSetServiceImpl.$$$reportNull$$$0(5);
        }
        return fileset.getId() + DEPENDENCY_DELIMITER + fileset.getFacet().getModule().getName();
    }

    @Override
    String getDependencyIdFor(SpringFileSet current, SpringFileSet otherFileSet) {
        boolean isCurrentModule = current.getFacet().getModule().equals(otherFileSet.getFacet().getModule());
        if (isCurrentModule) {
            return otherFileSet.getId();
        }
        return this.getQualifiedName(otherFileSet);
    }

    @Override
    @Nullable
    SpringFileSet findDependencyFileSet(SpringFileSet current, @NotNull String dependencyId) {
        SpringFacet facetToSearch;
        if (dependencyId == null) {
            SpringFileSetServiceImpl.$$$reportNull$$$0(6);
        }
        if ((facetToSearch = SpringFileSetServiceImpl.getSpringFacetFor(current, dependencyId)) == null) {
            return null;
        }
        Condition fileSetCondition = springFileSet -> {
            if (dependencyId == null) {
                SpringFileSetServiceImpl.$$$reportNull$$$0(8);
            }
            return this.getDependencyIdFor(current, (SpringFileSet)springFileSet).equals(dependencyId);
        };
        SpringFileSet fileSet = (SpringFileSet)ContainerUtil.find(SpringFileSetServiceImpl.getFileSets(facetToSearch), (Condition)fileSetCondition);
        if (fileSet != null) {
            return fileSet;
        }
        return (SpringFileSet)ContainerUtil.find(this.getModelProviderSets(facetToSearch), (Condition)fileSetCondition);
    }

    private static Set<SpringFileSet> getFileSets(SpringFacet facet) {
        return new LinkedHashSet<SpringFileSet>(facet.getFileSets());
    }

    @Nullable
    private static SpringFacet getSpringFacetFor(SpringFileSet current, @NotNull String dependencyId) {
        if (dependencyId == null) {
            SpringFileSetServiceImpl.$$$reportNull$$$0(7);
        }
        if (!dependencyId.contains(DEPENDENCY_DELIMITER)) {
            return current.getFacet();
        }
        String moduleName = StringUtil.substringAfter((String)dependencyId, (String)DEPENDENCY_DELIMITER);
        assert (moduleName != null) : dependencyId;
        Module moduleByName = ModuleManager.getInstance((Project)current.getFacet().getModule().getProject()).findModuleByName(moduleName);
        return moduleByName == null ? null : SpringFacet.getInstance(moduleByName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/facet/SpringFileSetServiceImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = ID_PREFIX;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/facet/SpringFileSetServiceImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSets";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelProviderSets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllSets";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModelProviderSets";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findDependencyFileSet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSpringFacetFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findDependencyFileSet$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

