/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.spring.factories.resolvers.AbstractProxiedTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.beans.SpringBean;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopedProxyFactoryBeanTypeResolver
extends AbstractProxiedTypeResolver {
    @NonNls
    private static final String FACTORY_CLASS = "org.springframework.aop.scope.ScopedProxyFactoryBean";
    @NonNls
    private static final String TARGET_BEAN_NAME_PROPERTY_NAME = "targetBeanName";

    @Override
    @NotNull
    public Set<String> getObjectType(@Nullable CommonSpringBean context) {
        SpringBean springBean;
        PsiClassType type;
        if (context instanceof SpringBean && (type = this.getTargetType(springBean = (SpringBean)context)) != null) {
            Set<String> targetInterfaceNames;
            if (this.isBooleanPropertySetAndFalse(springBean, "proxyTargetClass") && !(targetInterfaceNames = ScopedProxyFactoryBeanTypeResolver.getAllInterfaceNames((PsiType)type)).isEmpty()) {
                Set<String> set = targetInterfaceNames;
                if (set == null) {
                    ScopedProxyFactoryBeanTypeResolver.$$$reportNull$$$0(0);
                }
                return set;
            }
            Set<String> set = Collections.singleton(type.getCanonicalText());
            if (set == null) {
                ScopedProxyFactoryBeanTypeResolver.$$$reportNull$$$0(1);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            ScopedProxyFactoryBeanTypeResolver.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Nullable
    private PsiClassType getTargetType(@NotNull SpringBean context) {
        PsiClassType fromTargetName;
        String targetBeanName;
        if (context == null) {
            ScopedProxyFactoryBeanTypeResolver.$$$reportNull$$$0(3);
        }
        if ((targetBeanName = this.getPropertyValue(context, TARGET_BEAN_NAME_PROPERTY_NAME)) != null && (fromTargetName = ScopedProxyFactoryBeanTypeResolver.getTypeFromBeanName(context, targetBeanName)) != null) {
            return fromTargetName;
        }
        return null;
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            ScopedProxyFactoryBeanTypeResolver.$$$reportNull$$$0(4);
        }
        return FACTORY_CLASS.equals(factoryClassName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/factories/resolvers/ScopedProxyFactoryBeanTypeResolver";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/factories/resolvers/ScopedProxyFactoryBeanTypeResolver";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTargetType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

