/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.DomGotoRelatedItem;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.util.NotNullFunction;
import com.intellij.util.xml.DomElement;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

class NavigationGutterIconBuilderUtil {
    static final NotNullFunction<SpringBeanPointer, Collection<? extends PsiElement>> BEAN_POINTER_CONVERTOR = pointer -> {
        if (!pointer.isValid()) {
            return Collections.emptySet();
        }
        return Collections.singleton(pointer.getSpringBean().getIdentifyingPsiElement());
    };
    static final NotNullFunction<CommonModelElement, Collection<? extends PsiElement>> COMMON_MODEL_ELEMENT_CONVERTOR = modelElement -> Collections.singleton(modelElement.getIdentifyingPsiElement());
    static final NotNullFunction<SpringBeanPointer, Collection<? extends GotoRelatedItem>> BEAN_POINTER_GOTO_PROVIDER = pointer -> {
        Object bean = pointer.getSpringBean();
        if (bean instanceof DomSpringBean) {
            return Collections.singletonList(new DomGotoRelatedItem((DomElement)((DomSpringBean)bean)));
        }
        PsiElement element = bean.getIdentifyingPsiElement();
        if (element != null) {
            return Collections.singletonList(new GotoRelatedItem(element));
        }
        return Collections.emptyList();
    };
    static final NotNullFunction<CommonModelElement, Collection<? extends GotoRelatedItem>> COMMON_MODEL_ELEMENT_GOTO_PROVIDER = modelElement -> {
        if (modelElement instanceof DomSpringBean) {
            return Collections.singletonList(new DomGotoRelatedItem((DomElement)((DomSpringBean)modelElement)));
        }
        PsiElement element = modelElement.getIdentifyingPsiElement();
        if (element != null) {
            return Collections.singletonList(new GotoRelatedItem(element));
        }
        return Collections.emptyList();
    };

    private NavigationGutterIconBuilderUtil() {
    }

    static void addAutowiredBeansGutterIcon(@NotNull Collection<SpringBeanPointer> collection, @NotNull Collection<? super RelatedItemLineMarkerInfo> holder, @NotNull PsiElement identifier) {
        if (collection == null) {
            NavigationGutterIconBuilderUtil.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            NavigationGutterIconBuilderUtil.$$$reportNull$$$0(1);
        }
        if (identifier == null) {
            NavigationGutterIconBuilderUtil.$$$reportNull$$$0(2);
        }
        NavigationGutterIconBuilderUtil.addAutowiredBeansGutterIcon(collection, holder, identifier, SpringBundle.message("navigate.to.autowired.dependencies", new Object[0]));
    }

    static void addAutowiredBeansGutterIcon(@NotNull Collection<SpringBeanPointer> collection, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, @NotNull PsiElement identifier, @NotNull String tooltipText) {
        if (collection == null) {
            NavigationGutterIconBuilderUtil.$$$reportNull$$$0(3);
        }
        if (result == null) {
            NavigationGutterIconBuilderUtil.$$$reportNull$$$0(4);
        }
        if (identifier == null) {
            NavigationGutterIconBuilderUtil.$$$reportNull$$$0(5);
        }
        if (tooltipText == null) {
            NavigationGutterIconBuilderUtil.$$$reportNull$$$0(6);
        }
        ArrayList<SpringBeanPointer> sorted = new ArrayList<SpringBeanPointer>(collection);
        Collections.sort(sorted, SpringBeanPointer.DISPLAY_COMPARATOR);
        SpringGutterIconBuilder<SpringBeanPointer> builder = SpringGutterIconBuilder.createBuilder(SpringApiIcons.Gutter.ShowAutowiredDependencies, BEAN_POINTER_CONVERTOR, BEAN_POINTER_GOTO_PROVIDER);
        builder.setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setTooltipText(tooltipText).setTargets(sorted);
        result.add(builder.createSpringRelatedMergeableLineMarkerInfo(identifier));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "collection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "identifier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[0] = "tooltipText";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/gutter/NavigationGutterIconBuilderUtil";
        objectArray[2] = "addAutowiredBeansGutterIcon";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

