/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.java;

import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringConstructorArgUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.Autowire;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.LookupMethod;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringJavaClassInfo {
    private static final Key<SpringJavaClassInfo> KEY = Key.create((String)"Spring Java Class Info");
    private final PsiClass myPsiClass;
    private final CachedValue<Boolean> myIsMapped;
    private final CachedValue<Set<SpringBeanPointer>> myBeans;
    private final CachedValue<MultiMap<String, SpringPropertyDefinition>> myProperties;
    private final CachedValue<MultiMap<PsiMethod, SpringBeanPointer>> myConstructors;
    private final CachedValue<MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>>> myMethods;

    @NotNull
    public static SpringJavaClassInfo getSpringJavaClassInfo(@NotNull PsiClass psiClass) {
        SpringJavaClassInfo info;
        if (psiClass == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(0);
        }
        if ((info = (SpringJavaClassInfo)psiClass.getUserData(KEY)) == null) {
            info = new SpringJavaClassInfo(psiClass);
            psiClass.putUserData(KEY, (Object)info);
        }
        SpringJavaClassInfo springJavaClassInfo = info;
        if (springJavaClassInfo == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(1);
        }
        return springJavaClassInfo;
    }

    private SpringJavaClassInfo(PsiClass psiClass) {
        this.myPsiClass = psiClass;
        Project project = psiClass.getProject();
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project);
        this.myIsMapped = cachedValuesManager.createCachedValue(() -> {
            CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(this.myPsiClass);
            boolean exists = SpringModelSearchers.doesBeanExist(model, this.myPsiClass);
            return new CachedValueProvider.Result((Object)exists, this.getDependencies(project, model));
        }, false);
        this.myBeans = cachedValuesManager.createCachedValue(() -> {
            CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(this.myPsiClass);
            List<SpringBeanPointer> byInheritance = SpringModelSearchers.findBeans(model, SpringModelSearchParameters.byClass(this.myPsiClass).withInheritors().effectiveBeanTypes());
            return new CachedValueProvider.Result(new LinkedHashSet<SpringBeanPointer>(byInheritance), this.getDependencies(project, model));
        }, false);
        this.myProperties = cachedValuesManager.createCachedValue(() -> {
            List<DomSpringBeanPointer> list = this.getMappedDomBeans();
            ConcurrentMultiMap map = new ConcurrentMultiMap();
            for (DomSpringBeanPointer beanPointer : list) {
                DomSpringBean bean;
                if (!beanPointer.isValid() || !((bean = (DomSpringBean)beanPointer.getSpringBean()) instanceof SpringBean)) continue;
                List<SpringPropertyDefinition> properties = ((SpringBean)bean).getAllProperties();
                for (SpringPropertyDefinition property : properties) {
                    String propertyName = property.getPropertyName();
                    if (propertyName == null) continue;
                    map.putValue((Object)propertyName, (Object)property);
                }
            }
            return new CachedValueProvider.Result((Object)map, new Object[]{DomManager.getDomManager((Project)project)});
        }, false);
        this.myConstructors = cachedValuesManager.createCachedValue(() -> {
            List<DomSpringBeanPointer> list = this.getMappedDomBeans();
            ConcurrentMultiMap map = new ConcurrentMultiMap();
            for (DomSpringBeanPointer beanPointer : list) {
                DomSpringBean bean;
                if (!beanPointer.isValid() || !((bean = (DomSpringBean)beanPointer.getSpringBean()) instanceof SpringBean)) continue;
                CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(this.myPsiClass);
                PsiMethod constructor = SpringConstructorArgUtils.getInstance().getSpringBeanConstructor((SpringBean)bean, model);
                if (constructor == null) continue;
                map.putValue((Object)constructor, (Object)beanPointer);
            }
            return new CachedValueProvider.Result((Object)map, new Object[]{DomManager.getDomManager((Project)project)});
        }, false);
        this.myMethods = cachedValuesManager.createCachedValue(() -> {
            SpringBean springBean;
            CommonSpringBean bean;
            List<PsiMethod> psiMethods = Arrays.asList(psiClass.getMethods());
            List<DomSpringBeanPointer> list = this.getMappedDomBeans();
            ConcurrentMultiMap map = new ConcurrentMultiMap();
            for (JamSpringBeanPointer pointer : this.getStereotypeMappedBeans()) {
                bean = (JamPsiMemberSpringBean)pointer.getSpringBean();
                if (!(bean instanceof ContextJavaBean)) continue;
                SpringJavaClassInfo.addStereotypeBeanMethod((MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>>)map, ((ContextJavaBean)bean).getInitMethodAttributeElement(), SpringMethodType.INIT);
                SpringJavaClassInfo.addStereotypeBeanMethod((MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>>)map, ((ContextJavaBean)bean).getDestroyMethodAttributeElement(), SpringMethodType.DESTROY);
            }
            for (DomSpringBeanPointer beanPointer : list) {
                if (!beanPointer.isValid() || !((bean = (DomSpringBean)beanPointer.getSpringBean()) instanceof SpringBean)) continue;
                Beans beans = (Beans)DomUtil.getParentOfType((DomElement)bean, Beans.class, (boolean)false);
                if (beans != null) {
                    SpringJavaClassInfo.addSpringBeanMethods((MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>>)map, psiMethods, SpringMethodType.INIT, beans.getDefaultInitMethod());
                    SpringJavaClassInfo.addSpringBeanMethods((MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>>)map, psiMethods, SpringMethodType.DESTROY, beans.getDefaultDestroyMethod());
                }
                springBean = (SpringBean)bean;
                SpringJavaClassInfo.addSpringBeanMethod((MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>>)map, psiMethods, SpringMethodType.INIT, (GenericAttributeValue<PsiMethod>)springBean.getInitMethod());
                SpringJavaClassInfo.addSpringBeanMethod((MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>>)map, psiMethods, SpringMethodType.DESTROY, (GenericAttributeValue<PsiMethod>)springBean.getDestroyMethod());
                for (LookupMethod lookupMethod : springBean.getLookupMethods()) {
                    SpringJavaClassInfo.addSpringBeanMethod((MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>>)map, psiMethods, SpringMethodType.LOOKUP, lookupMethod.getName());
                }
            }
            CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
            SpringBeanUtils.getInstance().processXmlFactoryBeans(this.myPsiClass.getProject(), this.myPsiClass.getResolveScope(), (Processor<SpringBeanPointer>)processor);
            for (SpringBeanPointer pointer : processor.getResults()) {
                PsiMethod factoryMethod;
                GenericAttributeValue<PsiMethod> domFactoryMethod;
                Object commonSpringBean;
                if (!pointer.isValid() || !((commonSpringBean = pointer.getSpringBean()) instanceof SpringBean) || !commonSpringBean.isValid() || !DomUtil.hasXml(domFactoryMethod = (springBean = (SpringBean)commonSpringBean).getFactoryMethod()) || (factoryMethod = (PsiMethod)domFactoryMethod.getValue()) == null || !psiMethods.contains(factoryMethod)) continue;
                SpringJavaClassInfo.addSpringBeanMethod((MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>>)map, psiMethods, SpringMethodType.FACTORY, domFactoryMethod);
            }
            return new CachedValueProvider.Result((Object)map, new Object[]{DomManager.getDomManager((Project)project), this.myPsiClass});
        }, false);
    }

    private static void addStereotypeBeanMethod(@NotNull MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>> map, @NotNull JamStringAttributeElement<PsiMethod> attributeElement, @NotNull SpringMethodType type) {
        PsiAnnotationMemberValue identifyingElement;
        PsiMethod psiMethod;
        if (map == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(2);
        }
        if (attributeElement == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(3);
        }
        if (type == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(4);
        }
        if ((psiMethod = (PsiMethod)attributeElement.getValue()) != null && (identifyingElement = attributeElement.getPsiElement()) != null) {
            map.putValue((Object)psiMethod, (Object)Pair.create((Object)identifyingElement.getParent(), (Object)((Object)type)));
        }
    }

    @NotNull
    private Object[] getDependencies(@NotNull Project project, @NotNull CommonSpringModel model) {
        if (project == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(5);
        }
        if (model == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(6);
        }
        LinkedHashSet dependencies = ContainerUtil.newLinkedHashSet();
        ContainerUtil.addIfNotNull((Collection)dependencies, (Object)this.myPsiClass.getContainingFile());
        ContainerUtil.addAll((Collection)dependencies, (Object[])SpringModificationTrackersManager.getInstance(project).getOuterModelsDependencies());
        dependencies.addAll(model.getConfigFiles());
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)dependencies);
        if (objectArray == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    private static void addSpringBeanMethod(@NotNull MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>> map, @NotNull List<PsiMethod> psiMethods, @NotNull SpringMethodType type, @NotNull GenericAttributeValue<PsiMethod> genericAttributeValue) {
        if (map == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(8);
        }
        if (psiMethods == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(9);
        }
        if (type == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(10);
        }
        if (genericAttributeValue == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(11);
        }
        if (!DomUtil.hasXml(genericAttributeValue)) {
            return;
        }
        PsiMethod psiMethod = (PsiMethod)genericAttributeValue.getValue();
        if (psiMethod != null && psiMethods.contains(psiMethod)) {
            map.putValue((Object)psiMethod, (Object)Pair.create((Object)genericAttributeValue.getXmlAttribute(), (Object)((Object)type)));
        }
    }

    private static void addSpringBeanMethods(@NotNull MultiMap<PsiMethod, Pair<PsiElement, SpringMethodType>> map, @NotNull List<PsiMethod> psiMethods, @NotNull SpringMethodType type, @NotNull GenericAttributeValue<Set<PsiMethod>> genericAttributeValue) {
        if (map == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(12);
        }
        if (psiMethods == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(13);
        }
        if (type == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(14);
        }
        if (genericAttributeValue == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(15);
        }
        if (!DomUtil.hasXml(genericAttributeValue)) {
            return;
        }
        Set methods = (Set)genericAttributeValue.getValue();
        if (methods != null) {
            for (PsiMethod psiMethod : methods) {
                if (!psiMethods.contains(psiMethod)) continue;
                map.putValue((Object)psiMethod, (Object)Pair.create((Object)genericAttributeValue.getXmlAttribute(), (Object)((Object)type)));
            }
        }
    }

    public boolean isMapped() {
        return (Boolean)this.myIsMapped.getValue();
    }

    public boolean isMappedDomBean() {
        return this.isMapped() && ContainerUtil.findInstance((Iterable)((Iterable)this.myBeans.getValue()), DomSpringBeanPointer.class) != null;
    }

    @NotNull
    public List<DomSpringBeanPointer> getMappedDomBeans() {
        List list = !this.isMapped() ? Collections.emptyList() : ContainerUtil.findAll((Collection)((Collection)this.myBeans.getValue()), DomSpringBeanPointer.class);
        if (list == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(16);
        }
        return list;
    }

    public boolean isStereotypeJavaBean() {
        return this.isMapped() && ContainerUtil.findInstance((Iterable)((Iterable)this.myBeans.getValue()), JamSpringBeanPointer.class) != null;
    }

    @NotNull
    public List<JamSpringBeanPointer> getStereotypeMappedBeans() {
        List list = !this.isMapped() ? Collections.emptyList() : ContainerUtil.findAll((Collection)((Collection)this.myBeans.getValue()), JamSpringBeanPointer.class);
        if (list == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(17);
        }
        return list;
    }

    public boolean isAutowired() {
        List<DomSpringBeanPointer> pointers = this.getMappedDomBeans();
        for (DomSpringBeanPointer pointer : pointers) {
            Autowire autowire;
            DomSpringBean springBean = (DomSpringBean)pointer.getSpringBean();
            if (!(springBean instanceof SpringBean) || !(autowire = ((SpringBean)springBean).getBeanAutowire()).isAutowired()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Set<Autowire> getAutowires() {
        EnumSet<Autowire> autowires = EnumSet.noneOf(Autowire.class);
        for (DomSpringBeanPointer pointer : this.getMappedDomBeans()) {
            Autowire autowire;
            DomSpringBean springBean = (DomSpringBean)pointer.getSpringBean();
            if (!(springBean instanceof SpringBean) || !(autowire = ((SpringBean)springBean).getBeanAutowire()).isAutowired()) continue;
            autowires.add(autowire);
        }
        EnumSet<Autowire> enumSet = autowires;
        if (enumSet == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(18);
        }
        return enumSet;
    }

    @NotNull
    public Collection<SpringPropertyDefinition> getMappedProperties(String propertyName) {
        MultiMap value = (MultiMap)this.myProperties.getValue();
        if (value == null) {
            List<SpringPropertyDefinition> list = Collections.emptyList();
            if (list == null) {
                SpringJavaClassInfo.$$$reportNull$$$0(19);
            }
            return list;
        }
        Collection collection = value.get((Object)propertyName);
        if (collection == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(20);
        }
        return collection;
    }

    @NotNull
    public Collection<SpringBeanPointer> getMappedConstructorDefinitions(@NotNull PsiMethod psiMethod) {
        MultiMap value;
        if (psiMethod == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(21);
        }
        if ((value = (MultiMap)this.myConstructors.getValue()) == null) {
            List<SpringBeanPointer> list = Collections.emptyList();
            if (list == null) {
                SpringJavaClassInfo.$$$reportNull$$$0(22);
            }
            return list;
        }
        Collection collection = value.get((Object)psiMethod);
        if (collection == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(23);
        }
        return collection;
    }

    @NotNull
    public Collection<Pair<PsiElement, SpringMethodType>> getMethodTypes(@NotNull PsiMethod psiMethod) {
        MultiMap value;
        if (psiMethod == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(24);
        }
        if ((value = (MultiMap)this.myMethods.getValue()) == null) {
            List<Pair<PsiElement, SpringMethodType>> list = Collections.emptyList();
            if (list == null) {
                SpringJavaClassInfo.$$$reportNull$$$0(25);
            }
            return list;
        }
        Collection collection = value.get((Object)psiMethod);
        if (collection == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(26);
        }
        return collection;
    }

    public boolean isMappedProperty(PsiMethod method) {
        String propertyName = StringUtil.getPropertyName((String)method.getName());
        if (propertyName == null) {
            return false;
        }
        return !this.getMappedProperties(propertyName).isEmpty();
    }

    public boolean isMappedConstructor(@NotNull PsiMethod method) {
        if (method == null) {
            SpringJavaClassInfo.$$$reportNull$$$0(27);
        }
        if (!method.isConstructor()) {
            return false;
        }
        return ((MultiMap)this.myConstructors.getValue()).containsKey((Object)method);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/java/SpringJavaClassInfo";
                break;
            }
            case 2: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeElement";
                break;
            }
            case 4: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethods";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericAttributeValue";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/java/SpringJavaClassInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringJavaClassInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappedDomBeans";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getStereotypeMappedBeans";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutowires";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappedProperties";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappedConstructorDefinitions";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSpringJavaClassInfo";
                break;
            }
            case 1: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addStereotypeBeanMethod";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addSpringBeanMethod";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addSpringBeanMethods";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMappedConstructorDefinitions";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getMethodTypes";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isMappedConstructor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 7: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SpringMethodType {
        INIT("init"),
        DESTROY("destroy"),
        FACTORY("factory"),
        LOOKUP("lookup");

        private final String myName;

        private SpringMethodType(String name) {
            this.myName = name;
        }

        public String getName() {
            return this.myName;
        }
    }
}

