/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.create;

import com.intellij.ide.actions.CreateFileAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import icons.SpringApiIcons;
import org.jetbrains.annotations.NotNull;

public class CreateSpringConfigAction
extends CreateFileAction {
    public CreateSpringConfigAction() {
        super(SpringBundle.message("config.new.file", new Object[0]), SpringBundle.message("create.new.spring.configuration.file", new Object[0]), SpringApiIcons.SpringConfig);
    }

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        return module != null && SpringLibraryUtil.hasSpringLibrary(module.getProject());
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        String fileName = this.getFileName(newName);
        PsiElement psiElement = SpringCommonUtils.createSpringXmlConfigFile(fileName, directory);
        PsiElement[] psiElementArray = new PsiElement[]{psiElement};
        if (psiElementArray == null) {
            CreateSpringConfigAction.$$$reportNull$$$0(0);
        }
        return psiElementArray;
    }

    protected String getDefaultExtension() {
        return "xml";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/actions/create/CreateSpringConfigAction", "create"));
    }
}

