/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns.frameworks;

import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.module.Module;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.actions.patterns.PatternIcons;
import com.intellij.spring.model.actions.patterns.frameworks.AbstractFrameworkIntegrationAction;
import com.intellij.spring.model.actions.patterns.frameworks.ui.LibrariesInfo;
import com.intellij.spring.model.actions.patterns.frameworks.ui.TemplateInfo;
import com.intellij.spring.model.actions.patterns.frameworks.util.LibrariesConfigurationManager;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AddJdoAction
extends AbstractFrameworkIntegrationAction {
    @NonNls
    private static final String JDO_STRING_ID = "jdo";

    @Override
    protected String[] getBeansClassNames() {
        return new String[]{"org.springframework.orm.jdo.LocalPersistenceManagerFactoryBean", "org.jpox.PersistenceManagerFactoryImpl"};
    }

    @Override
    public LibrariesInfo getLibrariesInfo(Module module) {
        LibraryInfo[] libraryInfos = LibrariesConfigurationManager.getInstance(module.getProject()).getLibraryInfos(JDO_STRING_ID);
        return new LibrariesInfo(libraryInfos, module, JDO_STRING_ID);
    }

    @Override
    public List<TemplateInfo> getTemplateInfos(Module module) {
        LinkedList<TemplateInfo> infos = new LinkedList<TemplateInfo>();
        TemplateSettings settings = TemplateSettings.getInstance();
        TemplateInfo datasource = new TemplateInfo(module, settings.getTemplateById("datasource"), SpringBundle.message("spring.patterns.data.access.data.source", new Object[0]), null, false);
        TemplateInfo jpm = new TemplateInfo(module, settings.getTemplateById("jdo-persistance-manager"), SpringBundle.message("spring.patterns.data.access.jdo.persistence.manager", new Object[0]), null);
        TemplateInfo jpox = new TemplateInfo(module, settings.getTemplateById("jpox-pmf"), SpringBundle.message("spring.patterns.data.access.jdo.jpox.persistence.manager", new Object[0]), null, false);
        TemplateInfo pmp = new TemplateInfo(module, settings.getTemplateById("jdo-persistance-manager-proxy"), SpringBundle.message("spring.patterns.data.access.jdo.persistence.manager.proxy", new Object[0]), null);
        TemplateInfo transctionManager = new TemplateInfo(module, settings.getTemplateById("jdo-transaction-manager"), SpringBundle.message("spring.patterns.data.access.jdo.transaction.manager", new Object[0]), null);
        infos.add(jpm);
        infos.add(datasource);
        infos.add(jpox);
        infos.add(pmp);
        infos.add(transctionManager);
        return infos;
    }

    @Override
    public String getDescription() {
        return SpringBundle.message("spring.patterns.jdo", new Object[0]);
    }

    @Override
    @Nullable
    protected Icon getIcon() {
        return PatternIcons.JDO_ICON;
    }
}

