/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringBeanLookupMethodConverter;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.LookupMethod;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanLookupMethodConverterImpl
extends SpringBeanLookupMethodConverter {
    @Override
    @Nullable
    protected PsiClass getPsiClass(ConvertContext context) {
        SpringBean springBean = (SpringBean)context.getInvocationElement().getParentOfType(SpringBean.class, false);
        return springBean != null ? PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType()) : null;
    }

    @Override
    protected boolean checkModifiers(PsiMethod method) {
        return method.hasModifierProperty("public") || method.hasModifierProperty("protected");
    }

    @Override
    protected boolean checkReturnType(ConvertContext context, PsiMethod method, boolean forCompletion) {
        PsiType[] possibleReturnTypes;
        PsiType returnType = method.getReturnType();
        if (PsiType.VOID.equals((Object)returnType) || returnType instanceof PsiPrimitiveType) {
            return false;
        }
        if (forCompletion && (possibleReturnTypes = SpringBeanLookupMethodConverterImpl.getValidReturnTypes(context)).length > 0 && returnType != null) {
            for (PsiType possibleReturnType : possibleReturnTypes) {
                if (!possibleReturnType.isAssignableFrom(returnType)) continue;
                return true;
            }
            return false;
        }
        return super.checkReturnType(context, method, forCompletion);
    }

    @Override
    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        PsiType[] validReturnTypes = SpringBeanLookupMethodConverterImpl.getValidReturnTypes(context);
        if (validReturnTypes.length == 0) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        DomSpringBean springBean = SpringConverterUtil.getCurrentBean(context);
        if (springBean == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        GenericDomValue element = (GenericDomValue)context.getInvocationElement();
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        String elementName = element.getStringValue();
        if (psiClass == null || elementName == null || StringUtil.isEmpty((String)elementName)) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ArrayList<CreateMethodQuickFix> fixes = new ArrayList<CreateMethodQuickFix>();
        for (PsiType returnType : validReturnTypes) {
            CreateMethodQuickFix fix = CreateMethodQuickFix.createFix((PsiClass)psiClass, (String)SpringBeanLookupMethodConverterImpl.getNewMethodSignature(elementName, returnType), (String)SpringBeanLookupMethodConverterImpl.getNewMethodBody());
            if (fix == null) continue;
            fixes.add(fix);
        }
        return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    @NonNls
    private static String getNewMethodBody() {
        return "return null;";
    }

    @NonNls
    private static String getNewMethodSignature(@NotNull String elementName, @NotNull PsiType psiType) {
        if (elementName == null) {
            SpringBeanLookupMethodConverterImpl.$$$reportNull$$$0(0);
        }
        if (psiType == null) {
            SpringBeanLookupMethodConverterImpl.$$$reportNull$$$0(1);
        }
        return "public " + psiType.getCanonicalText() + " " + elementName + "()";
    }

    @NotNull
    private static PsiType[] getValidReturnTypes(ConvertContext context) {
        SpringBeanPointer beanPointer;
        LookupMethod lookupMethod = (LookupMethod)context.getInvocationElement().getParentOfType(LookupMethod.class, false);
        if (lookupMethod != null && (beanPointer = (SpringBeanPointer)lookupMethod.getBean().getValue()) != null) {
            PsiType[] psiTypeArray = beanPointer.getEffectiveBeanTypes();
            if (psiTypeArray == null) {
                SpringBeanLookupMethodConverterImpl.$$$reportNull$$$0(2);
            }
            return psiTypeArray;
        }
        if (PsiType.EMPTY_ARRAY == null) {
            SpringBeanLookupMethodConverterImpl.$$$reportNull$$$0(3);
        }
        return PsiType.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/SpringBeanLookupMethodConverterImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/SpringBeanLookupMethodConverterImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidReturnTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNewMethodSignature";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

