/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters.fixes.bean;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.facet.Facet;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringContextIcons;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringImport;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import icons.SpringApiIcons;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UseExistingBeanFromOtherContextQuickFix
implements LocalQuickFix,
HighPriorityAction {
    private final String myBeanId;
    private final SmartPsiElementPointer<PsiFile> myBeanFilePointer;
    private final SpringFileSet mySpringFileSet;
    private final String myFilesetName;
    private static int quickFixActionIndexToInvokeInTest = -1;

    UseExistingBeanFromOtherContextQuickFix(String beanId, PsiFile beanFile, SpringFileSet springFileSet) {
        this.myBeanId = beanId;
        this.myBeanFilePointer = SmartPointerManager.getInstance((Project)beanFile.getProject()).createSmartPsiElementPointer((PsiElement)beanFile);
        this.mySpringFileSet = springFileSet;
        this.myFilesetName = springFileSet.getName();
    }

    public static void setQuickFixActionIndexToInvokeInTest(int actionIdx) {
        quickFixActionIndexToInvokeInTest = actionIdx;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getName() {
        String string = "Use existing bean from context '" + this.myFilesetName + "'...";
        if (string == null) {
            UseExistingBeanFromOtherContextQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Use existing bean" == null) {
            UseExistingBeanFromOtherContextQuickFix.$$$reportNull$$$0(1);
        }
        return "Use existing bean";
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiFile myBeanFile;
        if (project == null) {
            UseExistingBeanFromOtherContextQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            UseExistingBeanFromOtherContextQuickFix.$$$reportNull$$$0(3);
        }
        if ((myBeanFile = (PsiFile)this.myBeanFilePointer.getElement()) == null) {
            return;
        }
        final PsiElement element = descriptor.getPsiElement();
        final PsiFile file = element.getContainingFile();
        final SpringFileSet currentFileSet = UseExistingBeanFromOtherContextQuickFix.getCurrentFileSet(project, file);
        AnAction addDependencyToFileSetAction = new AnAction("Add dependency to context '" + this.myFilesetName + "'", null, SpringContextIcons.ParentContext){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(currentFileSet.getDependencyFileSets().isEmpty());
            }

            public void actionPerformed(AnActionEvent e) {
                currentFileSet.addDependency(UseExistingBeanFromOtherContextQuickFix.this.mySpringFileSet);
                UseExistingBeanFromOtherContextQuickFix.rehighlight(file);
            }
        };
        AnAction addSpringXmlToOurFileSetAction = new AnAction("Add '" + myBeanFile.getName() + "' to context '" + currentFileSet.getName() + "'", null, SpringApiIcons.FileSet){

            public void actionPerformed(AnActionEvent e) {
                VirtualFile virtualFile = myBeanFile.getVirtualFile();
                assert (virtualFile != null);
                currentFileSet.addFile(virtualFile);
                UseExistingBeanFromOtherContextQuickFix.rehighlight(file);
            }
        };
        final String relativePath = VfsUtilCore.getRelativePath((VirtualFile)myBeanFile.getVirtualFile(), (VirtualFile)file.getContainingDirectory().getVirtualFile(), (char)'/');
        AnAction addImportAction = new AnAction("Add <import> for '" + myBeanFile.getName() + "'", null, AllIcons.Nodes.Tag){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(relativePath != null && myBeanFile instanceof XmlFile);
            }

            public void actionPerformed(AnActionEvent e) {
                if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                    return;
                }
                DomFileElement<Beans> root = SpringDomUtils.getSpringDomFileElement((XmlFile)file);
                assert (root != null);
                Beans beans = (Beans)root.getRootElement();
                if (!beans.isValid()) {
                    return;
                }
                WriteCommandAction.runWriteCommandAction((Project)project, () -> {
                    SpringImport springImport = beans.addImport();
                    GenericAttributeValue<Set<PsiFile>> resource = springImport.getResource();
                    resource.setStringValue(relativePath);
                    UseExistingBeanFromOtherContextQuickFix.rehighlight(file);
                });
            }
        };
        AnAction openSpringFacetSettings = new AnAction("Open Spring facet settings...", null, SpringApiIcons.Spring){

            public void actionPerformed(AnActionEvent e) {
                ModulesConfigurator.showFacetSettingsDialog((Facet)UseExistingBeanFromOtherContextQuickFix.getSpringFacet(file), null);
            }
        };
        DefaultActionGroup actionGroup = new DefaultActionGroup(new AnAction[]{addDependencyToFileSetAction, addSpringXmlToOurFileSetAction, addImportAction, openSpringFacetSettings});
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            assert (quickFixActionIndexToInvokeInTest != -1);
            actionGroup.getChildren(null)[quickFixActionIndexToInvokeInTest].actionPerformed(null);
            return;
        }
        DataManager.getInstance().getDataContextFromFocus().doWhenDone(arg_0 -> this.lambda$applyFix$0((ActionGroup)actionGroup, arg_0));
    }

    private static void rehighlight(PsiFile psiFile) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        SpringFacet springFacet = UseExistingBeanFromOtherContextQuickFix.getSpringFacet(psiFile);
        SpringFacetConfiguration configuration = (SpringFacetConfiguration)springFacet.getConfiguration();
        configuration.setModified();
        ApplicationManager.getApplication().invokeLater(() -> {
            DomElementAnnotationsManager.getInstance((Project)psiFile.getProject()).dropAnnotationsCache();
            psiFile.getManager().dropPsiCaches();
            DaemonCodeAnalyzer.getInstance((Project)psiFile.getProject()).restart();
        });
    }

    @NotNull
    private static SpringFacet getSpringFacet(PsiFile psiFile) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        assert (module != null);
        SpringFacet springFacet = SpringFacet.getInstance(module);
        assert (springFacet != null);
        SpringFacet springFacet2 = springFacet;
        if (springFacet2 == null) {
            UseExistingBeanFromOtherContextQuickFix.$$$reportNull$$$0(4);
        }
        return springFacet2;
    }

    @NotNull
    private static SpringFileSet getCurrentFileSet(Project project, PsiFile file) {
        Set<SpringModel> models = SpringManager.getInstance(project).getSpringModelsByFile(file);
        for (SpringModel model : models) {
            SpringFileSet currentFileSet = model.getFileSet();
            if (currentFileSet == null) continue;
            SpringFileSet springFileSet = currentFileSet;
            if (springFileSet == null) {
                UseExistingBeanFromOtherContextQuickFix.$$$reportNull$$$0(5);
            }
            return springFileSet;
        }
        throw new IllegalStateException("no fileset for " + file);
    }

    private /* synthetic */ void lambda$applyFix$0(ActionGroup actionGroup, DataContext dataContext) {
        JBPopupFactory.getInstance().createActionGroupPopup("Choose Fix For '" + this.myBeanId + "'", actionGroup, dataContext, JBPopupFactory.ActionSelectionAid.NUMBERING, true).showInBestPositionFor(dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/fixes/bean/UseExistingBeanFromOtherContextQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/fixes/bean/UseExistingBeanFromOtherContextQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringFacet";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentFileSet";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

