/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelVisitor;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringKey;
import com.intellij.spring.model.xml.beans.SpringRef;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.spring.model.xml.beans.TypeHolderUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectionValueStyleInspection
extends SpringBeanInspectionBase {
    @NonNls
    private static final String KEY = "key";
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String VALUE_REF = "value-ref";
    @NonNls
    private static final String KEY_REF = "key-ref";
    @NonNls
    private static final String REF = "ref";

    @Override
    protected SpringModelVisitor createVisitor(final DomElementAnnotationHolder holder, @NotNull Beans beans, @Nullable CommonSpringModel model) {
        if (beans == null) {
            InjectionValueStyleInspection.$$$reportNull$$$0(0);
        }
        return new SpringModelVisitor(){

            @Override
            protected boolean visitValueHolder(SpringValueHolder valueHolder) {
                InjectionValueStyleInspection.checkValueHolder(holder, valueHolder);
                return true;
            }
        };
    }

    private static void checkValueHolder(DomElementAnnotationHolder holder, @NotNull SpringValueHolderDefinition valueHolder) {
        if (valueHolder == null) {
            InjectionValueStyleInspection.$$$reportNull$$$0(1);
        }
        InjectionValueStyleInspection.checkValue(valueHolder, holder);
        InjectionValueStyleInspection.checkRefBean(valueHolder, holder);
        if (valueHolder instanceof SpringEntry) {
            InjectionValueStyleInspection.checkValue(((SpringEntry)valueHolder).getKey(), holder);
            InjectionValueStyleInspection.checkRefBean(((SpringEntry)valueHolder).getKey(), holder);
        }
    }

    private static void checkValue(@NotNull SpringValueHolderDefinition valueHolder, DomElementAnnotationHolder holder) {
        String s;
        PsiType type;
        if (valueHolder == null) {
            InjectionValueStyleInspection.$$$reportNull$$$0(2);
        }
        if ((type = TypeHolderUtil.getRequiredType(valueHolder)) != null && Properties.class.getName().equals(type.getCanonicalText())) {
            return;
        }
        GenericDomValue<?> value = valueHolder.getValueElement();
        if (!(value == null || value instanceof GenericAttributeValue || (s = value.getRawText()) == null || InjectionValueStyleInspection.isMultiline(s) || value instanceof SpringValue && DomUtil.hasXml(((SpringValue)value).getType()))) {
            XmlTag tag = value.getXmlTag();
            if (tag != null && tag.getValue().hasCDATA()) {
                return;
            }
            ValueQuickFix fix = new ValueQuickFix(valueHolder);
            holder.createProblem(value, HighlightSeverity.ERROR, SpringBundle.message("model.inspection.injection.value.style.message", new Object[0]), new LocalQuickFix[]{fix}).highlightWholeElement();
        }
    }

    private static boolean isMultiline(String s) {
        return s.trim().indexOf(10) >= 0;
    }

    private static void checkRefBean(SpringValueHolderDefinition valueHolder, DomElementAnnotationHolder holder) {
        SpringRef ref;
        GenericAttributeValue<SpringBeanPointer> bean;
        if (valueHolder instanceof SpringValueHolder && DomUtil.hasXml(bean = (ref = ((SpringValueHolder)valueHolder).getRef()).getBean())) {
            RefQuickFix fix = new RefQuickFix((SpringValueHolder)valueHolder);
            holder.createProblem((DomElement)ref, HighlightSeverity.ERROR, SpringBundle.message("model.inspection.injection.value.style.ref.message", new Object[0]), new LocalQuickFix[]{fix}).highlightWholeElement();
        }
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringInjectionValueStyleInspection" == null) {
            InjectionValueStyleInspection.$$$reportNull$$$0(3);
        }
        return "SpringInjectionValueStyleInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueHolder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/xml/InjectionValueStyleInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/xml/InjectionValueStyleInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkValueHolder";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkValue";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RefQuickFix
    implements LocalQuickFix {
        private final SpringValueHolder myValueHolder;

        public RefQuickFix(SpringValueHolder valueHolder) {
            this.myValueHolder = (SpringValueHolder)valueHolder.createStableCopy();
        }

        @NotNull
        public String getName() {
            String attr = this.myValueHolder instanceof SpringKey ? InjectionValueStyleInspection.KEY_REF : (this.myValueHolder instanceof SpringEntry ? InjectionValueStyleInspection.VALUE_REF : InjectionValueStyleInspection.REF);
            String string = SpringBundle.message("model.inspection.injection.value.style.ref.fix", attr);
            if (string == null) {
                RefQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("model.inspection.injection.value.style.ref.fix.family.name", new Object[0]);
            if (string == null) {
                RefQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            XmlElement element;
            if (project == null) {
                RefQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RefQuickFix.$$$reportNull$$$0(3);
            }
            if ((element = this.myValueHolder.getXmlElement()) == null) {
                return;
            }
            String val = this.myValueHolder.getRef().getBean().getRawText();
            if (this.myValueHolder instanceof SpringKey) {
                SpringEntry entry = (SpringEntry)this.myValueHolder.getParent();
                assert (entry != null);
                entry.getKeyRef().setStringValue(val);
                this.myValueHolder.undefine();
                XmlTag tag = entry.getXmlTag();
                assert (tag != null);
                tag.collapseIfEmpty();
            } else {
                this.myValueHolder.getRefAttr().setStringValue(val);
                this.myValueHolder.getRef().undefine();
                XmlTag tag = this.myValueHolder.getXmlTag();
                assert (tag != null);
                tag.collapseIfEmpty();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/xml/InjectionValueStyleInspection$RefQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/xml/InjectionValueStyleInspection$RefQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ValueQuickFix
    implements LocalQuickFix {
        private final SpringValueHolderDefinition myValueHolder;

        public ValueQuickFix(SpringValueHolderDefinition valueHolder) {
            this.myValueHolder = (SpringValueHolderDefinition)valueHolder.createStableCopy();
        }

        @NotNull
        public String getName() {
            String string = SpringBundle.message("model.inspection.injection.value.style.value.fix", this.myValueHolder instanceof SpringKey ? InjectionValueStyleInspection.KEY : InjectionValueStyleInspection.VALUE);
            if (string == null) {
                ValueQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SpringBundle.message("model.inspection.injection.value.style.value.fix.family.name", new Object[0]);
            if (string == null) {
                ValueQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            XmlElement xmlElement;
            if (project == null) {
                ValueQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                ValueQuickFix.$$$reportNull$$$0(3);
            }
            if ((xmlElement = this.myValueHolder.getXmlElement()) == null) {
                return;
            }
            GenericDomValue<?> valueElement = this.myValueHolder.getValueElement();
            assert (valueElement != null);
            String val = valueElement.getRawText();
            if (this.myValueHolder instanceof SpringKey) {
                SpringEntry entry = (SpringEntry)this.myValueHolder.getParent();
                assert (entry != null);
                entry.getKeyAttr().setStringValue(val);
                this.myValueHolder.undefine();
                XmlTag tag = entry.getXmlTag();
                assert (tag != null);
                tag.collapseIfEmpty();
            } else {
                if (this.myValueHolder instanceof SpringValueHolder) {
                    SpringValueHolder holder = (SpringValueHolder)this.myValueHolder;
                    holder.getValueAttr().undefine();
                    holder.getValue().undefine();
                }
                GenericDomValue<?> element = this.myValueHolder.getValueElement();
                assert (element != null);
                element.setStringValue(val);
                XmlTag tag = this.myValueHolder.getXmlTag();
                assert (tag != null);
                tag.collapseIfEmpty();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/highlighting/xml/InjectionValueStyleInspection$ValueQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/highlighting/xml/InjectionValueStyleInspection$ValueQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

