/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.values;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.jam.JamService;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.CreatePropertyFix;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.CombinedSpringModel;
import com.intellij.spring.contexts.model.LocalAnnotationModelImpl;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringJamPropertySource;
import com.intellij.spring.model.jam.stereotype.SpringPropertySource;
import com.intellij.spring.model.jam.stereotype.SpringPropertySources;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.values.PlaceholderInfo;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.model.xml.context.PropertyPlaceholder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.xml.DomElement;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderPropertyReference
extends PropertyReferenceBase
implements LocalQuickFixProvider {
    private final PlaceholderInfo myInfo;
    @Nullable
    private final String myDefaultValue;

    private PlaceholderPropertyReference(@NotNull String key, PsiElement element, TextRange textRange, PlaceholderInfo info, @Nullable String defaultValue) {
        if (key == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(0);
        }
        super(key, true, element, textRange);
        this.myInfo = info;
        this.myDefaultValue = defaultValue;
    }

    @Nullable
    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    public static PlaceholderPropertyReference create(PsiElement element, TextRange textRange, PlaceholderInfo info) {
        String text = info.text;
        if (text.contains(":")) {
            int offset = textRange.getStartOffset();
            int endOffset = text.indexOf(":");
            String key = text.substring(0, endOffset);
            String defaultValue = text.substring(endOffset + 1);
            return new PlaceholderPropertyReference(key, element, TextRange.from((int)offset, (int)endOffset), info, defaultValue){

                public boolean isSoft() {
                    return true;
                }
            };
        }
        return new PlaceholderPropertyReference(text, element, textRange, info, null);
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(1);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    private static Properties getValueProperties(SpringProperty property) {
        Properties props = new Properties();
        String value = property.getValue().getStringValue();
        if (!StringUtil.isEmptyOrSpaces((String)value)) {
            try {
                props.load(new StringReader(value));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Properties properties = props;
        if (properties == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(2);
        }
        return properties;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        HashSet properties = new HashSet();
        Processor processor = propertiesFile -> {
            properties.addAll(propertiesFile.findPropertiesByKey(this.myKey));
            return true;
        };
        HashSet<DomElement> configurerProperties = new HashSet<DomElement>();
        CommonSpringModel springModel = SpringModelUtils.getInstance().getSpringModel(this.myElement);
        List<SpringBeanPointer> placeholders = this.getPlaceholders(springModel);
        if (placeholders.size() > 0) {
            configurerProperties.addAll(this.getPlaceholderConfigurerProperties(this.myKey, placeholders));
            PlaceholderPropertyReference.processXmlProperties((Processor<PropertiesFile>)processor, placeholders);
        }
        PlaceholderPropertyReference.processEmbeddedPropertySources((Processor<PropertiesFile>)processor, springModel);
        PlaceholderPropertyReference.processCommonModel(this.myElement.getProject(), (Processor<PropertiesFile>)processor, springModel);
        ResolveResult[] result = new ResolveResult[properties.size() + configurerProperties.size()];
        if (properties.size() > 0 || configurerProperties.size() > 0) {
            int i = 0;
            for (IProperty property : properties) {
                result[i++] = new PsiElementResolveResult(property instanceof PsiElement ? (PsiElement)property : PomService.convertToPsi((PsiTarget)((PsiTarget)property)));
            }
            for (DomElement configurerProperty : configurerProperties) {
                result[i++] = new PsiElementResolveResult((PsiElement)configurerProperty.getXmlElement());
            }
        } else if (System.getProperties().getProperty(this.myKey) != null) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult(this.getElement())};
            if (resolveResultArray == null) {
                PlaceholderPropertyReference.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        if (result == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(4);
        }
        return result;
    }

    public static void processCommonModel(@NotNull Project project, @NotNull Processor<PropertiesFile> processor, @NotNull CommonSpringModel springModel) {
        if (project == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(6);
        }
        if (springModel == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(7);
        }
        if (springModel instanceof CombinedSpringModel) {
            for (CommonSpringModel commonSpringModel : ((CombinedSpringModel)springModel).getUnderlyingModels()) {
                PlaceholderPropertyReference.processSpringModelProperties(project, processor, commonSpringModel);
            }
        } else {
            PlaceholderPropertyReference.processSpringModelProperties(project, processor, springModel);
        }
    }

    private static void processSpringModelProperties(@NotNull Project project, @NotNull Processor<PropertiesFile> processor, @NotNull CommonSpringModel springModel) {
        if (project == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(9);
        }
        if (springModel == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(10);
        }
        if (springModel instanceof SpringModel) {
            SpringFileSet fileSet = ((SpringModel)springModel).getFileSet();
            if (fileSet != null) {
                PlaceholderPropertyReference.processFilesetCustomPropertiesFiles(processor, fileSet, project);
            }
            for (CommonSpringModel model : ((SpringModel)springModel).getModelsToProcess()) {
                if (model instanceof LocalAnnotationModelImpl) {
                    PlaceholderPropertyReference.processConfigurationProperties(processor, (LocalAnnotationModelImpl)model);
                    continue;
                }
                if (!(model instanceof SpringModel)) continue;
                PlaceholderPropertyReference.processSpringModelProperties(project, processor, model);
            }
        }
    }

    private static void processFilesetCustomPropertiesFiles(Processor<PropertiesFile> processor, SpringFileSet fileSet, Project project) {
        Set<VirtualFilePointer> files = fileSet.getPropertiesFiles();
        for (VirtualFilePointer pointer : files) {
            PsiFile psiFile;
            VirtualFile virtualFile = pointer.getFile();
            if (virtualFile == null || !((psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile)) instanceof PropertiesFile)) continue;
            processor.process((Object)((PropertiesFile)psiFile));
        }
    }

    static void processEmbeddedPropertySources(@NotNull Processor<PropertiesFile> processor, @NotNull CommonSpringModel model) {
        if (processor == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(11);
        }
        if (model == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(12);
        }
        List<SpringJamPropertySource> propertySources = PlaceholderPropertyReference.getPropertySources(model);
        for (SpringJamPropertySource propertySource : propertySources) {
            for (PropertiesFile file : propertySource.getPropertiesFiles()) {
                processor.process((Object)file);
            }
        }
    }

    @NotNull
    private static List<SpringJamPropertySource> getPropertySources(CommonSpringModel model) {
        List list = ContainerUtil.filter(PlaceholderPropertyReference.getPropertySources(model.getModule()), source -> {
            PsiClass psiClass = source.getPsiElement();
            return psiClass.isValid() && SpringCommonUtils.isSpringBeanCandidateClass(psiClass) && SpringModelSearchers.doesBeanExist(model, SpringModelSearchParameters.byClass(psiClass));
        });
        if (list == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private static List<SpringJamPropertySource> getPropertySources(@Nullable Module module) {
        if (module == null || DumbService.isDumb((Project)module.getProject())) {
            List<SpringJamPropertySource> list = Collections.emptyList();
            if (list == null) {
                PlaceholderPropertyReference.$$$reportNull$$$0(14);
            }
            return list;
        }
        List list = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            List propertySources = ContainerUtil.newSmartList();
            JamService jamService = JamService.getJamService((Project)module.getProject());
            propertySources.addAll(jamService.getJamClassElements(SpringJamPropertySource.META, "org.springframework.context.annotation.PropertySource", scope));
            for (SpringPropertySources springPropertySources : jamService.getJamClassElements(SpringPropertySources.META, "org.springframework.context.annotation.PropertySources", scope)) {
                propertySources.addAll(springPropertySources.getPropertySources());
            }
            return CachedValueProvider.Result.create((Object)propertySources, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
        if (list == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(15);
        }
        return list;
    }

    static boolean processConfigurationProperties(@NotNull Processor<PropertiesFile> processor, @NotNull LocalAnnotationModelImpl model) {
        SpringConfiguration configuration;
        if (processor == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(16);
        }
        if (model == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(17);
        }
        if ((configuration = model.getConfiguration()) == null) {
            return true;
        }
        for (PropertiesFile file : PlaceholderPropertyReference.getProperties(configuration, model.getAllCommonBeans())) {
            if (processor.process((Object)file)) continue;
            return false;
        }
        return true;
    }

    private static Set<PropertiesFile> getProperties(@NotNull SpringConfiguration configuration, @NotNull Collection<? extends SpringBeanPointer> beans) {
        if (configuration == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(18);
        }
        if (beans == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(19);
        }
        HashSet<PropertiesFile> files = new HashSet<PropertiesFile>();
        PlaceholderPropertyReference.addPropertiesFiles(configuration, files);
        for (SpringBeanPointer springBeanPointer : beans) {
            Object bean = springBeanPointer.getSpringBean();
            if (bean instanceof DomSpringBean && InheritanceUtil.isInheritor((PsiClass)PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType()), (String)"org.springframework.beans.factory.config.PlaceholderConfigurerSupport")) {
                for (Pair<String, PsiElement> pair : PlaceholderUtils.getInstance().getLocations((CommonSpringBean)bean)) {
                    ContainerUtil.addAllNotNull(files, PlaceholderUtils.getInstance().getPropertiesFile(pair));
                }
            }
            if (!(bean instanceof SpringConfiguration)) continue;
            PlaceholderPropertyReference.addPropertiesFiles((SpringConfiguration)bean, files);
        }
        return files;
    }

    private static void addPropertiesFiles(@NotNull SpringConfiguration bean, @NotNull Set<PropertiesFile> files) {
        if (bean == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(20);
        }
        if (files == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(21);
        }
        for (SpringPropertySource source : bean.getPropertySources()) {
            files.addAll(source.getPropertiesFiles());
        }
    }

    static void processXmlProperties(@NotNull Processor<PropertiesFile> processor, @NotNull List<SpringBeanPointer> placeholders) {
        if (processor == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(22);
        }
        if (placeholders == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(23);
        }
        for (PropertiesFile resource : PlaceholderUtils.getInstance().getResources(placeholders)) {
            if (!processor.process((Object)resource)) break;
        }
    }

    @NotNull
    private Set<DomElement> getPlaceholderConfigurerProperties(@NotNull String key, @NotNull List<SpringBeanPointer> placeholders) {
        Set set;
        if (key == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(24);
        }
        if (placeholders == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(25);
        }
        Set set2 = (set = (Set)RecursionManager.doPreventingRecursion((Object)((Object)this), (boolean)true, () -> {
            if (placeholders == null) {
                PlaceholderPropertyReference.$$$reportNull$$$0(29);
            }
            if (key == null) {
                PlaceholderPropertyReference.$$$reportNull$$$0(30);
            }
            return PlaceholderPropertyReference.getAllPlaceholderConfigurerProperties(placeholders).get(key);
        })) == null ? Collections.emptySet() : set;
        if (set2 == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(26);
        }
        return set2;
    }

    @NotNull
    static Map<String, Set<DomElement>> getAllPlaceholderConfigurerProperties(List<SpringBeanPointer> placeholders) {
        HashMap all = new HashMap();
        for (SpringBeanPointer placeholder : placeholders) {
            PropertyPlaceholder propertyPlaceholder;
            SpringBeanPointer propertyBeanHolder;
            Object placeholderBean = placeholder.getSpringBean();
            PlaceholderPropertyReference.addProperties((Map<String, Set<DomElement>>)all, placeholderBean);
            if (!(placeholderBean instanceof PropertyPlaceholder) || (propertyBeanHolder = (SpringBeanPointer)(propertyPlaceholder = (PropertyPlaceholder)placeholderBean).getPropertiesRef().getValue()) == null) continue;
            PlaceholderPropertyReference.addProperties((Map<String, Set<DomElement>>)all, propertyBeanHolder.getSpringBean());
        }
        HashMap hashMap = all;
        if (hashMap == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(27);
        }
        return hashMap;
    }

    private static void addProperties(Map<String, Set<DomElement>> all, CommonSpringBean bean) {
        SpringPropertyDefinition propertyDefinition = SpringPropertyUtils.findPropertyByName(bean, "properties");
        if (propertyDefinition instanceof SpringProperty) {
            for (Prop prop : ((SpringProperty)propertyDefinition).getProps().getProps()) {
                String propKey = prop.getKey().getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)propKey)) continue;
                if (!all.containsKey(propKey)) {
                    all.put(propKey, new HashSet());
                }
                all.get(propKey).add((DomElement)prop);
            }
            for (SpringEntry springEntry : ((SpringProperty)propertyDefinition).getMap().getEntries()) {
                String keyAttr = springEntry.getKeyAttr().getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)keyAttr)) continue;
                if (!all.containsKey(keyAttr)) {
                    all.put(keyAttr, new HashSet());
                }
                all.get(keyAttr).add(springEntry);
            }
            for (Object object : PlaceholderPropertyReference.getValueProperties((SpringProperty)propertyDefinition).keySet()) {
                if (!(object instanceof String)) continue;
                if (!all.containsKey(object)) {
                    all.put((String)object, new HashSet());
                }
                all.get(object).add(((SpringProperty)propertyDefinition).getValue());
            }
        }
    }

    public LocalQuickFix[] getQuickFixes() {
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel(this.myElement);
        List<SpringBeanPointer> placeholders = this.getPlaceholders(model);
        Set<PropertiesFile> resources = PlaceholderUtils.getInstance().getResources(placeholders);
        return new LocalQuickFix[]{new CreatePropertyFix(this.getElement(), this.myKey, new ArrayList<PropertiesFile>(resources))};
    }

    public List<SpringBeanPointer> getPlaceholders(@NotNull CommonSpringModel model) {
        if (model == null) {
            PlaceholderPropertyReference.$$$reportNull$$$0(28);
        }
        SmartList placeholders = new SmartList();
        for (SpringBeanPointer pointer : model.getPlaceholderConfigurers()) {
            Pair<String, String> pair = PlaceholderUtils.getInstance().getPlaceholderPrefixAndSuffixInner(pointer);
            if (!this.myInfo.prefixAndSuffix.equals(pair)) continue;
            placeholders.add(pointer);
        }
        return placeholders;
    }

    public TextRange getFullTextRange() {
        return this.myInfo.fullTextRange;
    }

    @Nullable
    protected List<PropertiesFile> getPropertiesFiles() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/values/PlaceholderPropertyReference";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 9: 
            case 11: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springModel";
                break;
            }
            case 12: 
            case 17: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 23: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/values/PlaceholderPropertyReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueProperties";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertySources";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderConfigurerProperties";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPlaceholderConfigurerProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processCommonModel";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processSpringModelProperties";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processEmbeddedPropertySources";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processConfigurationProperties";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addPropertiesFiles";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processXmlProperties";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderConfigurerProperties";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholders";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getPlaceholderConfigurerProperties$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 13: 
            case 14: 
            case 15: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

