/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.beans.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.ResolvedConstructorArgs;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringBeanFactoryMethodConverterImpl;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.beans.ConstructorArgDefinition;
import com.intellij.spring.model.xml.beans.ConstructorArgumentValues;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ResolvedConstructorArgsImpl
implements ResolvedConstructorArgs {
    private static final Comparator<PsiMethod> CTOR_COMPARATOR = (o1, o2) -> {
        boolean p2;
        boolean p1 = o1.hasModifierProperty("public");
        if (p1 != (p2 = o2.hasModifierProperty("public"))) {
            return p1 ? -1 : 1;
        }
        int c1pl = o1.getParameterList().getParametersCount();
        int c2pl = o2.getParameterList().getParametersCount();
        return Integer.compare(c2pl, c1pl);
    };
    private static final List<String> AUTOWIRE_ANNOTATIONS = ContainerUtil.immutableList((Object[])new String[]{"org.springframework.beans.factory.annotation.Autowired", "javax.inject.Inject"});
    @Nullable
    private PsiMethod myResolvedMethod;
    private final boolean myResolved;
    private final List<PsiMethod> myCandidates;
    private final Map<PsiMethod, Map<ConstructorArgDefinition, PsiParameter>> myResolvedArgs;
    private final Map<PsiMethod, Map<PsiParameter, Collection<SpringBeanPointer>>> myAutowiredParams;
    private final List<PsiMethod> myCheckedMethods;

    ResolvedConstructorArgsImpl(@NotNull SpringBean bean) {
        if (bean == null) {
            ResolvedConstructorArgsImpl.$$$reportNull$$$0(0);
        }
        this.myCandidates = new SmartList();
        this.myResolvedArgs = new HashMap<PsiMethod, Map<ConstructorArgDefinition, PsiParameter>>();
        this.myAutowiredParams = new HashMap<PsiMethod, Map<PsiParameter, Collection<SpringBeanPointer>>>();
        this.myCheckedMethods = new SmartList();
        this.myResolved = this.resolve(bean);
    }

    @Override
    public boolean isResolved() {
        return this.myResolved;
    }

    @Override
    @Nullable
    public PsiMethod getResolvedMethod() {
        return this.myResolvedMethod;
    }

    @Override
    @NotNull
    public List<PsiMethod> getCheckedMethods() {
        List<PsiMethod> list = this.myCheckedMethods;
        if (list == null) {
            ResolvedConstructorArgsImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @Nullable
    public Map<ConstructorArgDefinition, PsiParameter> getResolvedArgs() {
        return this.myResolvedMethod == null ? null : this.getResolvedArgs(this.myResolvedMethod);
    }

    @Override
    public Map<ConstructorArgDefinition, PsiParameter> getResolvedArgs(@NotNull PsiMethod method) {
        if (method == null) {
            ResolvedConstructorArgsImpl.$$$reportNull$$$0(2);
        }
        return this.myResolvedArgs.get(method);
    }

    @Override
    public Map<PsiParameter, Collection<SpringBeanPointer>> getAutowiredParams(@NotNull PsiMethod method) {
        if (method == null) {
            ResolvedConstructorArgsImpl.$$$reportNull$$$0(3);
        }
        return this.myAutowiredParams.get(method);
    }

    @Override
    public List<PsiMethod> getCandidates() {
        return this.myCandidates;
    }

    private boolean resolve(final SpringBean bean) {
        ArrayList methods;
        String factoryMethod = bean.getFactoryMethod().getStringValue();
        if (factoryMethod != null) {
            methods = SpringBeanFactoryMethodConverterImpl.getFactoryMethodCandidates(bean, factoryMethod);
            if (methods.isEmpty()) {
                return false;
            }
        } else {
            PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType());
            if (beanClass == null) {
                return false;
            }
            Object[] constructors = beanClass.getConstructors();
            if (constructors.length == 0) {
                return bean.getAllConstructorArgs().isEmpty();
            }
            methods = ContainerUtil.newArrayList((Object[])constructors);
        }
        int constructorArgsCount = bean.getAllConstructorArgs().size();
        boolean constructorAutowire = SpringAutowireUtil.isConstructorAutowire(bean);
        ConstructorArgumentValues values = new ConstructorArgumentValues();
        int minNrOfArgs = values.init(bean);
        NotNullLazyValue<CommonSpringModel> springModel = new NotNullLazyValue<CommonSpringModel>(){

            @NotNull
            protected CommonSpringModel compute() {
                CommonSpringModel commonSpringModel = SpringModelUtils.getInstance().getSpringModelByBean(bean);
                if (commonSpringModel == null) {
                    1.$$$reportNull$$$0(0);
                }
                return commonSpringModel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/xml/beans/impl/ResolvedConstructorArgsImpl$1", "compute"));
            }
        };
        Collections.sort(methods, CTOR_COMPARATOR);
        for (PsiMethod method : methods) {
            PsiParameter[] params = method.getParameterList().getParameters();
            if (this.myResolvedMethod != null && params.length < this.myResolvedMethod.getParameterList().getParametersCount()) {
                return true;
            }
            ArrayList<Object> allParams = new ArrayList<Object>(params.length);
            ArrayList<Pair> multiResolveParams = new ArrayList<Pair>(params.length);
            int paramsLength = params.length;
            for (int i = 0; i < paramsLength; ++i) {
                Pair pair = Pair.create((Object)params[i], (Object)i);
                PsiType psiType = params[i].getType();
                if (psiType.getCanonicalText().equals("java.lang.String") || psiType instanceof PsiEllipsisType) {
                    multiResolveParams.add(pair);
                    continue;
                }
                allParams.add(pair);
            }
            allParams.addAll(multiResolveParams);
            HashMap<ConstructorArgDefinition, PsiParameter> resolvedArgs = new HashMap<ConstructorArgDefinition, PsiParameter>(params.length);
            this.myResolvedArgs.put(method, resolvedArgs);
            boolean isAutowired = constructorAutowire || AnnotationUtil.isAnnotated((PsiModifierListOwner)method, AUTOWIRE_ANNOTATIONS, (int)0);
            HashMap<PsiParameter, Set<SpringBeanPointer>> autowiredParams = isAutowired ? new HashMap<PsiParameter, Set<SpringBeanPointer>>() : Collections.emptyMap();
            this.myAutowiredParams.put(method, autowiredParams);
            int autowiredCount = 0;
            LinkedHashSet<ConstructorArgDefinition> usedArgs = new LinkedHashSet<ConstructorArgDefinition>(constructorArgsCount);
            for (Pair pair : allParams) {
                PsiParameter param = (PsiParameter)pair.getFirst();
                ConstructorArgDefinition arg = values.resolve((Integer)pair.getSecond(), param, usedArgs);
                if (arg == null && !isAutowired) {
                    arg = values.resolveGeneric(null, usedArgs);
                }
                if (arg != null) {
                    usedArgs.add(arg);
                }
                if (arg == null && isAutowired) {
                    PsiType paramType = param.getType();
                    Set<SpringBeanPointer> beans = SpringAutowireUtil.autowireByType((CommonSpringModel)springModel.getValue(), paramType, null, false);
                    if (!beans.isEmpty() || SpringAutowireUtil.isAutowiredByDefault(paramType)) {
                        ++autowiredCount;
                    }
                    autowiredParams.put(param, beans);
                }
                if (arg == null) continue;
                resolvedArgs.put(arg, param);
            }
            if (resolvedArgs.size() + autowiredCount == params.length && minNrOfArgs <= params.length) {
                this.myResolvedMethod = method;
                this.myCandidates.add(method);
            }
            this.myCheckedMethods.add(method);
        }
        return this.myResolvedMethod != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/xml/beans/impl/ResolvedConstructorArgsImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/xml/beans/impl/ResolvedConstructorArgsImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckedMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedArgs";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAutowiredParams";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

