/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.statistics;

import com.intellij.facet.ProjectFacetManager;
import com.intellij.internal.statistic.AbstractProjectsUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.XmlUtil;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LegacySpringFacetFilesetUsagesCollector
extends AbstractProjectsUsagesCollector {
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)"spring", (double)100.0);
        if (groupDescriptor == null) {
            LegacySpringFacetFilesetUsagesCollector.$$$reportNull$$$0(0);
        }
        return groupDescriptor;
    }

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            LegacySpringFacetFilesetUsagesCollector.$$$reportNull$$$0(1);
        }
        HashSet<UsageDescriptor> usages = new HashSet<UsageDescriptor>();
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                LegacySpringFacetFilesetUsagesCollector.$$$reportNull$$$0(3);
            }
            for (SpringFacet springFacet : ProjectFacetManager.getInstance((Project)project).getFacets(SpringFacet.FACET_TYPE_ID)) {
                Set<SpringFileSet> fileSets = springFacet.getFileSets();
                usages.add(new UsageDescriptor("fileset_userConfiguredPerFacet_" + fileSets.size()));
                for (SpringFileSet fileSet : fileSets) {
                    int totalConfigurationFilesSize;
                    boolean hasXmlConfigs;
                    Set<VirtualFilePointer> codeConfigurationFiles = fileSet.getCodeConfigurationFiles();
                    boolean hasJavaConfigs = !codeConfigurationFiles.isEmpty();
                    Set<VirtualFilePointer> xmlConfigurationFiles = fileSet.getXmlFiles();
                    boolean bl = hasXmlConfigs = !xmlConfigurationFiles.isEmpty();
                    if (hasJavaConfigs && hasXmlConfigs) {
                        usages.add(new UsageDescriptor("fileset_mixedContext"));
                    } else if (hasJavaConfigs) {
                        usages.add(new UsageDescriptor("fileset_annotationContext"));
                    } else if (hasXmlConfigs) {
                        usages.add(new UsageDescriptor("fileset_xmlContext"));
                    }
                    LegacySpringFacetFilesetUsagesCollector.addXMLNamespaceUsages(project, usages, xmlConfigurationFiles);
                    if (!fileSet.getPropertiesFiles().isEmpty()) {
                        usages.add(new UsageDescriptor("fileset_propertiesFiles"));
                    }
                    if (!fileSet.getDependencyFileSets().isEmpty()) {
                        usages.add(new UsageDescriptor("fileset_dependencyFileset"));
                    }
                    if ((totalConfigurationFilesSize = codeConfigurationFiles.size() + xmlConfigurationFiles.size()) == 1) {
                        usages.add(new UsageDescriptor("fileset_configFiles1"));
                        continue;
                    }
                    if (totalConfigurationFilesSize <= 5) {
                        usages.add(new UsageDescriptor("fileset_configFiles5"));
                        continue;
                    }
                    if (totalConfigurationFilesSize <= 10) {
                        usages.add(new UsageDescriptor("fileset_configFiles10"));
                        continue;
                    }
                    usages.add(new UsageDescriptor("fileset_configFilesGreater10"));
                }
                List<SpringFileSet> modelProviderSets = SpringFileSetService.getInstance().getModelProviderSets(springFacet);
                if (modelProviderSets.isEmpty()) {
                    usages.add(new UsageDescriptor("fileset_autodetect_NONE"));
                    continue;
                }
                for (SpringFileSet modelProviderFileSet : modelProviderSets) {
                    usages.add(new UsageDescriptor("fileset_autodetect_" + modelProviderFileSet.getClass().getName()));
                }
            }
        });
        HashSet<UsageDescriptor> hashSet = usages;
        if (hashSet == null) {
            LegacySpringFacetFilesetUsagesCollector.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    private static void addXMLNamespaceUsages(Project project, Set<UsageDescriptor> usages, Set<VirtualFilePointer> files) {
        HashSet<XmlFile> processed = new HashSet<XmlFile>();
        for (VirtualFilePointer file : files) {
            XmlTag rootTag;
            XmlFile xmlFile;
            PsiFile psiFile;
            VirtualFile virtualFile = file.getFile();
            if (virtualFile == null || !((psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile)) instanceof XmlFile) || !processed.add(xmlFile = (XmlFile)psiFile) || !SpringDomUtils.isSpringXml(xmlFile) || (rootTag = xmlFile.getRootTag()) == null) continue;
            for (String namespace : rootTag.knownNamespaces()) {
                if (ArrayUtil.contains((Object)namespace, (Object[])new Serializable[]{XmlUtil.SCHEMA_URIS, "http://www.w3.org/2001/XMLSchema-instance", "http://www.springframework.org/dtd/spring-beans.dtd", "http://www.springframework.org/dtd/spring-beans-2.0.dtd", "http://www.springframework.org/schema/beans"})) continue;
                String nsUsageKey = namespace.contains("://") ? StringUtil.substringAfter((String)namespace, (String)"://") : namespace;
                usages.add(new UsageDescriptor("xmlNS_" + nsUsageKey));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/statistics/LegacySpringFacetFilesetUsagesCollector";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/statistics/LegacySpringFacetFilesetUsagesCollector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectUsages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProjectUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getProjectUsages$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

