/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;

public class XmlMatchingVisitor
extends XmlElementVisitor {
    private final GlobalMatchingVisitor myMatchingVisitor;
    private final boolean myCaseSensitive;

    public XmlMatchingVisitor(GlobalMatchingVisitor matchingVisitor) {
        this.myMatchingVisitor = matchingVisitor;
        this.myCaseSensitive = this.myMatchingVisitor.getMatchContext().getOptions().isCaseSensitiveMatch();
    }

    public void visitXmlAttribute(XmlAttribute attribute) {
        XmlAttribute another = (XmlAttribute)this.myMatchingVisitor.getElement();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(attribute.getName());
        if (!this.myMatchingVisitor.setResult(isTypedVar || this.matches(attribute.getName(), another.getName()))) {
            return;
        }
        XmlAttributeValue valueElement = attribute.getValueElement();
        if (valueElement != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.match((PsiElement)valueElement, (PsiElement)another.getValueElement()))) {
            return;
        }
        if (isTypedVar) {
            SubstitutionHandler handler = (SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler(attribute.getName());
            this.myMatchingVisitor.setResult(handler.handle((PsiElement)another, this.myMatchingVisitor.getMatchContext()));
        }
    }

    public void visitXmlAttributeValue(XmlAttributeValue value) {
        XmlAttributeValue another = (XmlAttributeValue)this.myMatchingVisitor.getElement();
        String text = value.getValue();
        if (this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(text)) {
            SubstitutionHandler handler = (SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler(text);
            String text2 = another.getText();
            int offset = !text2.isEmpty() && (text2.charAt(0) == '\"' || text2.charAt(0) == '\'') ? 1 : 0;
            this.myMatchingVisitor.setResult(handler.handle((PsiElement)another, offset, text2.length() - offset, this.myMatchingVisitor.getMatchContext()));
        } else {
            this.myMatchingVisitor.setResult(this.matches(text, another.getValue()));
        }
    }

    public void visitXmlTag(XmlTag tag) {
        PsiElement[] children;
        SsrFilteringNodeIterator matchNodes;
        XmlTag another = (XmlTag)this.myMatchingVisitor.getElement();
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar(tag.getName());
        if (!this.myMatchingVisitor.setResult((this.matches(tag.getName(), another.getName()) || isTypedVar) && this.myMatchingVisitor.matchInAnyOrder((PsiElement[])tag.getAttributes(), (PsiElement[])another.getAttributes()))) {
            return;
        }
        SsrFilteringNodeIterator patternNodes = new SsrFilteringNodeIterator(new ArrayBackedNodeIterator((PsiElement[])tag.getValue().getChildren()));
        if (patternNodes.current() != null && !this.myMatchingVisitor.setResult(this.myMatchingVisitor.matchSequentially(patternNodes, matchNodes = new SsrFilteringNodeIterator(new ArrayBackedNodeIterator((PsiElement[])another.getValue().getChildren()))))) {
            return;
        }
        if (isTypedVar && (children = another.getChildren()).length > 1) {
            SubstitutionHandler handler = (SubstitutionHandler)this.myMatchingVisitor.getMatchContext().getPattern().getHandler(tag.getName());
            this.myMatchingVisitor.setResult(handler.handle(children[1], this.myMatchingVisitor.getMatchContext()));
        }
    }

    public void visitXmlText(XmlText text) {
        boolean isTypedVar = this.myMatchingVisitor.getMatchContext().getPattern().isTypedVar((PsiElement)text);
        PsiElement element = this.myMatchingVisitor.getElement();
        if (isTypedVar) {
            this.myMatchingVisitor.setResult(this.myMatchingVisitor.handleTypedElement((PsiElement)text, element));
        } else {
            this.myMatchingVisitor.setResult(element instanceof XmlText && this.matches(text.getText().trim(), element.getText().trim()));
        }
    }

    private boolean matches(String a, String b) {
        return this.myCaseSensitive ? a.equals(b) : a.equalsIgnoreCase(b);
    }
}

