/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class ReplacementBuilder {
    private final String replacement;
    private final List<ParameterInfo> parameterizations = new SmartList();
    private final Map<String, ScriptSupport> replacementVarsMap = new HashMap<String, ScriptSupport>();
    private final ReplaceOptions options;
    private final Project myProject;

    ReplacementBuilder(Project project, ReplaceOptions options) {
        this.myProject = project;
        this.options = options;
        Template template = TemplateManager.getInstance((Project)project).createTemplate("", "", options.getReplacement());
        this.replacement = template.getTemplateText();
        int prevOffset = 0;
        for (int i = 0; i < template.getSegmentsCount(); ++i) {
            int pos;
            String name;
            int offset = template.getSegmentOffset(i);
            ParameterInfo info = new ParameterInfo(name, offset, options.getVariableDefinition(name = template.getSegmentName(i)) != null);
            for (pos = offset - 1; pos >= prevOffset && pos < this.replacement.length() && StringUtil.isWhiteSpace((char)this.replacement.charAt(pos)); --pos) {
            }
            if (pos >= 0) {
                if (this.replacement.charAt(pos) == ',') {
                    info.setHasCommaBefore(true);
                }
                while (pos > prevOffset && StringUtil.isWhiteSpace((char)this.replacement.charAt(pos - 1))) {
                    --pos;
                }
                info.setBeforeDelimiterPos(pos);
            }
            for (pos = offset; pos < this.replacement.length() && StringUtil.isWhiteSpace((char)this.replacement.charAt(pos)); ++pos) {
            }
            if (pos < this.replacement.length()) {
                char ch = this.replacement.charAt(pos);
                if (ch == ';') {
                    info.setStatementContext(true);
                } else if (ch == ',' || ch == ')') {
                    info.setArgumentContext(true);
                    info.setHasCommaAfter(ch == ',');
                }
            }
            info.setAfterDelimiterPos(pos);
            prevOffset = offset;
            this.parameterizations.add(info);
        }
        FileType fileType = options.getMatchOptions().getFileType();
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(fileType);
        if (profile != null) {
            try {
                PsiElement[] elements = MatcherImplUtil.createTreeFromText(options.getReplacement(), PatternTreeContext.Block, fileType, options.getMatchOptions().getDialect(), options.getMatchOptions().getPatternContext(), project, false);
                if (elements.length > 0) {
                    PsiElement patternNode = elements[0].getParent();
                    patternNode.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(PsiElement element) {
                            ParameterInfo parameterInfo;
                            super.visitElement(element);
                            String text = element.getText();
                            if (StructuralSearchUtil.isTypedVariable(text) && (parameterInfo = ReplacementBuilder.this.findParameterization(Replacer.stripTypedVariableDecoration(text))) != null && parameterInfo.getElement() == null) {
                                parameterInfo.setElement(element);
                            }
                        }
                    });
                    profile.provideAdditionalReplaceOptions(patternNode, options, this);
                }
            }
            catch (IncorrectOperationException e) {
                throw new MalformedPatternException(e.getMessage());
            }
        }
    }

    String process(MatchResult match, ReplacementInfo replacementInfo, FileType type) {
        if (this.parameterizations.isEmpty()) {
            return this.replacement;
        }
        StringBuilder result = new StringBuilder(this.replacement);
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(type);
        assert (profile != null);
        int offset = 0;
        for (ParameterInfo info : this.parameterizations) {
            MatchResult r = replacementInfo.getNamedMatchResult(info.getName());
            if (info.isReplacementVariable()) {
                offset = Replacer.insertSubstitution(result, offset, info, this.generateReplacement(info, match));
                continue;
            }
            if (r != null) {
                offset = profile.handleSubstitution(info, r, result, offset, replacementInfo);
                continue;
            }
            offset = profile.handleNoSubstitution(info, offset, result);
        }
        return result.toString();
    }

    private String generateReplacement(ParameterInfo info, MatchResult match) {
        ScriptSupport scriptSupport = this.replacementVarsMap.get(info.getName());
        if (scriptSupport == null) {
            String constraint = this.options.getVariableDefinition(info.getName()).getScriptCodeConstraint();
            scriptSupport = new ScriptSupport(this.myProject, StringUtil.stripQuotesAroundValue((String)constraint), info.getName());
            this.replacementVarsMap.put(info.getName(), scriptSupport);
        }
        return scriptSupport.evaluate(match, null);
    }

    @Nullable
    public ParameterInfo findParameterization(String name) {
        for (ParameterInfo info : this.parameterizations) {
            if (!info.getName().equals(name)) continue;
            return info;
        }
        return null;
    }
}

