/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.OptionsPanelImpl;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.colors.AbstractKeyDescriptor;
import com.intellij.openapi.options.colors.ColorAndFontDescriptorsProvider;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.BitUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.FontUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorAndFontDescriptionPanel
extends JPanel
implements OptionsPanelImpl.ColorDescriptionPanel {
    private final EventDispatcher<OptionsPanelImpl.ColorDescriptionPanel.Listener> myDispatcher;
    private JPanel myPanel;
    private ColorPanel myBackgroundChooser;
    private ColorPanel myForegroundChooser;
    private ColorPanel myEffectsColorChooser;
    private ColorPanel myErrorStripeColorChooser;
    private JBCheckBox myCbBackground;
    private JBCheckBox myCbForeground;
    private JBCheckBox myCbEffects;
    private JBCheckBox myCbErrorStripe;
    private final Map<String, EffectType> myEffectsMap;
    private JComboBox myEffectsCombo;
    private JBCheckBox myCbBold;
    private JBCheckBox myCbItalic;
    private JLabel myLabelFont;
    private JTextPane myInheritanceLabel;
    private JBCheckBox myInheritAttributesBox;
    private boolean myUiEventsEnabled;

    public ColorAndFontDescriptionPanel() {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.myDispatcher = EventDispatcher.create(OptionsPanelImpl.ColorDescriptionPanel.Listener.class);
        LinkedHashMap map = ContainerUtil.newLinkedHashMap();
        map.put(ApplicationBundle.message((String)"combobox.effect.underscored", (Object[])new Object[0]), EffectType.LINE_UNDERSCORE);
        map.put(ApplicationBundle.message((String)"combobox.effect.boldunderscored", (Object[])new Object[0]), EffectType.BOLD_LINE_UNDERSCORE);
        map.put(ApplicationBundle.message((String)"combobox.effect.underwaved", (Object[])new Object[0]), EffectType.WAVE_UNDERSCORE);
        map.put(ApplicationBundle.message((String)"combobox.effect.bordered", (Object[])new Object[0]), EffectType.BOXED);
        map.put(ApplicationBundle.message((String)"combobox.effect.strikeout", (Object[])new Object[0]), EffectType.STRIKEOUT);
        map.put(ApplicationBundle.message((String)"combobox.effect.bold.dottedline", (Object[])new Object[0]), EffectType.BOLD_DOTTED_LINE);
        this.myEffectsMap = Collections.unmodifiableMap(map);
        this.myUiEventsEnabled = true;
        this.add((Component)this.myPanel, "Center");
        this.setBorder((Border)JBUI.Borders.empty((int)4, (int)0, (int)4, (int)4));
        this.myEffectsCombo.setModel(new CollectionComboBoxModel((List)ContainerUtil.newArrayList(this.myEffectsMap.keySet())));
        this.myEffectsCombo.setRenderer(new ListCellRendererWrapper<String>(){

            public void customize(JList list2, String value, int index, boolean selected, boolean hasFocus) {
                this.setText(value != null ? value : "<invalid>");
            }
        });
        ActionListener actionListener = e -> {
            if (this.myUiEventsEnabled) {
                this.myErrorStripeColorChooser.setEnabled(this.myCbErrorStripe.isSelected());
                this.myForegroundChooser.setEnabled(this.myCbForeground.isSelected());
                this.myBackgroundChooser.setEnabled(this.myCbBackground.isSelected());
                this.myEffectsColorChooser.setEnabled(this.myCbEffects.isSelected());
                this.myEffectsCombo.setEnabled(this.myCbEffects.isSelected());
                ((OptionsPanelImpl.ColorDescriptionPanel.Listener)this.myDispatcher.getMulticaster()).onSettingsChanged(e);
            }
        };
        for (JBCheckBox jBCheckBox : new JBCheckBox[]{this.myCbBackground, this.myCbForeground, this.myCbEffects, this.myCbErrorStripe, this.myCbItalic, this.myCbBold, this.myInheritAttributesBox}) {
            jBCheckBox.addActionListener(actionListener);
        }
        for (JBCheckBox jBCheckBox : new ColorPanel[]{this.myBackgroundChooser, this.myForegroundChooser, this.myEffectsColorChooser, this.myErrorStripeColorChooser}) {
            jBCheckBox.addActionListener(actionListener);
        }
        this.myEffectsCombo.addActionListener(actionListener);
        Messages.configureMessagePaneUi((JTextPane)this.myInheritanceLabel, (String)"<html>", null);
        this.myInheritanceLabel.addHyperlinkListener(e -> ((OptionsPanelImpl.ColorDescriptionPanel.Listener)this.myDispatcher.getMulticaster()).onHyperLinkClicked(e));
        this.myInheritanceLabel.setBorder((Border)JBUI.Borders.empty((int)4, (int)0, (int)4, (int)4));
        this.myLabelFont.setVisible(false);
    }

    @Override
    @NotNull
    public JComponent getPanel() {
        ColorAndFontDescriptionPanel colorAndFontDescriptionPanel = this;
        if (colorAndFontDescriptionPanel == null) {
            ColorAndFontDescriptionPanel.$$$reportNull$$$0(0);
        }
        return colorAndFontDescriptionPanel;
    }

    @Override
    public void resetDefault() {
        try {
            this.myUiEventsEnabled = false;
            this.myLabelFont.setEnabled(false);
            this.myCbBold.setSelected(false);
            this.myCbBold.setEnabled(false);
            this.myCbItalic.setSelected(false);
            this.myCbItalic.setEnabled(false);
            ColorAndFontDescriptionPanel.updateColorChooser((JCheckBox)this.myCbForeground, this.myForegroundChooser, false, false, null);
            ColorAndFontDescriptionPanel.updateColorChooser((JCheckBox)this.myCbBackground, this.myBackgroundChooser, false, false, null);
            ColorAndFontDescriptionPanel.updateColorChooser((JCheckBox)this.myCbErrorStripe, this.myErrorStripeColorChooser, false, false, null);
            ColorAndFontDescriptionPanel.updateColorChooser((JCheckBox)this.myCbEffects, this.myEffectsColorChooser, false, false, null);
            this.myEffectsCombo.setEnabled(false);
            this.myInheritanceLabel.setVisible(false);
            this.myInheritAttributesBox.setVisible(false);
        }
        finally {
            this.myUiEventsEnabled = true;
        }
    }

    private static void updateColorChooser(JCheckBox checkBox, ColorPanel colorPanel, boolean isEnabled, boolean isChecked, @Nullable Color color) {
        checkBox.setEnabled(isEnabled);
        checkBox.setSelected(isChecked);
        if (color != null) {
            colorPanel.setSelectedColor(color);
        } else {
            colorPanel.setSelectedColor((Color)JBColor.WHITE);
        }
        colorPanel.setEnabled(isChecked);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(@NotNull EditorSchemeAttributeDescriptor attrDescription) {
        if (attrDescription == null) {
            ColorAndFontDescriptionPanel.$$$reportNull$$$0(1);
        }
        try {
            this.myUiEventsEnabled = false;
            if (!(attrDescription instanceof ColorAndFontDescription)) {
                return;
            }
            ColorAndFontDescription description = (ColorAndFontDescription)attrDescription;
            if (description.isFontEnabled()) {
                this.myLabelFont.setEnabled(description.isEditable());
                this.myCbBold.setEnabled(description.isEditable());
                this.myCbItalic.setEnabled(description.isEditable());
                int fontType = description.getFontType();
                this.myCbBold.setSelected(BitUtil.isSet((int)fontType, (int)1));
                this.myCbItalic.setSelected(BitUtil.isSet((int)fontType, (int)2));
            } else {
                this.myLabelFont.setEnabled(false);
                this.myCbBold.setSelected(false);
                this.myCbBold.setEnabled(false);
                this.myCbItalic.setSelected(false);
                this.myCbItalic.setEnabled(false);
            }
            ColorAndFontDescriptionPanel.updateColorChooser((JCheckBox)this.myCbForeground, this.myForegroundChooser, description.isForegroundEnabled(), description.isForegroundChecked(), description.getForegroundColor());
            ColorAndFontDescriptionPanel.updateColorChooser((JCheckBox)this.myCbBackground, this.myBackgroundChooser, description.isBackgroundEnabled(), description.isBackgroundChecked(), description.getBackgroundColor());
            ColorAndFontDescriptionPanel.updateColorChooser((JCheckBox)this.myCbErrorStripe, this.myErrorStripeColorChooser, description.isErrorStripeEnabled(), description.isErrorStripeChecked(), description.getErrorStripeColor());
            EffectType effectType = description.getEffectType();
            ColorAndFontDescriptionPanel.updateColorChooser((JCheckBox)this.myCbEffects, this.myEffectsColorChooser, description.isEffectsColorEnabled(), description.isEffectsColorChecked(), description.getEffectColor());
            String name = (String)ContainerUtil.reverseMap(this.myEffectsMap).get(effectType);
            this.myEffectsCombo.getModel().setSelectedItem(name);
            this.myEffectsCombo.setEnabled(description.isEffectsColorEnabled() && description.isEffectsColorChecked() && description.isEditable());
            this.setInheritanceInfo(description);
            this.myLabelFont.setEnabled(this.myCbBold.isEnabled() || this.myCbItalic.isEnabled());
        }
        finally {
            this.myUiEventsEnabled = true;
        }
    }

    private void setInheritanceInfo(ColorAndFontDescription description) {
        Pair<ColorAndFontDescriptorsProvider, ? extends AbstractKeyDescriptor> baseDescriptor = description.getFallbackKeyDescriptor();
        if (baseDescriptor != null && ((AbstractKeyDescriptor)baseDescriptor.second).getDisplayName() != null) {
            String labelText;
            String tooltipText;
            String attrName = ((AbstractKeyDescriptor)baseDescriptor.second).getDisplayName();
            String attrLabel = attrName.replaceAll("//", FontUtil.rightArrow((Font)UIUtil.getLabelFont()));
            ColorAndFontDescriptorsProvider settingsPage = (ColorAndFontDescriptorsProvider)baseDescriptor.first;
            String style = "<div style=\"text-align:right\" vertical-align=\"top\">";
            if (settingsPage != null) {
                String pageName = settingsPage.getDisplayName();
                tooltipText = "Editor | Color Scheme | " + pageName + "<br>" + attrLabel;
                labelText = style + "<a href=\"" + pageName + "\">" + attrLabel + "</a><br>(" + pageName + ")";
            } else {
                tooltipText = attrLabel;
                labelText = style + attrLabel + "<br>&nbsp;";
            }
            this.myInheritanceLabel.setVisible(true);
            this.myInheritanceLabel.setText(labelText);
            this.myInheritanceLabel.getCaret().setDot(0);
            this.myInheritanceLabel.setToolTipText(tooltipText);
            this.myInheritanceLabel.setEnabled(true);
            this.myInheritAttributesBox.setVisible(true);
            this.myInheritAttributesBox.setEnabled(description.isEditable());
            this.myInheritAttributesBox.setSelected(description.isInherited());
            this.setEditEnabled(!description.isInherited() && description.isEditable(), description);
        } else {
            this.myInheritanceLabel.setVisible(false);
            this.myInheritAttributesBox.setSelected(false);
            this.myInheritAttributesBox.setVisible(false);
            this.setEditEnabled(description.isEditable(), description);
        }
    }

    private void setEditEnabled(boolean isEditEnabled, ColorAndFontDescription description) {
        this.myCbBackground.setEnabled(isEditEnabled && description.isBackgroundEnabled());
        this.myCbForeground.setEnabled(isEditEnabled && description.isForegroundEnabled());
        this.myCbBold.setEnabled(isEditEnabled && description.isFontEnabled());
        this.myCbItalic.setEnabled(isEditEnabled && description.isFontEnabled());
        this.myCbEffects.setEnabled(isEditEnabled && description.isEffectsColorEnabled());
        this.myCbErrorStripe.setEnabled(isEditEnabled && description.isErrorStripeEnabled());
        this.myErrorStripeColorChooser.setEditable(isEditEnabled);
        this.myEffectsColorChooser.setEditable(isEditEnabled);
        this.myForegroundChooser.setEditable(isEditEnabled);
        this.myBackgroundChooser.setEditable(isEditEnabled);
    }

    @Override
    public void apply(@NotNull EditorSchemeAttributeDescriptor attrDescription, EditorColorsScheme scheme2) {
        if (attrDescription == null) {
            ColorAndFontDescriptionPanel.$$$reportNull$$$0(2);
        }
        if (!(attrDescription instanceof ColorAndFontDescription)) {
            return;
        }
        ColorAndFontDescription description = (ColorAndFontDescription)attrDescription;
        description.setInherited(this.myInheritAttributesBox.isSelected());
        if (description.isInherited()) {
            TextAttributes baseAttributes = description.getBaseAttributes();
            if (baseAttributes != null) {
                description.setFontType(baseAttributes.getFontType());
                description.setForegroundChecked(baseAttributes.getForegroundColor() != null);
                description.setForegroundColor(baseAttributes.getForegroundColor());
                description.setBackgroundChecked(baseAttributes.getBackgroundColor() != null);
                description.setBackgroundColor(baseAttributes.getBackgroundColor());
                description.setErrorStripeChecked(baseAttributes.getErrorStripeColor() != null);
                description.setErrorStripeColor(baseAttributes.getErrorStripeColor());
                description.setEffectColor(baseAttributes.getEffectColor());
                description.setEffectType(baseAttributes.getEffectType());
                description.setEffectsColorChecked(baseAttributes.getEffectColor() != null);
            } else {
                description.setInherited(false);
            }
            this.reset((EditorSchemeAttributeDescriptor)description);
        } else {
            this.setInheritanceInfo(description);
            int fontType = 0;
            if (this.myCbBold.isSelected()) {
                fontType |= 1;
            }
            if (this.myCbItalic.isSelected()) {
                fontType |= 2;
            }
            description.setFontType(fontType);
            description.setForegroundChecked(this.myCbForeground.isSelected());
            description.setForegroundColor(this.myForegroundChooser.getSelectedColor());
            description.setBackgroundChecked(this.myCbBackground.isSelected());
            description.setBackgroundColor(this.myBackgroundChooser.getSelectedColor());
            description.setErrorStripeChecked(this.myCbErrorStripe.isSelected());
            description.setErrorStripeColor(this.myErrorStripeColorChooser.getSelectedColor());
            description.setEffectsColorChecked(this.myCbEffects.isSelected());
            description.setEffectColor(this.myEffectsColorChooser.getSelectedColor());
            if (this.myEffectsCombo.isEnabled()) {
                String effectType = (String)this.myEffectsCombo.getModel().getSelectedItem();
                description.setEffectType(this.myEffectsMap.get(effectType));
            }
        }
        description.apply(scheme2);
    }

    @Override
    public void addListener(@NotNull OptionsPanelImpl.ColorDescriptionPanel.Listener listener2) {
        if (listener2 == null) {
            ColorAndFontDescriptionPanel.$$$reportNull$$$0(3);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/ColorAndFontDescriptionPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrDescription";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/ColorAndFontDescriptionPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JTextPane jTextPane;
        JBCheckBox jBCheckBox3;
        ColorPanel colorPanel;
        ColorPanel colorPanel2;
        ColorPanel colorPanel3;
        ColorPanel colorPanel4;
        JBCheckBox jBCheckBox4;
        JBCheckBox jBCheckBox5;
        JBCheckBox jBCheckBox6;
        JBCheckBox jBCheckBox7;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(10, 3, new Insets(0, 10, 10, 10), -1, -1, false, false));
        this.myCbForeground = jBCheckBox7 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox7, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.color.foreground"));
        jPanel.add((Component)jBCheckBox7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCbBackground = jBCheckBox6 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox6, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.color.background"));
        jPanel.add((Component)jBCheckBox6, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCbErrorStripe = jBCheckBox5 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.color.error.stripe.mark"));
        jPanel.add((Component)jBCheckBox5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCbEffects = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.color.effects"));
        jPanel.add((Component)jBCheckBox4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myForegroundChooser = colorPanel4 = new ColorPanel();
        jPanel.add((Component)colorPanel4, new GridConstraints(1, 1, 1, 1, 4, 2, 0, 0, null, null, null));
        this.myBackgroundChooser = colorPanel3 = new ColorPanel();
        jPanel.add((Component)colorPanel3, new GridConstraints(2, 1, 1, 1, 4, 2, 0, 0, null, null, null));
        this.myErrorStripeColorChooser = colorPanel2 = new ColorPanel();
        jPanel.add((Component)colorPanel2, new GridConstraints(3, 1, 1, 1, 4, 2, 0, 0, null, null, null));
        this.myEffectsColorChooser = colorPanel = new ColorPanel();
        jPanel.add((Component)colorPanel, new GridConstraints(4, 1, 1, 1, 4, 2, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(30, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(6, 0, 3, 2, 0, 3, 0, 0, null, null, null, 0, true));
        this.myInheritAttributesBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.inherit.attributes"));
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jBScrollPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), null, 0, 0, null, null));
        this.myInheritanceLabel = jTextPane = new JTextPane();
        jTextPane.setText("labl");
        jBScrollPane.setViewportView(jTextPane);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 4, 2, 0, 0, null, null, null));
        this.myCbBold = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.font.bold"));
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myCbItalic = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.font.italic"));
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 2, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myLabelFont = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ApplicationBundle").getString("label.font.type"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ComboBox comboBox = new ComboBox();
        this.myEffectsCombo = comboBox;
        jPanel.add((Component)comboBox, new GridConstraints(5, 0, 1, 2, 4, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(9, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

