/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Key;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\t2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0004J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0014J(\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014H\u0016R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u001e"}, d2={"Lcom/intellij/codeInsight/daemon/impl/HintRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "setText", "calcWidthInPixels", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "doCalcWidth", "fontMetrics", "Ljava/awt/FontMetrics;", "getFont", "Ljava/awt/Font;", "getFontMetrics", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer$MyFontMetrics;", "getTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "paint", "", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "textAttributes", "Companion", "MyFontMetrics", "intellij.platform.lang.impl"})
public class HintRenderer
implements EditorCustomElementRenderer {
    @Nullable
    private String text;
    private static final Key<MyFontMetrics> HINT_FONT_METRICS;
    private static final float BACKGROUND_ALPHA = 0.55f;
    public static final Companion Companion;

    public int calcWidthInPixels(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        return this.doCalcWidth(this.text, this.getFontMetrics(editor).getMetrics());
    }

    @Nullable
    protected TextAttributes getTextAttributes(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        return editor.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT);
    }

    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        Intrinsics.checkParameterIsNotNull((Object)textAttributes, (String)"textAttributes");
        if (!(editor instanceof EditorImpl)) {
            return;
        }
        int ascent = ((EditorImpl)editor).getAscent();
        int descent = ((EditorImpl)editor).getDescent();
        Graphics2D g2d = (Graphics2D)g;
        TextAttributes attributes = this.getTextAttributes(editor);
        if (this.text != null && attributes != null) {
            Color foregroundColor;
            MyFontMetrics fontMetrics = this.getFontMetrics(editor);
            int gap = r.height < fontMetrics.getLineHeight() + 2 ? 1 : 2;
            Color backgroundColor = attributes.getBackgroundColor();
            if (backgroundColor != null) {
                GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
                GraphicsUtil.paintWithAlpha((Graphics)g, (float)HintRenderer.Companion.getBACKGROUND_ALPHA());
                g.setColor(backgroundColor);
                g.fillRoundRect(r.x + 2, r.y + gap, r.width - 4, r.height - gap * 2, 8, 8);
                config.restore();
            }
            if ((foregroundColor = attributes.getForegroundColor()) != null) {
                Object savedHint = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                Shape savedClip = g.getClip();
                g.setColor(foregroundColor);
                g.setFont(this.getFont(editor));
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)false));
                g.clipRect(r.x + 3, r.y + 2, r.width - 6, r.height - 4);
                FontMetrics metrics = fontMetrics.getMetrics();
                g.drawString(this.text, r.x + 7, r.y + Math.max(ascent, (r.height + metrics.getAscent() - metrics.getDescent()) / 2) - 1);
                g.setClip(savedClip);
                g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedHint);
            }
        }
        Color effectColor = textAttributes.getEffectColor();
        EffectType effectType = textAttributes.getEffectType();
        if (effectColor != null) {
            g.setColor(effectColor);
            int xStart = r.x;
            int xEnd = r.x + r.width;
            int y = r.y + ascent;
            Font font = editor.getColorsScheme().getFont(EditorFontType.PLAIN);
            if (Intrinsics.areEqual((Object)effectType, (Object)EffectType.LINE_UNDERSCORE)) {
                EffectPainter.LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font);
            } else if (Intrinsics.areEqual((Object)effectType, (Object)EffectType.BOLD_LINE_UNDERSCORE)) {
                EffectPainter.BOLD_LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font);
            } else if (Intrinsics.areEqual((Object)effectType, (Object)EffectType.STRIKEOUT)) {
                EffectPainter.STRIKE_THROUGH.paint(g2d, xStart, y, xEnd - xStart, ((EditorImpl)editor).getCharHeight(), (Object)font);
            } else if (Intrinsics.areEqual((Object)effectType, (Object)EffectType.WAVE_UNDERSCORE)) {
                EffectPainter.WAVE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font);
            } else if (Intrinsics.areEqual((Object)effectType, (Object)EffectType.BOLD_DOTTED_LINE)) {
                EffectPainter.BOLD_DOTTED_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font);
            }
        }
    }

    @NotNull
    protected final MyFontMetrics getFontMetrics(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Font font = UIManager.getFont("Label.font");
        Intrinsics.checkExpressionValueIsNotNull((Object)font, (String)"UIManager.getFont(\"Label.font\")");
        String familyName = font.getFamily();
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"editor.colorsScheme");
        int size = Math.max(1, editorColorsScheme.getEditorFontSize() - 1);
        MyFontMetrics metrics = (MyFontMetrics)editor.getUserData(HintRenderer.Companion.getHINT_FONT_METRICS());
        if (metrics != null) {
            String string = familyName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"familyName");
            if (!metrics.isActual(editor, string, size)) {
                metrics = null;
            }
        }
        if (metrics == null) {
            String string = familyName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"familyName");
            metrics = new MyFontMetrics(editor, string, size);
            editor.putUserData(HintRenderer.Companion.getHINT_FONT_METRICS(), (Object)metrics);
        }
        return metrics;
    }

    private final Font getFont(Editor editor) {
        return this.getFontMetrics(editor).getFont();
    }

    protected final int doCalcWidth(@Nullable String text, @NotNull FontMetrics fontMetrics) {
        Intrinsics.checkParameterIsNotNull((Object)fontMetrics, (String)"fontMetrics");
        return text == null ? 0 : fontMetrics.stringWidth(text) + 14;
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final void setText(@Nullable String string) {
        this.text = string;
    }

    public HintRenderer(@Nullable String text) {
        this.text = text;
    }

    static {
        Companion = new Companion(null);
        HINT_FONT_METRICS = Key.create((String)"ParameterHintFontMetrics");
        BACKGROUND_ALPHA = 0.55f;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInsight/daemon/impl/HintRenderer$MyFontMetrics;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "familyName", "", "size", "", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;I)V", "font", "Ljava/awt/Font;", "getFont", "()Ljava/awt/Font;", "lineHeight", "getLineHeight", "()I", "metrics", "Ljava/awt/FontMetrics;", "getMetrics", "()Ljava/awt/FontMetrics;", "getCurrentContext", "Ljava/awt/font/FontRenderContext;", "isActual", "", "intellij.platform.lang.impl"})
    protected static final class MyFontMetrics {
        @NotNull
        private final FontMetrics metrics;
        private final int lineHeight;

        @NotNull
        public final FontMetrics getMetrics() {
            return this.metrics;
        }

        public final int getLineHeight() {
            return this.lineHeight;
        }

        @NotNull
        public final Font getFont() {
            Font font = this.metrics.getFont();
            Intrinsics.checkExpressionValueIsNotNull((Object)font, (String)"metrics.font");
            return font;
        }

        public final boolean isActual(@NotNull Editor editor, @NotNull String familyName, int size) {
            Font font;
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)familyName, (String)"familyName");
            Font font2 = font = this.metrics.getFont();
            Intrinsics.checkExpressionValueIsNotNull((Object)font2, (String)"font");
            if (Intrinsics.areEqual((Object)familyName, (Object)font2.getFamily()) ^ true || size != font.getSize()) {
                return false;
            }
            FontRenderContext currentContext = this.getCurrentContext(editor);
            return currentContext.equals(this.metrics.getFontRenderContext());
        }

        private final FontRenderContext getCurrentContext(Editor editor) {
            FontRenderContext editorContext;
            FontRenderContext fontRenderContext = editorContext = FontInfo.getFontRenderContext(editor.getContentComponent());
            Intrinsics.checkExpressionValueIsNotNull((Object)fontRenderContext, (String)"editorContext");
            return new FontRenderContext(fontRenderContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)false), editor instanceof EditorImpl ? ((EditorImpl)editor).myFractionalMetricsHintValue : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }

        public MyFontMetrics(@NotNull Editor editor, @NotNull String familyName, int size) {
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)familyName, (String)"familyName");
            Font font = new Font(familyName, 0, size);
            FontRenderContext context = this.getCurrentContext(editor);
            FontMetrics fontMetrics = FontInfo.getFontMetrics(font, context);
            Intrinsics.checkExpressionValueIsNotNull((Object)fontMetrics, (String)"FontInfo.getFontMetrics(font, context)");
            this.metrics = fontMetrics;
            GlyphVector glyphVector = font.createGlyphVector(context, "Ap");
            Intrinsics.checkExpressionValueIsNotNull((Object)glyphVector, (String)"font.createGlyphVector(context, \"Ap\")");
            Rectangle2D rectangle2D = glyphVector.getVisualBounds();
            Intrinsics.checkExpressionValueIsNotNull((Object)rectangle2D, (String)"font.createGlyphVector(context, \"Ap\").visualBounds");
            this.lineHeight = (int)Math.ceil(rectangle2D.getHeight());
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\"\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInsight/daemon/impl/HintRenderer$Companion;", "", "()V", "BACKGROUND_ALPHA", "", "getBACKGROUND_ALPHA", "()F", "HINT_FONT_METRICS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer$MyFontMetrics;", "kotlin.jvm.PlatformType", "getHINT_FONT_METRICS", "()Lcom/intellij/openapi/util/Key;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private final Key<MyFontMetrics> getHINT_FONT_METRICS() {
            return HINT_FONT_METRICS;
        }

        private final float getBACKGROUND_ALPHA() {
            return BACKGROUND_ALPHA;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

