/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateStorage;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixChangedBuiltinTemplate;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PostfixTemplatesUtils {
    private PostfixTemplatesUtils() {
    }

    @NotNull
    public static Set<PostfixTemplate> getAvailableTemplates(@NotNull PostfixTemplateProvider provider) {
        if (provider == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(0);
        }
        HashSet result2 = ContainerUtil.newHashSet(provider.getTemplates());
        for (PostfixTemplate template : PostfixTemplateStorage.getInstance().getTemplates(provider)) {
            if (template instanceof PostfixChangedBuiltinTemplate) {
                result2.remove(((PostfixChangedBuiltinTemplate)template).getBuiltinTemplate());
            }
            result2.add(template);
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @Nullable
    public static TextRange surround(@NotNull Surrounder surrounder, @NotNull Editor editor, @NotNull PsiElement expr) {
        if (surrounder == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(3);
        }
        if (expr == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(4);
        }
        Project project = expr.getProject();
        PsiElement[] elements = new PsiElement[]{expr};
        if (surrounder.isApplicable(elements)) {
            return surrounder.surroundElements(project, editor, elements);
        }
        PostfixTemplatesUtils.showErrorHint(project, editor);
        return null;
    }

    public static void showErrorHint(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(6);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Can't expand postfix template", (String)"Can't expand postfix template", (String)"");
    }

    @NotNull
    public static String generateTemplateId(@NotNull String templateKey, @NotNull PostfixTemplateProvider provider) {
        if (templateKey == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(7);
        }
        if (provider == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(8);
        }
        HashSet<String> usedIds = new HashSet<String>();
        for (PostfixTemplate builtinTemplate : provider.getTemplates()) {
            usedIds.add(builtinTemplate.getId());
        }
        for (PostfixTemplate template : PostfixTemplateStorage.getInstance().getTemplates(provider)) {
            usedIds.add(template.getId());
        }
        String string = UniqueNameGenerator.generateUniqueName((String)(templateKey + "@userDefined"), usedIds);
        if (string == null) {
            PostfixTemplatesUtils.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/templates/PostfixTemplatesUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surrounder";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/templates/PostfixTemplatesUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableTemplates";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateTemplateId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableTemplates";
                break;
            }
            case 1: 
            case 9: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "surround";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showErrorHint";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateTemplateId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

