/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByChar;
import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.DiffFragmentImpl;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeLineFragmentImpl;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.fragments.MergeWordFragmentImpl;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.IntPair;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparisonManagerImpl
extends ComparisonManager {
    private static final Logger LOG = Logger.getInstance(ComparisonManagerImpl.class);

    @NotNull
    public static ComparisonManagerImpl getInstanceImpl() {
        ComparisonManagerImpl comparisonManagerImpl = (ComparisonManagerImpl)ComparisonManagerImpl.getInstance();
        if (comparisonManagerImpl == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(0);
        }
        return comparisonManagerImpl;
    }

    @NotNull
    public List<LineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(1);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(2);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(4);
        }
        List<Line> lines1 = ComparisonManagerImpl.getLines(text1);
        List<Line> lines2 = ComparisonManagerImpl.getLines(text2);
        List lineTexts1 = ContainerUtil.map(lines1, Line::getContent);
        List lineTexts2 = ContainerUtil.map(lines2, Line::getContent);
        FairDiffIterable iterable = ByLine.compare(lineTexts1, lineTexts2, policy, indicator);
        List<LineFragment> list2 = ComparisonManagerImpl.convertIntoLineFragments(lines1, lines2, iterable);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public List<MergeLineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(6);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(7);
        }
        if (text3 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(8);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(10);
        }
        List<Line> lines1 = ComparisonManagerImpl.getLines(text1);
        List<Line> lines2 = ComparisonManagerImpl.getLines(text2);
        List<Line> lines3 = ComparisonManagerImpl.getLines(text3);
        List lineTexts1 = ContainerUtil.map(lines1, Line::getContent);
        List lineTexts2 = ContainerUtil.map(lines2, Line::getContent);
        List lineTexts3 = ContainerUtil.map(lines3, Line::getContent);
        List<MergeRange> ranges = ByLine.compare(lineTexts1, lineTexts2, lineTexts3, policy, indicator);
        List<MergeLineFragment> list2 = ComparisonManagerImpl.convertIntoMergeLineFragments(ranges);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(12);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(13);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(14);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(15);
        }
        List<LineFragment> lineFragments = this.compareLines(text1, text2, policy, indicator);
        List<LineFragment> list2 = ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, policy, indicator);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(16);
        }
        return list2;
    }

    private static List<LineFragment> createInnerFragments(@NotNull List<LineFragment> lineFragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (lineFragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(17);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(18);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(19);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(20);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(21);
        }
        ArrayList<LineFragment> result2 = new ArrayList<LineFragment>(lineFragments.size());
        int tooBigChunksCount = 0;
        for (LineFragment fragment : lineFragments) {
            assert (fragment.getInnerFragments() == null);
            try {
                boolean tryComputeDifferences = tooBigChunksCount < 3;
                result2.addAll(ComparisonManagerImpl.createInnerFragments(fragment, text1, text2, policy, indicator, tryComputeDifferences));
            }
            catch (DiffTooBigException e) {
                result2.add(fragment);
                ++tooBigChunksCount;
            }
        }
        return result2;
    }

    @NotNull
    private static List<LineFragment> createInnerFragments(@NotNull LineFragment fragment, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator, boolean tryComputeDifferences) throws DiffTooBigException {
        if (fragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(22);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(23);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(24);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(25);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(26);
        }
        CharSequence subSequence1 = text1.subSequence(fragment.getStartOffset1(), fragment.getEndOffset1());
        CharSequence subSequence2 = text2.subSequence(fragment.getStartOffset2(), fragment.getEndOffset2());
        if (fragment.getStartLine1() == fragment.getEndLine1() || fragment.getStartLine2() == fragment.getEndLine2()) {
            if (ComparisonUtil.isEquals(subSequence1, subSequence2, policy)) {
                List<LineFragmentImpl> list2 = Collections.singletonList(new LineFragmentImpl(fragment, Collections.emptyList()));
                if (list2 == null) {
                    ComparisonManagerImpl.$$$reportNull$$$0(27);
                }
                return list2;
            }
            List<LineFragment> list3 = Collections.singletonList(fragment);
            if (list3 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(28);
            }
            return list3;
        }
        if (!tryComputeDifferences) {
            List<LineFragment> list4 = Collections.singletonList(fragment);
            if (list4 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(29);
            }
            return list4;
        }
        List<ByWord.LineBlock> lineBlocks2 = ByWord.compareAndSplit(subSequence1, subSequence2, policy, indicator);
        assert (lineBlocks2.size() != 0);
        int startOffset1 = fragment.getStartOffset1();
        int startOffset2 = fragment.getStartOffset2();
        int currentStartLine1 = fragment.getStartLine1();
        int currentStartLine2 = fragment.getStartLine2();
        ArrayList<LineFragment> chunks = new ArrayList<LineFragment>();
        for (int i = 0; i < lineBlocks2.size(); ++i) {
            ByWord.LineBlock block = lineBlocks2.get(i);
            Range offsets = block.offsets;
            int currentEndLine1 = i != lineBlocks2.size() - 1 ? currentStartLine1 + block.newlines1 : fragment.getEndLine1();
            int currentEndLine2 = i != lineBlocks2.size() - 1 ? currentStartLine2 + block.newlines2 : fragment.getEndLine2();
            chunks.add((LineFragment)new LineFragmentImpl(currentStartLine1, currentEndLine1, currentStartLine2, currentEndLine2, offsets.start1 + startOffset1, offsets.end1 + startOffset1, offsets.start2 + startOffset2, offsets.end2 + startOffset2, block.fragments));
            currentStartLine1 = currentEndLine1;
            currentStartLine2 = currentEndLine2;
        }
        ArrayList<LineFragment> arrayList = chunks;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(30);
        }
        return arrayList;
    }

    @Deprecated
    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<LineFragment> lineFragments, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(31);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(32);
        }
        if (lineFragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(33);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(34);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(35);
        }
        List<LineFragment> list2 = this.compareLinesInner(text1, text2, policy, indicator);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(36);
        }
        return list2;
    }

    @NotNull
    public List<DiffFragment> compareWords(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(37);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(38);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(39);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(40);
        }
        List<DiffFragment> list2 = ByWord.compare(text1, text2, policy, indicator);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(41);
        }
        return list2;
    }

    @NotNull
    public List<DiffFragment> compareChars(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(42);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(43);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(44);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(45);
        }
        if (policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            List<DiffFragment> list2 = ComparisonManagerImpl.convertIntoDiffFragments(ByChar.compareIgnoreWhitespaces(text1, text2, indicator));
            if (list2 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(46);
            }
            return list2;
        }
        if (policy == ComparisonPolicy.DEFAULT) {
            List<DiffFragment> list3 = ComparisonManagerImpl.convertIntoDiffFragments(ByChar.compareTwoStep(text1, text2, indicator));
            if (list3 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(47);
            }
            return list3;
        }
        LOG.warn(policy.toString() + " is not supported by ByChar comparison");
        List<DiffFragment> list4 = ComparisonManagerImpl.convertIntoDiffFragments(ByChar.compareTwoStep(text1, text2, indicator));
        if (list4 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(48);
        }
        return list4;
    }

    public boolean isEquals(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(49);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(50);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(51);
        }
        return ComparisonUtil.isEquals(text1, text2, policy);
    }

    @NotNull
    public static List<DiffFragment> convertIntoDiffFragments(@NotNull DiffIterable changes) {
        if (changes == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(52);
        }
        ArrayList<DiffFragment> fragments = new ArrayList<DiffFragment>();
        for (Range ch : changes.iterateChanges()) {
            fragments.add((DiffFragment)new DiffFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2));
        }
        ArrayList<DiffFragment> arrayList = fragments;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(53);
        }
        return arrayList;
    }

    @NotNull
    public static List<LineFragment> convertIntoLineFragments(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull FairDiffIterable changes) {
        if (lines1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(54);
        }
        if (lines2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(55);
        }
        if (changes == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(56);
        }
        ArrayList<LineFragment> fragments = new ArrayList<LineFragment>();
        for (Range ch : changes.iterateChanges()) {
            IntPair offsets1 = ComparisonManagerImpl.getOffsets(lines1, ch.start1, ch.end1);
            IntPair offsets2 = ComparisonManagerImpl.getOffsets(lines2, ch.start2, ch.end2);
            fragments.add((LineFragment)new LineFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2, offsets1.val1, offsets1.val2, offsets2.val1, offsets2.val2));
        }
        ArrayList<LineFragment> arrayList = fragments;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(57);
        }
        return arrayList;
    }

    @NotNull
    private static IntPair getOffsets(@NotNull List<Line> lines2, int startIndex, int endIndex) {
        if (lines2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(58);
        }
        if (startIndex == endIndex) {
            int offset = startIndex < lines2.size() ? lines2.get(startIndex).getOffset1() : lines2.get(lines2.size() - 1).getOffset2();
            IntPair intPair = new IntPair(offset, offset);
            if (intPair == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(59);
            }
            return intPair;
        }
        int offset1 = lines2.get(startIndex).getOffset1();
        int offset2 = lines2.get(endIndex - 1).getOffset2();
        IntPair intPair = new IntPair(offset1, offset2);
        if (intPair == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(60);
        }
        return intPair;
    }

    @NotNull
    public static List<MergeLineFragment> convertIntoMergeLineFragments(@NotNull List<MergeRange> conflicts) {
        if (conflicts == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(61);
        }
        List list2 = ContainerUtil.map(conflicts, ch -> new MergeLineFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2, ch.start3, ch.end3));
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(62);
        }
        return list2;
    }

    @NotNull
    public static List<MergeWordFragment> convertIntoMergeWordFragments(@NotNull List<MergeRange> conflicts) {
        if (conflicts == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(63);
        }
        List list2 = ContainerUtil.map(conflicts, ch -> new MergeWordFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2, ch.start3, ch.end3));
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(64);
        }
        return list2;
    }

    @NotNull
    public List<LineFragment> squash(@NotNull List<LineFragment> oldFragments) {
        if (oldFragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(65);
        }
        if (oldFragments.isEmpty()) {
            List<LineFragment> list2 = oldFragments;
            if (list2 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(66);
            }
            return list2;
        }
        ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, (Consumer<List<LineFragment>>)((Consumer)fragments -> newFragments.add(ComparisonManagerImpl.doSquash(fragments))));
        ArrayList<LineFragment> arrayList = newFragments;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(67);
        }
        return arrayList;
    }

    @NotNull
    public List<LineFragment> processBlocks(@NotNull List<LineFragment> oldFragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean squash, boolean trim) {
        if (oldFragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(68);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(69);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(70);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(71);
        }
        if (!squash && !trim) {
            List<LineFragment> list2 = oldFragments;
            if (list2 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(72);
            }
            return list2;
        }
        if (oldFragments.isEmpty()) {
            List<LineFragment> list3 = oldFragments;
            if (list3 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(73);
            }
            return list3;
        }
        ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, (Consumer<List<LineFragment>>)((Consumer)fragments -> {
            if (text1 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(137);
            }
            if (text2 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(138);
            }
            if (policy == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(139);
            }
            newFragments.addAll(ComparisonManagerImpl.processAdjoining(fragments, text1, text2, policy, squash, trim));
        }));
        ArrayList<LineFragment> arrayList = newFragments;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(74);
        }
        return arrayList;
    }

    private static void processAdjoining(@NotNull List<LineFragment> oldFragments, @NotNull Consumer<List<LineFragment>> consumer) {
        if (oldFragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(75);
        }
        if (consumer == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(76);
        }
        int startIndex = 0;
        for (int i = 1; i < oldFragments.size(); ++i) {
            if (ComparisonManagerImpl.isAdjoining(oldFragments.get(i - 1), oldFragments.get(i))) continue;
            consumer.consume(oldFragments.subList(startIndex, i));
            startIndex = i;
        }
        if (startIndex < oldFragments.size()) {
            consumer.consume(oldFragments.subList(startIndex, oldFragments.size()));
        }
    }

    @NotNull
    private static List<LineFragment> processAdjoining(@NotNull List<LineFragment> fragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean squash, boolean trim) {
        int start;
        if (fragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(77);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(78);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(79);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(80);
        }
        int end = fragments.size();
        if (trim && policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            CharSequenceSubSequence sequence2;
            CharSequenceSubSequence sequence1;
            LineFragment fragment;
            for (start = 0; start < end; ++start) {
                fragment = fragments.get(start);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2)) break;
            }
            while (start < end) {
                fragment = fragments.get(end - 1);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2)) break;
                --end;
            }
        }
        if (start == end) {
            List<LineFragment> list2 = Collections.emptyList();
            if (list2 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(81);
            }
            return list2;
        }
        if (squash) {
            List<LineFragment> list3 = Collections.singletonList(ComparisonManagerImpl.doSquash(fragments.subList(start, end)));
            if (list3 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(82);
            }
            return list3;
        }
        List<LineFragment> list4 = fragments.subList(start, end);
        if (list4 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(83);
        }
        return list4;
    }

    @NotNull
    private static LineFragment doSquash(@NotNull List<LineFragment> oldFragments) {
        if (oldFragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(84);
        }
        assert (!oldFragments.isEmpty());
        if (oldFragments.size() == 1) {
            LineFragment lineFragment = oldFragments.get(0);
            if (lineFragment == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(85);
            }
            return lineFragment;
        }
        LineFragment firstFragment = oldFragments.get(0);
        LineFragment lastFragment = oldFragments.get(oldFragments.size() - 1);
        ArrayList<DiffFragmentImpl> newInnerFragments = new ArrayList<DiffFragmentImpl>();
        for (LineFragment fragment : oldFragments) {
            for (DiffFragment innerFragment : ComparisonManagerImpl.extractInnerFragments(fragment)) {
                int shift1 = fragment.getStartOffset1() - firstFragment.getStartOffset1();
                int shift2 = fragment.getStartOffset2() - firstFragment.getStartOffset2();
                DiffFragment previousFragment = (DiffFragment)ContainerUtil.getLastItem(newInnerFragments);
                if (previousFragment == null || !ComparisonManagerImpl.isAdjoiningInner(previousFragment, innerFragment, shift1, shift2)) {
                    newInnerFragments.add(new DiffFragmentImpl(innerFragment.getStartOffset1() + shift1, innerFragment.getEndOffset1() + shift1, innerFragment.getStartOffset2() + shift2, innerFragment.getEndOffset2() + shift2));
                    continue;
                }
                newInnerFragments.remove(newInnerFragments.size() - 1);
                newInnerFragments.add(new DiffFragmentImpl(previousFragment.getStartOffset1(), innerFragment.getEndOffset1() + shift1, previousFragment.getStartOffset2(), innerFragment.getEndOffset2() + shift2));
            }
        }
        LineFragmentImpl lineFragmentImpl = new LineFragmentImpl(firstFragment.getStartLine1(), lastFragment.getEndLine1(), firstFragment.getStartLine2(), lastFragment.getEndLine2(), firstFragment.getStartOffset1(), lastFragment.getEndOffset1(), firstFragment.getStartOffset2(), lastFragment.getEndOffset2(), newInnerFragments);
        if (lineFragmentImpl == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(86);
        }
        return lineFragmentImpl;
    }

    private static boolean isAdjoining(@NotNull LineFragment beforeFragment, @NotNull LineFragment afterFragment) {
        if (beforeFragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(87);
        }
        if (afterFragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(88);
        }
        return beforeFragment.getEndLine1() == afterFragment.getStartLine1() && beforeFragment.getEndLine2() == afterFragment.getStartLine2() && beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2();
    }

    private static boolean isAdjoiningInner(@NotNull DiffFragment beforeFragment, @NotNull DiffFragment afterFragment, int shift1, int shift2) {
        if (beforeFragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(89);
        }
        if (afterFragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(90);
        }
        return beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() + shift1 && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2() + shift2;
    }

    @NotNull
    private static List<DiffFragment> extractInnerFragments(@NotNull LineFragment lineFragment) {
        if (lineFragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(91);
        }
        if (lineFragment.getInnerFragments() != null) {
            List list2 = lineFragment.getInnerFragments();
            if (list2 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(92);
            }
            return list2;
        }
        int length1 = lineFragment.getEndOffset1() - lineFragment.getStartOffset1();
        int length2 = lineFragment.getEndOffset2() - lineFragment.getStartOffset2();
        List<DiffFragmentImpl> list3 = Collections.singletonList(new DiffFragmentImpl(0, length1, 0, length2));
        if (list3 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(93);
        }
        return list3;
    }

    @NotNull
    private static List<Line> getLines(@NotNull CharSequence text) {
        int lineEnd;
        if (text == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(94);
        }
        ArrayList<Line> lines2 = new ArrayList<Line>();
        int offset = 0;
        while ((lineEnd = StringUtil.indexOf((CharSequence)text, (char)'\n', (int)offset)) != -1) {
            lines2.add(new Line(text, offset, lineEnd, true));
            offset = lineEnd + 1;
        }
        lines2.add(new Line(text, offset, text.length(), false));
        ArrayList<Line> arrayList = lines2;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(95);
        }
        return arrayList;
    }

    @NotNull
    public List<LineFragment> compareLinesWithIgnoredRanges(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<TextRange> ignoredRanges1, @NotNull List<TextRange> ignoredRanges2, boolean innerFragments, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(96);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(97);
        }
        if (ignoredRanges1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(98);
        }
        if (ignoredRanges2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(99);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(100);
        }
        BitSet ignored1 = ComparisonManagerImpl.collectIgnoredRanges(ignoredRanges1);
        BitSet ignored2 = ComparisonManagerImpl.collectIgnoredRanges(ignoredRanges2);
        List<Line> lines1 = ComparisonManagerImpl.getLines(text1);
        List<Line> lines2 = ComparisonManagerImpl.getLines(text2);
        List lineTexts1 = ContainerUtil.map(lines1, line -> line.getNotIgnoredContent(ignored1));
        List lineTexts2 = ContainerUtil.map(lines2, line -> line.getNotIgnoredContent(ignored2));
        FairDiffIterable iterable = ByLine.compare(lineTexts1, lineTexts2, ComparisonPolicy.DEFAULT, indicator);
        FairDiffIterable correctedIterable = ComparisonManagerImpl.correctIgnoredRangesSecondStep(iterable, lines1, lines2, ignored1, ignored2);
        List<LineFragment> lineFragments = ComparisonManagerImpl.convertIntoLineFragments(lines1, lines2, correctedIterable);
        if (innerFragments) {
            lineFragments = ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, ComparisonPolicy.DEFAULT, indicator);
        }
        List list2 = ContainerUtil.mapNotNull(lineFragments, fragment -> ComparisonManagerImpl.trimIgnoredChanges(fragment, lines1, lines2, ignored1, ignored2));
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(101);
        }
        return list2;
    }

    @NotNull
    public static BitSet collectIgnoredRanges(@NotNull List<TextRange> ignoredRanges) {
        if (ignoredRanges == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(102);
        }
        BitSet set2 = new BitSet();
        for (TextRange range2 : ignoredRanges) {
            set2.set(range2.getStartOffset(), range2.getEndOffset());
        }
        BitSet bitSet = set2;
        if (bitSet == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(103);
        }
        return bitSet;
    }

    @NotNull
    private static FairDiffIterable correctIgnoredRangesSecondStep(@NotNull FairDiffIterable iterable, @NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        if (iterable == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(104);
        }
        if (lines1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(105);
        }
        if (lines2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(106);
        }
        if (ignored1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(107);
        }
        if (ignored2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(108);
        }
        DiffIterableUtil.ChangeBuilder builder = new DiffIterableUtil.ChangeBuilder(lines1.size(), lines2.size());
        for (Range range2 : iterable.iterateUnchanged()) {
            int count = range2.end1 - range2.start1;
            for (int i = 0; i < count; ++i) {
                int index1 = range2.start1 + i;
                int index2 = range2.start2 + i;
                if (!ComparisonManagerImpl.areIgnoredEqualLines(lines1.get(index1), lines2.get(index2), ignored1, ignored2)) continue;
                builder.markEqual(index1, index2);
            }
        }
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(builder.finish());
        if (fairDiffIterable == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(109);
        }
        return fairDiffIterable;
    }

    @Nullable
    private static LineFragment trimIgnoredChanges(@NotNull LineFragment fragment, @NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        if (fragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(110);
        }
        if (lines1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(111);
        }
        if (lines2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(112);
        }
        if (ignored1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(113);
        }
        if (ignored2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(114);
        }
        Range range2 = TrimUtil.trimExpandList(lines1, lines2, fragment.getStartLine1(), fragment.getStartLine2(), fragment.getEndLine1(), fragment.getEndLine2(), (line1, line2) -> {
            if (ignored1 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(135);
            }
            if (ignored2 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(136);
            }
            return ComparisonManagerImpl.areIgnoredEqualLines(line1, line2, ignored1, ignored2);
        }, line -> {
            if (ignored1 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(134);
            }
            return ComparisonManagerImpl.isIgnoredLine(line, ignored1);
        }, line -> {
            if (ignored2 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(133);
            }
            return ComparisonManagerImpl.isIgnoredLine(line, ignored2);
        });
        int startLine1 = range2.start1;
        int startLine2 = range2.start2;
        int endLine1 = range2.end1;
        int endLine2 = range2.end2;
        if (startLine1 == endLine1 && startLine2 == endLine2) {
            return null;
        }
        IntPair offsets1 = ComparisonManagerImpl.getOffsets(lines1, startLine1, endLine1);
        IntPair offsets2 = ComparisonManagerImpl.getOffsets(lines2, startLine2, endLine2);
        int startOffset1 = offsets1.val1;
        int endOffset1 = offsets1.val2;
        int startOffset2 = offsets2.val1;
        int endOffset2 = offsets2.val2;
        List newInner = null;
        if (fragment.getInnerFragments() != null) {
            int shift1 = startOffset1 - fragment.getStartOffset1();
            int shift2 = startOffset2 - fragment.getStartOffset2();
            int newCount1 = endOffset1 - startOffset1;
            int newCount2 = endOffset2 - startOffset2;
            newInner = ContainerUtil.mapNotNull((Collection)fragment.getInnerFragments(), it -> {
                if (ignored1 == null) {
                    ComparisonManagerImpl.$$$reportNull$$$0(131);
                }
                if (ignored2 == null) {
                    ComparisonManagerImpl.$$$reportNull$$$0(132);
                }
                int start1 = DiffUtil.bound(it.getStartOffset1() - shift1, 0, newCount1);
                int start2 = DiffUtil.bound(it.getStartOffset2() - shift2, 0, newCount2);
                int end1 = DiffUtil.bound(it.getEndOffset1() - shift1, 0, newCount1);
                int end2 = DiffUtil.bound(it.getEndOffset2() - shift2, 0, newCount2);
                TextRange range1 = ComparisonManagerImpl.trimIgnoredRange(start1, end1, ignored1, startOffset1);
                TextRange range2 = ComparisonManagerImpl.trimIgnoredRange(start2, end2, ignored2, startOffset2);
                if (range1.isEmpty() && range2.isEmpty()) {
                    return null;
                }
                return new DiffFragmentImpl(range1.getStartOffset(), range1.getEndOffset(), range2.getStartOffset(), range2.getEndOffset());
            });
            if (newInner.isEmpty()) {
                return null;
            }
        }
        return new LineFragmentImpl(startLine1, endLine1, startLine2, endLine2, startOffset1, endOffset1, startOffset2, endOffset2, newInner);
    }

    private static boolean isIgnoredLine(@NotNull Line line, @NotNull BitSet ignored) {
        if (line == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(115);
        }
        if (ignored == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(116);
        }
        return ComparisonManagerImpl.isIgnoredRange(ignored, line.getOffset1(), line.getOffset2());
    }

    private static boolean areIgnoredEqualLines(@NotNull Line line1, @NotNull Line line2, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        if (line1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(117);
        }
        if (line2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(118);
        }
        if (ignored1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(119);
        }
        if (ignored2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(120);
        }
        int start1 = line1.getOffset1();
        int end1 = line1.getOffset2();
        int start2 = line2.getOffset1();
        int end2 = line2.getOffset2();
        Range range2 = TrimUtil.trimExpandText(line1.getOriginalText(), line2.getOriginalText(), start1, start2, end1, end2, ignored1, ignored2);
        if (!range2.isEmpty()) {
            return false;
        }
        List<ByWord.InlineChunk> words1 = ComparisonManagerImpl.getNonIgnoredWords(line1, ignored1);
        List<ByWord.InlineChunk> words2 = ComparisonManagerImpl.getNonIgnoredWords(line2, ignored2);
        if (words1.size() != words2.size()) {
            return false;
        }
        for (int i = 0; i < words1.size(); ++i) {
            CharSequence word2;
            CharSequence word1 = ComparisonManagerImpl.getWordContent(line1, words1.get(i));
            if (StringUtil.equals((CharSequence)word1, (CharSequence)(word2 = ComparisonManagerImpl.getWordContent(line2, words2.get(i))))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<ByWord.InlineChunk> getNonIgnoredWords(@NotNull Line line, @NotNull BitSet ignored) {
        if (line == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(121);
        }
        if (ignored == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(122);
        }
        int offset = line.getOffset1();
        List<ByWord.InlineChunk> innerChunks = ByWord.getInlineChunks(line.getContent());
        List list2 = ContainerUtil.filter(innerChunks, it -> {
            if (ignored == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(130);
            }
            return it instanceof ByWord.WordChunk && !ComparisonManagerImpl.isIgnoredRange(ignored, offset + it.getOffset1(), offset + it.getOffset2());
        });
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(123);
        }
        return list2;
    }

    @NotNull
    private static CharSequence getWordContent(@NotNull Line line, @NotNull ByWord.InlineChunk word) {
        if (line == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(124);
        }
        if (word == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(125);
        }
        CharSequence charSequence = line.getContent().subSequence(word.getOffset1(), word.getOffset2());
        if (charSequence == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(126);
        }
        return charSequence;
    }

    @NotNull
    private static TextRange trimIgnoredRange(int start, int end, @NotNull BitSet ignored, int offset) {
        if (ignored == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(127);
        }
        IntPair intPair = TrimUtil.trim(offset + start, offset + end, ignored);
        TextRange textRange = new TextRange(intPair.val1 - offset, intPair.val2 - offset);
        if (textRange == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(128);
        }
        return textRange;
    }

    private static boolean isIgnoredRange(@NotNull BitSet ignored, int start, int end) {
        if (ignored == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(129);
        }
        return ignored.nextClearBit(start) >= end;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 61: 
            case 63: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 61: 
            case 63: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/comparison/ComparisonManagerImpl";
                break;
            }
            case 1: 
            case 6: 
            case 12: 
            case 18: 
            case 23: 
            case 31: 
            case 37: 
            case 42: 
            case 49: 
            case 69: 
            case 78: 
            case 96: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 19: 
            case 24: 
            case 32: 
            case 38: 
            case 43: 
            case 50: 
            case 70: 
            case 79: 
            case 97: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 3: 
            case 9: 
            case 14: 
            case 20: 
            case 25: 
            case 34: 
            case 39: 
            case 44: 
            case 51: 
            case 71: 
            case 80: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 4: 
            case 10: 
            case 15: 
            case 21: 
            case 26: 
            case 35: 
            case 40: 
            case 45: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text3";
                break;
            }
            case 17: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineFragments";
                break;
            }
            case 22: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 52: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 54: 
            case 105: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines1";
                break;
            }
            case 55: 
            case 106: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines2";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 61: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 65: 
            case 68: 
            case 75: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFragments";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 87: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeFragment";
                break;
            }
            case 88: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterFragment";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineFragment";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredRanges1";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredRanges2";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredRanges";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 107: 
            case 113: 
            case 119: 
            case 131: 
            case 134: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored1";
                break;
            }
            case 108: 
            case 114: 
            case 120: 
            case 132: 
            case 133: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored2";
                break;
            }
            case 115: 
            case 121: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 116: 
            case 122: 
            case 127: 
            case 129: 
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line1";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line2";
                break;
            }
            case 125: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 61: 
            case 63: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/comparison/ComparisonManagerImpl";
                break;
            }
            case 5: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "compareLines";
                break;
            }
            case 16: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "compareLinesInner";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createInnerFragments";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "compareWords";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "compareChars";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "convertIntoDiffFragments";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "convertIntoLineFragments";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getOffsets";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "convertIntoMergeLineFragments";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "convertIntoMergeWordFragments";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "squash";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "processBlocks";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "processAdjoining";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "doSquash";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "extractInnerFragments";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getLines";
                break;
            }
            case 101: {
                objectArray = objectArray2;
                objectArray2[1] = "compareLinesWithIgnoredRanges";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "collectIgnoredRanges";
                break;
            }
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "correctIgnoredRangesSecondStep";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonIgnoredWords";
                break;
            }
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordContent";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "trimIgnoredRange";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "compareLines";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "compareLinesInner";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createInnerFragments";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "compareWords";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "compareChars";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isEquals";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "convertIntoDiffFragments";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "convertIntoLineFragments";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getOffsets";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "convertIntoMergeLineFragments";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "convertIntoMergeWordFragments";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "squash";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "processBlocks";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "processAdjoining";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "doSquash";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "isAdjoining";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "isAdjoiningInner";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "extractInnerFragments";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "getLines";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "compareLinesWithIgnoredRanges";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "collectIgnoredRanges";
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "correctIgnoredRangesSecondStep";
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "trimIgnoredChanges";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredLine";
                break;
            }
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "areIgnoredEqualLines";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getNonIgnoredWords";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "getWordContent";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "trimIgnoredRange";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredRange";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getNonIgnoredWords$11";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "lambda$trimIgnoredChanges$10";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "lambda$trimIgnoredChanges$9";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "lambda$trimIgnoredChanges$8";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "lambda$trimIgnoredChanges$7";
                break;
            }
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processBlocks$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 61: 
            case 63: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 84: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 94: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Line {
        @NotNull
        private final CharSequence myChars;
        private final int myOffset1;
        private final int myOffset2;
        private final boolean myNewline;

        public Line(@NotNull CharSequence chars, int offset1, int offset2, boolean newline) {
            if (chars == null) {
                Line.$$$reportNull$$$0(0);
            }
            this.myChars = chars;
            this.myOffset1 = offset1;
            this.myOffset2 = offset2;
            this.myNewline = newline;
        }

        public int getOffset1() {
            return this.myOffset1;
        }

        public int getOffset2() {
            return this.myOffset2 + (this.myNewline ? 1 : 0);
        }

        @NotNull
        public CharSequence getContent() {
            CharSequenceSubSequence charSequenceSubSequence = new CharSequenceSubSequence(this.myChars, this.myOffset1, this.myOffset2);
            if (charSequenceSubSequence == null) {
                Line.$$$reportNull$$$0(1);
            }
            return charSequenceSubSequence;
        }

        @NotNull
        public CharSequence getNotIgnoredContent(@NotNull BitSet ignored) {
            if (ignored == null) {
                Line.$$$reportNull$$$0(2);
            }
            StringBuilder sb = new StringBuilder();
            for (int i = this.myOffset1; i < this.myOffset2; ++i) {
                if (ignored.get(i)) continue;
                sb.append(this.myChars.charAt(i));
            }
            String string = sb.toString();
            if (string == null) {
                Line.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public CharSequence getOriginalText() {
            CharSequence charSequence = this.myChars;
            if (charSequence == null) {
                Line.$$$reportNull$$$0(4);
            }
            return charSequence;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chars";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ComparisonManagerImpl$Line";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignored";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ComparisonManagerImpl$Line";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotIgnoredContent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOriginalText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getNotIgnoredContent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

