/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eJ`\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\b\b\u0002\u0010\u001a\u001a\u00020\u00072\b\b\u0002\u0010\u001b\u001a\u00020\u00072\b\b\u0002\u0010\u001c\u001a\u00020\u00072\b\b\u0002\u0010\u001d\u001a\u00020\u0007H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/diff/util/DiffLineMarkerRenderer;", "Lcom/intellij/openapi/editor/markup/LineMarkerRendererEx;", "myHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "myDiffType", "Lcom/intellij/diff/util/TextDiffType;", "myIgnoredFoldingOutline", "", "myResolved", "myExcluded", "myHideWithoutLineNumbers", "myEmptyRange", "myFirstLine", "myLastLine", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/intellij/diff/util/TextDiffType;ZZZZZZZ)V", "drawMarker", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics2D;", "x1", "", "x2", "y1", "y2", "paintBackground", "paintBorder", "dottedLine", "useIgnoredBackgroundColor", "getPosition", "Lcom/intellij/openapi/editor/markup/LineMarkerRendererEx$Position;", "paint", "Ljava/awt/Graphics;", "range", "Ljava/awt/Rectangle;", "intellij.platform.diff.impl"})
public final class DiffLineMarkerRenderer
implements LineMarkerRendererEx {
    private final RangeHighlighter myHighlighter;
    private final TextDiffType myDiffType;
    private final boolean myIgnoredFoldingOutline;
    private final boolean myResolved;
    private final boolean myExcluded;
    private final boolean myHideWithoutLineNumbers;
    private final boolean myEmptyRange;
    private final boolean myFirstLine;
    private final boolean myLastLine;

    /*
     * Unable to fully structure code
     */
    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle range) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        (EditorEx)editor;
        (Graphics2D)g;
        gutter = ((EditorEx)editor).getGutterComponentEx();
        x1 = 0;
        v0 = gutter;
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"gutter");
        x2 = x1 + v0.getWidth();
        if (this.myEmptyRange && this.myLastLine) {
            y2 = y1 = DiffDrawUtil.lineToY(editor, DiffUtil.getLineCount(((EditorEx)editor).getDocument()));
        } else {
            startLine = ((EditorEx)editor).getDocument().getLineNumber(this.myHighlighter.getStartOffset());
            endLine = ((EditorEx)editor).getDocument().getLineNumber(this.myHighlighter.getEndOffset()) + 1;
            y1 = DiffDrawUtil.lineToY(editor, startLine);
            v1 = y2 = this.myEmptyRange != false ? y1 : DiffDrawUtil.lineToY(editor, endLine);
        }
        if (this.myEmptyRange && this.myFirstLine) {
            ++y1;
            ++y2;
        }
        if (!this.myHideWithoutLineNumbers) ** GOTO lbl-1000
        v2 = editor.getSettings();
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"editor.getSettings()");
        if (!v2.isLineNumbersShown()) {
            x1 = gutter.getWhitespaceSeparatorOffset();
        } else lbl-1000:
        // 2 sources

        {
            annotationsOffset = gutter.getAnnotationsAreaOffset();
            annotationsWidth = gutter.getAnnotationsAreaWidth();
            if (annotationsWidth != 0) {
                DiffLineMarkerRenderer.drawMarker$default(this, editor, (Graphics2D)g, x1, annotationsOffset, y1, y2, false, false, false, false, 960, null);
                x1 = annotationsOffset + annotationsWidth;
            }
        }
        if (this.myExcluded) {
            xOutline = gutter.getWhitespaceSeparatorOffset();
            DiffLineMarkerRenderer.drawMarker$default(this, editor, (Graphics2D)g, xOutline, x2, y1, y2, false, true, false, false, 768, null);
            DiffLineMarkerRenderer.drawMarker$default(this, editor, (Graphics2D)g, x1, xOutline, y1, y2, true, true, false, true, 256, null);
        } else if (this.myIgnoredFoldingOutline) {
            xOutline = gutter.getWhitespaceSeparatorOffset();
            DiffLineMarkerRenderer.drawMarker$default(this, editor, (Graphics2D)g, xOutline, x2, y1, y2, false, false, false, true, 448, null);
            DiffLineMarkerRenderer.drawMarker$default(this, editor, (Graphics2D)g, x1, xOutline, y1, y2, false, false, false, false, 960, null);
        } else {
            DiffLineMarkerRenderer.drawMarker$default(this, editor, (Graphics2D)g, x1, x2, y1, y2, false, false, false, false, 960, null);
        }
    }

    private final void drawMarker(Editor editor, Graphics2D g, int x1, int x2, int y1, int y2, boolean paintBackground, boolean paintBorder2, boolean dottedLine, boolean useIgnoredBackgroundColor) {
        if (x1 >= x2) {
            return;
        }
        Color color = this.myDiffType.getColor(editor);
        if (y2 - y1 > 2) {
            if (paintBackground) {
                g.setColor(useIgnoredBackgroundColor ? this.myDiffType.getIgnoredColor(editor) : color);
                g.fillRect(x1, y1, x2 - x1, y2 - y1);
            }
            if (paintBorder2) {
                DiffDrawUtil.drawChunkBorderLine(g, x1, x2, y1, color, false, dottedLine);
                DiffDrawUtil.drawChunkBorderLine(g, x1, x2, y2 - 1, color, false, dottedLine);
            }
        } else {
            DiffDrawUtil.drawChunkBorderLine(g, x1, x2, y1 - 1, color, true, dottedLine);
        }
    }

    static /* bridge */ /* synthetic */ void drawMarker$default(DiffLineMarkerRenderer diffLineMarkerRenderer, Editor editor, Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n5, Object object) {
        if ((n5 & 0x40) != 0) {
            boolean bl5 = bl = !diffLineMarkerRenderer.myResolved;
        }
        if ((n5 & 0x80) != 0) {
            bl2 = diffLineMarkerRenderer.myResolved;
        }
        if ((n5 & 0x100) != 0) {
            bl3 = diffLineMarkerRenderer.myResolved;
        }
        if ((n5 & 0x200) != 0) {
            bl4 = false;
        }
        diffLineMarkerRenderer.drawMarker(editor, graphics2D, n, n2, n3, n4, bl, bl2, bl3, bl4);
    }

    @Override
    @NotNull
    public LineMarkerRendererEx.Position getPosition() {
        return LineMarkerRendererEx.Position.CUSTOM;
    }

    public DiffLineMarkerRenderer(@NotNull RangeHighlighter myHighlighter, @NotNull TextDiffType myDiffType, boolean myIgnoredFoldingOutline, boolean myResolved, boolean myExcluded, boolean myHideWithoutLineNumbers, boolean myEmptyRange, boolean myFirstLine, boolean myLastLine) {
        Intrinsics.checkParameterIsNotNull((Object)myHighlighter, (String)"myHighlighter");
        Intrinsics.checkParameterIsNotNull((Object)myDiffType, (String)"myDiffType");
        this.myHighlighter = myHighlighter;
        this.myDiffType = myDiffType;
        this.myIgnoredFoldingOutline = myIgnoredFoldingOutline;
        this.myResolved = myResolved;
        this.myExcluded = myExcluded;
        this.myHideWithoutLineNumbers = myHideWithoutLineNumbers;
        this.myEmptyRange = myEmptyRange;
        this.myFirstLine = myFirstLine;
        this.myLastLine = myLastLine;
    }
}

