/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBList;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsCompareWithBranchAction<T extends Repository>
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)DvcsCompareWithBranchAction.class.getName());

    public void actionPerformed(@NotNull AnActionEvent event) {
        String currentBranchName;
        if (event == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile file2 = DvcsCompareWithBranchAction.getAffectedFile(event);
        Repository repository = (Repository)ObjectUtils.assertNotNull(this.getRepositoryManager(project).getRepositoryForFile(file2));
        assert (!repository.isFresh());
        String presentableRevisionName = currentBranchName = repository.getCurrentBranchName();
        if (currentBranchName == null) {
            String currentRevision = (String)ObjectUtils.assertNotNull((Object)repository.getCurrentRevision());
            presentableRevisionName = DvcsUtil.getShortHash(currentRevision);
        }
        List<String> branchNames = this.getBranchNamesExceptCurrent(repository);
        JBList list2 = new JBList(branchNames);
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle("Select branch to compare").setItemChoosenCallback((Runnable)new OnBranchChooseRunnable(project, file2, presentableRevisionName, (JList)list2)).setAutoselectOnMouseMove(true).setFilteringEnabled(o -> o.toString()).createPopup().showCenteredInCurrentWindow(project);
    }

    @NotNull
    protected abstract List<String> getBranchNamesExceptCurrent(@NotNull T var1);

    private static VirtualFile getAffectedFile(@NotNull AnActionEvent event) {
        if (event == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(1);
        }
        Object[] vFiles = (VirtualFile[])event.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        assert (vFiles != null && vFiles.length == 1 && vFiles[0] != null) : "Illegal virtual files selected: " + Arrays.toString(vFiles);
        return vFiles[0];
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(2);
        }
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        VirtualFile file2 = (VirtualFile)UtilKt.getIfSingle((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM)));
        presentation.setVisible(project != null);
        presentation.setEnabled(project != null && file2 != null && this.isEnabled(this.getRepositoryManager(project).getRepositoryForFileQuick(file2)));
    }

    private boolean isEnabled(@Nullable T repository) {
        return repository != null && !repository.isFresh() && !this.noBranchesToCompare(repository);
    }

    @NotNull
    protected abstract AbstractRepositoryManager<T> getRepositoryManager(@NotNull Project var1);

    protected abstract boolean noBranchesToCompare(@NotNull T var1);

    @NotNull
    protected abstract Collection<Change> getDiffChanges(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull String var3) throws VcsException;

    private void showDiffWithBranchUnderModalProgress(final @NotNull Project project, final @NotNull VirtualFile file2, final @NotNull String head, final @NotNull String compare) {
        if (project == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(4);
        }
        if (head == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(5);
        }
        if (compare == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(6);
        }
        new Task.Backgroundable(project, "Collecting Changes...", true){
            private Collection<Change> changes;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    this.changes = DvcsCompareWithBranchAction.this.getDiffChanges(project, file2, compare);
                }
                catch (VcsException e) {
                    VcsNotifier.getInstance(project).notifyImportantWarning("Couldn't compare with branch", String.format("Couldn't compare " + DvcsUtil.fileOrFolder(file2) + " [%s] with branch [%s];\n %s", file2, compare, e.getMessage()));
                }
            }

            public void onSuccess() {
                if (this.changes != null) {
                    VcsDiffUtil.showDiffFor(project, this.changes, VcsDiffUtil.getRevisionTitle(compare, false), VcsDiffUtil.getRevisionTitle(head, true), VcsUtil.getFilePath((VirtualFile)file2));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/actions/DvcsCompareWithBranchAction$1", "run"));
            }
        }.queue();
    }

    protected static String fileDoesntExistInBranchError(@NotNull VirtualFile file2, @NotNull String branchToCompare) {
        if (file2 == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(7);
        }
        if (branchToCompare == null) {
            DvcsCompareWithBranchAction.$$$reportNull$$$0(8);
        }
        return String.format("%s <code>%s</code> doesn't exist in branch <code>%s</code>", StringUtil.capitalize((String)DvcsUtil.fileOrFolder(file2)), file2.getPresentableUrl(), branchToCompare);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "head";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compare";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchToCompare";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dvcs/actions/DvcsCompareWithBranchAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getAffectedFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showDiffWithBranchUnderModalProgress";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "fileDoesntExistInBranchError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class OnBranchChooseRunnable
    implements Runnable {
        private final Project myProject;
        private final VirtualFile myFile;
        private final String myHead;
        private final JList myList;

        private OnBranchChooseRunnable(@NotNull Project project, @NotNull VirtualFile file2, @NotNull String head, JList list2) {
            if (project == null) {
                OnBranchChooseRunnable.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                OnBranchChooseRunnable.$$$reportNull$$$0(1);
            }
            if (head == null) {
                OnBranchChooseRunnable.$$$reportNull$$$0(2);
            }
            if (list2 == null) {
                OnBranchChooseRunnable.$$$reportNull$$$0(3);
            }
            this.myProject = project;
            this.myFile = file2;
            this.myHead = head;
            this.myList = list2;
        }

        @Override
        public void run() {
            Object selectedValue = this.myList.getSelectedValue();
            if (selectedValue == null) {
                LOG.error("Selected value is unexpectedly null");
                return;
            }
            DvcsCompareWithBranchAction.this.showDiffWithBranchUnderModalProgress(this.myProject, this.myFile, this.myHead, selectedValue.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "head";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "list";
                    break;
                }
            }
            objectArray[1] = "com/intellij/dvcs/actions/DvcsCompareWithBranchAction$OnBranchChooseRunnable";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

