/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AsyncFilterRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.FilterRunner");
    private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"console filters", (int)1);
    private final EditorHyperlinkSupport myHyperlinks;
    private final Editor myEditor;
    private final Queue<HighlighterJob> myQueue = new ConcurrentLinkedQueue<HighlighterJob>();
    @NotNull
    private List<FilterResult> myResults = new ArrayList<FilterResult>();

    AsyncFilterRunner(EditorHyperlinkSupport hyperlinks, Editor editor) {
        this.myHyperlinks = hyperlinks;
        this.myEditor = editor;
    }

    void highlightHyperlinks(Filter customFilter, int startLine, int endLine) {
        if (endLine < 0) {
            return;
        }
        this.myQueue.offer(new HighlighterJob(customFilter, startLine, endLine, this.myEditor.getDocument()));
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            this.runTasks();
            this.highlightAvailableResults();
        } else if (AsyncFilterRunner.isQuick(ourExecutor.submit(this::runFiltersInBackground))) {
            this.highlightAvailableResults();
        }
    }

    private void runFiltersInBackground() {
        while (true) {
            boolean finished2 = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(this::runTasks);
            if (this.hasResults()) {
                ApplicationManager.getApplication().invokeLater(this::highlightAvailableResults, ModalityState.any());
            }
            if (finished2) {
                return;
            }
            ProgressIndicatorUtils.yieldToPendingWriteActions();
        }
    }

    private static boolean isQuick(Future<?> future2) {
        try {
            future2.get(5L, TimeUnit.MILLISECONDS);
            return true;
        }
        catch (TimeoutException ignored) {
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void highlightAvailableResults() {
        for (FilterResult result2 : this.takeAvailableResults()) {
            result2.applyHighlights();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasResults() {
        Queue<HighlighterJob> queue2 = this.myQueue;
        synchronized (queue2) {
            return !this.myResults.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private List<FilterResult> takeAvailableResults() {
        Queue<HighlighterJob> queue2 = this.myQueue;
        // MONITORENTER : queue2
        List<FilterResult> results = this.myResults;
        this.myResults = new ArrayList<FilterResult>();
        List<FilterResult> list2 = results;
        // MONITOREXIT : queue2
        if (list2 != null) return list2;
        AsyncFilterRunner.$$$reportNull$$$0(0);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLineResult(@Nullable FilterResult result2) {
        if (result2 == null) {
            return;
        }
        Queue<HighlighterJob> queue2 = this.myQueue;
        synchronized (queue2) {
            this.myResults.add(result2);
        }
    }

    public boolean waitForPendingFilters(long timeoutMs) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        long started = System.currentTimeMillis();
        while (true) {
            if (this.myQueue.isEmpty()) {
                this.highlightAvailableResults();
                return true;
            }
            if (this.hasResults()) {
                this.highlightAvailableResults();
                continue;
            }
            if (System.currentTimeMillis() - started > timeoutMs) {
                return false;
            }
            TimeoutUtil.sleep((long)1L);
        }
    }

    private void runTasks() {
        if (this.myEditor.isDisposed()) {
            return;
        }
        while (!this.myQueue.isEmpty()) {
            HighlighterJob highlighter = this.myQueue.peek();
            while (highlighter.hasUnprocessedLines()) {
                ProgressManager.checkCanceled();
                this.addLineResult(highlighter.analyzeNextLine());
            }
            LOG.assertTrue(highlighter == this.myQueue.remove());
        }
    }

    private static Filter.Result checkRange(Filter filter2, int endOffset, Filter.Result result2) {
        if (result2 != null) {
            for (Filter.ResultItem resultItem : result2.getResultItems()) {
                int start = resultItem.getHighlightStartOffset();
                int end = resultItem.getHighlightEndOffset();
                if (end >= start && end <= endOffset) continue;
                LOG.error("Filter returned wrong range: start=" + start + "; end=" + end + "; max=" + endOffset + "; filter=" + filter2);
            }
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/impl/AsyncFilterRunner", "takeAvailableResults"));
    }

    private class HighlighterJob {
        private final AtomicInteger startLine;
        private final int endLine;
        private final int initialMarkerOffset;
        private final RangeMarker endMarker;
        private final Filter filter;
        private final Document snapshot;

        HighlighterJob(Filter filter2, int startLine, int endLine, Document document) {
            this.startLine = new AtomicInteger(startLine);
            this.endLine = endLine;
            this.filter = filter2;
            this.initialMarkerOffset = document.getLineEndOffset(endLine);
            this.endMarker = document.createRangeMarker(this.initialMarkerOffset, this.initialMarkerOffset);
            this.snapshot = ((DocumentImpl)document).freeze();
        }

        boolean hasUnprocessedLines() {
            return !this.isOutdated() && this.startLine.get() <= this.endLine;
        }

        @Nullable
        FilterResult analyzeNextLine() {
            int line = this.startLine.get();
            Filter.Result result2 = this.analyzeLine(line);
            LOG.assertTrue(line == this.startLine.getAndIncrement());
            return result2 == null ? null : () -> {
                if (!this.isOutdated()) {
                    AsyncFilterRunner.this.myHyperlinks.highlightHyperlinks(result2, this.getOffsetDelta());
                }
            };
        }

        Filter.Result analyzeLine(int line) {
            int lineStart = this.snapshot.getLineStartOffset(line);
            if (lineStart + this.getOffsetDelta() < 0) {
                return null;
            }
            String lineText = EditorHyperlinkSupport.getLineText(this.snapshot, line, true);
            int endOffset = lineStart + lineText.length();
            return AsyncFilterRunner.checkRange(this.filter, endOffset, this.filter.applyFilter(lineText, endOffset));
        }

        boolean isOutdated() {
            return !this.endMarker.isValid() || this.endMarker.getEndOffset() == 0;
        }

        int getOffsetDelta() {
            return this.endMarker.getStartOffset() - this.initialMarkerOffset;
        }
    }

    private static interface FilterResult {
        public void applyHighlights();
    }
}

