/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.FindUtil;
import com.intellij.find.SearchReplaceComponent;
import com.intellij.find.SearchSession;
import com.intellij.find.editorHeaderActions.AddOccurrenceAction;
import com.intellij.find.editorHeaderActions.FindAllAction;
import com.intellij.find.editorHeaderActions.NextOccurrenceAction;
import com.intellij.find.editorHeaderActions.PrevOccurrenceAction;
import com.intellij.find.editorHeaderActions.RemoveOccurrenceAction;
import com.intellij.find.editorHeaderActions.RestorePreviousSettingsAction;
import com.intellij.find.editorHeaderActions.SelectAllAction;
import com.intellij.find.editorHeaderActions.StatusTextAction;
import com.intellij.find.editorHeaderActions.SwitchToFind;
import com.intellij.find.editorHeaderActions.SwitchToReplace;
import com.intellij.find.editorHeaderActions.ToggleAnywhereAction;
import com.intellij.find.editorHeaderActions.ToggleExceptCommentsAction;
import com.intellij.find.editorHeaderActions.ToggleExceptCommentsAndLiteralsAction;
import com.intellij.find.editorHeaderActions.ToggleExceptLiteralsAction;
import com.intellij.find.editorHeaderActions.ToggleInCommentsAction;
import com.intellij.find.editorHeaderActions.ToggleInLiteralsOnlyAction;
import com.intellij.find.editorHeaderActions.ToggleMatchCase;
import com.intellij.find.editorHeaderActions.TogglePreserveCaseAction;
import com.intellij.find.editorHeaderActions.ToggleRegex;
import com.intellij.find.editorHeaderActions.ToggleSelectionOnlyAction;
import com.intellij.find.editorHeaderActions.ToggleWholeWordsOnlyAction;
import com.intellij.find.impl.livePreview.LivePreviewController;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.ex.DefaultCustomComponentAction;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.EditorFactoryAdapter;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorSearchSession
implements SearchSession,
DataProvider,
SelectionListener,
SearchResults.SearchResultsListener,
SearchReplaceComponent.Listener {
    public static final DataKey<EditorSearchSession> SESSION_KEY = DataKey.create((String)"EditorSearchSession");
    private final Editor myEditor;
    private final LivePreviewController myLivePreviewController;
    private final SearchResults mySearchResults;
    @NotNull
    private final FindModel myFindModel;
    private final SearchReplaceComponent myComponent;
    private final RangeMarker myStartSessionSelectionMarker;
    private final RangeMarker myStartSessionCaretMarker;
    private final LinkLabel<Object> myClickToHighlightLabel;
    private final Disposable myDisposable;

    public EditorSearchSession(@NotNull Editor editor, Project project) {
        if (editor == null) {
            EditorSearchSession.$$$reportNull$$$0(0);
        }
        this(editor, project, EditorSearchSession.createDefaultFindModel(project, editor));
    }

    public EditorSearchSession(@NotNull Editor editor, Project project, @NotNull FindModel findModel) {
        if (editor == null) {
            EditorSearchSession.$$$reportNull$$$0(1);
        }
        if (findModel == null) {
            EditorSearchSession.$$$reportNull$$$0(2);
        }
        this.myClickToHighlightLabel = new LinkLabel("Click to highlight", null, (__, ___) -> {
            this.setMatchesLimit(Integer.MAX_VALUE);
            this.updateResults(true);
        });
        this.myDisposable = Disposer.newDisposable((String)EditorSearchSession.class.getName());
        assert (!editor.isDisposed());
        this.myClickToHighlightLabel.setVisible(false);
        this.myFindModel = findModel;
        this.myEditor = editor;
        this.myStartSessionSelectionMarker = this.myEditor.getDocument().createRangeMarker(this.myEditor.getSelectionModel().getSelectionStart(), this.myEditor.getSelectionModel().getSelectionEnd());
        this.myStartSessionCaretMarker = this.myEditor.getDocument().createRangeMarker(this.myEditor.getCaretModel().getOffset(), this.myEditor.getCaretModel().getOffset());
        this.mySearchResults = new SearchResults(this.myEditor, project);
        this.myLivePreviewController = new LivePreviewController(this.mySearchResults, this, this.myDisposable);
        this.myComponent = SearchReplaceComponent.buildFor(project, this.myEditor.getContentComponent()).addPrimarySearchActions(new AnAction[]{new PrevOccurrenceAction(), new NextOccurrenceAction(), new FindAllAction(), new Separator(), new AddOccurrenceAction(), new RemoveOccurrenceAction(), new SelectAllAction(), new Separator()}).addSecondarySearchActions(new AnAction[]{new ToggleAnywhereAction(), new ToggleInCommentsAction(), new ToggleInLiteralsOnlyAction(), new ToggleExceptCommentsAction(), new ToggleExceptLiteralsAction(), new ToggleExceptCommentsAndLiteralsAction()}).addExtraSearchActions(new AnAction[]{new ToggleMatchCase(), new ToggleWholeWordsOnlyAction(), new ToggleRegex(), new StatusTextAction(), new DefaultCustomComponentAction(this.myClickToHighlightLabel)}).addSearchFieldActions(new RestorePreviousSettingsAction()).addPrimaryReplaceActions(new AnAction[]{new ReplaceAction(), new ReplaceAllAction(), new ExcludeAction()}).addExtraReplaceAction(new AnAction[]{new TogglePreserveCaseAction(), new ToggleSelectionOnlyAction()}).addReplaceFieldActions(new AnAction[]{new PrevOccurrenceAction(false), new NextOccurrenceAction(false)}).withDataProvider(this).withCloseAction(this::close).withReplaceAction(this::replaceCurrent).withSecondarySearchActionsIsModifiedGetter(() -> this.myFindModel.getSearchContext() != FindModel.SearchContext.ANY).build();
        this.myComponent.addListener(this);
        new UiNotifyConnector((Component)this.myComponent, new Activatable(){

            public void showNotify() {
                EditorSearchSession.this.initLivePreview();
            }

            public void hideNotify() {
                EditorSearchSession.this.myLivePreviewController.off();
                EditorSearchSession.this.mySearchResults.removeListener(EditorSearchSession.this);
            }
        });
        new SwitchToFind(this.getComponent());
        new SwitchToReplace(this.getComponent());
        this.myFindModel.addObserver(findModel1 -> {
            String stringToFind;
            if (editor == null) {
                EditorSearchSession.$$$reportNull$$$0(11);
            }
            if (!EditorSearchSession.wholeWordsApplicable(stringToFind = this.myFindModel.getStringToFind())) {
                this.myFindModel.setWholeWordsOnly(false);
            }
            this.updateUIWithFindModel();
            this.mySearchResults.clear();
            this.updateResults(true);
            FindUtil.updateFindInFileModel(this.getProject(), this.myFindModel, !ConsoleViewUtil.isConsoleViewEditor(editor));
        });
        this.updateUIWithFindModel();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.initLivePreview();
        }
        this.updateMultiLineStateIfNeed();
        EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new EditorFactoryAdapter(){

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (event.getEditor() == EditorSearchSession.this.myEditor) {
                    Disposer.dispose((Disposable)EditorSearchSession.this.myDisposable);
                    EditorSearchSession.this.myLivePreviewController.dispose();
                    EditorSearchSession.this.myStartSessionSelectionMarker.dispose();
                    EditorSearchSession.this.myStartSessionCaretMarker.dispose();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/find/EditorSearchSession$2", "editorReleased"));
            }
        }, this.myDisposable);
    }

    @Nullable
    public static EditorSearchSession get(@Nullable Editor editor) {
        JComponent headerComponent = editor != null ? editor.getHeaderComponent() : null;
        SearchReplaceComponent searchReplaceComponent = (SearchReplaceComponent)ObjectUtils.tryCast((Object)headerComponent, SearchReplaceComponent.class);
        return searchReplaceComponent != null ? (EditorSearchSession)SESSION_KEY.getData((DataProvider)searchReplaceComponent) : null;
    }

    @NotNull
    public static EditorSearchSession start(@NotNull Editor editor, @Nullable Project project) {
        if (editor == null) {
            EditorSearchSession.$$$reportNull$$$0(3);
        }
        EditorSearchSession session2 = new EditorSearchSession(editor, project);
        editor.setHeaderComponent((JComponent)session2.getComponent());
        EditorSearchSession editorSearchSession = session2;
        if (editorSearchSession == null) {
            EditorSearchSession.$$$reportNull$$$0(4);
        }
        return editorSearchSession;
    }

    @NotNull
    public static EditorSearchSession start(@NotNull Editor editor, @NotNull FindModel findModel, @Nullable Project project) {
        if (editor == null) {
            EditorSearchSession.$$$reportNull$$$0(5);
        }
        if (findModel == null) {
            EditorSearchSession.$$$reportNull$$$0(6);
        }
        EditorSearchSession session2 = new EditorSearchSession(editor, project, findModel);
        editor.setHeaderComponent((JComponent)session2.getComponent());
        EditorSearchSession editorSearchSession = session2;
        if (editorSearchSession == null) {
            EditorSearchSession.$$$reportNull$$$0(7);
        }
        return editorSearchSession;
    }

    @Override
    @NotNull
    public SearchReplaceComponent getComponent() {
        SearchReplaceComponent searchReplaceComponent = this.myComponent;
        if (searchReplaceComponent == null) {
            EditorSearchSession.$$$reportNull$$$0(8);
        }
        return searchReplaceComponent;
    }

    public Project getProject() {
        return this.myComponent.getProject();
    }

    @NotNull
    private static FindModel createDefaultFindModel(Project project, Editor editor) {
        String selectedText;
        FindModel findModel = new FindModel();
        findModel.copyFrom(FindManager.getInstance((Project)project).getFindInFileModel());
        if (editor.getSelectionModel().hasSelection() && (selectedText = editor.getSelectionModel().getSelectedText()) != null) {
            findModel.setStringToFind(selectedText);
        }
        findModel.setPromptOnReplace(false);
        FindModel findModel2 = findModel;
        if (findModel2 == null) {
            EditorSearchSession.$$$reportNull$$$0(9);
        }
        return findModel2;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (SearchSession.KEY.is(dataId)) {
            return this;
        }
        if (SESSION_KEY.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.is(dataId)) {
            return this.myEditor;
        }
        return null;
    }

    @Override
    public void searchResultsUpdated(SearchResults sr) {
        if (sr.getFindModel() == null) {
            return;
        }
        if (this.myComponent.getSearchTextComponent().getText().isEmpty()) {
            this.updateUIWithEmptyResults();
        } else {
            int matches = sr.getMatchesCount();
            boolean tooManyMatches = matches > this.mySearchResults.getMatchesLimit();
            this.myComponent.setStatusText(tooManyMatches ? ApplicationBundle.message((String)"editorsearch.toomuch", (Object[])new Object[]{this.mySearchResults.getMatchesLimit()}) : ApplicationBundle.message((String)"editorsearch.matches", (Object[])new Object[]{matches}));
            this.myClickToHighlightLabel.setVisible(tooManyMatches);
            if (!tooManyMatches && matches <= 0) {
                this.myComponent.setNotFoundBackground();
            } else {
                this.myComponent.setRegularBackground();
            }
        }
        this.myComponent.updateActions();
    }

    @Override
    public void cursorMoved() {
        this.myComponent.updateActions();
    }

    @Override
    public void updateFinished() {
    }

    @Override
    public void searchFieldDocumentChanged() {
        this.setMatchesLimit(10000);
        String text = this.myComponent.getSearchTextComponent().getText();
        this.myFindModel.setStringToFind(text);
        if (!StringUtil.isEmpty((String)text)) {
            this.updateResults(true);
        } else {
            this.nothingToSearchFor(true);
        }
        this.updateMultiLineStateIfNeed();
    }

    private void updateMultiLineStateIfNeed() {
        this.myFindModel.setMultiline(this.myComponent.getSearchTextComponent().getText().contains("\n") || this.myComponent.getReplaceTextComponent().getText().contains("\n"));
    }

    @Override
    public void replaceFieldDocumentChanged() {
        this.setMatchesLimit(10000);
        this.myFindModel.setStringToReplace(this.myComponent.getReplaceTextComponent().getText());
        this.updateMultiLineStateIfNeed();
    }

    @Override
    public void multilineStateChanged() {
        this.myFindModel.setMultiline(this.myComponent.isMultiline());
    }

    @Override
    @NotNull
    public FindModel getFindModel() {
        FindModel findModel = this.myFindModel;
        if (findModel == null) {
            EditorSearchSession.$$$reportNull$$$0(10);
        }
        return findModel;
    }

    @Override
    public boolean hasMatches() {
        return this.mySearchResults != null && this.mySearchResults.hasMatches();
    }

    @Override
    public void searchForward() {
        this.moveCursor(SearchResults.Direction.DOWN);
        this.addTextToRecent(this.myComponent.getSearchTextComponent());
    }

    @Override
    public void searchBackward() {
        this.moveCursor(SearchResults.Direction.UP);
        this.addTextToRecent(this.myComponent.getSearchTextComponent());
    }

    private void updateUIWithFindModel() {
        this.myComponent.update(this.myFindModel.getStringToFind(), this.myFindModel.getStringToReplace(), this.myFindModel.isReplaceState(), this.myFindModel.isMultiline());
        this.myLivePreviewController.setTrackingSelection(!this.myFindModel.isGlobal());
    }

    private static boolean wholeWordsApplicable(String stringToFind) {
        return !stringToFind.startsWith(" ") && !stringToFind.startsWith("\t") && !stringToFind.endsWith(" ") && !stringToFind.endsWith("\t");
    }

    private void setMatchesLimit(int value) {
        this.mySearchResults.setMatchesLimit(value);
    }

    private void replaceCurrent() {
        if (this.mySearchResults.getCursor() != null) {
            this.myLivePreviewController.performReplace();
        }
    }

    public void addTextToRecent(JTextComponent textField2) {
        this.myComponent.addTextToRecent(textField2);
    }

    public void selectionChanged(SelectionEvent e) {
        this.updateResults(false);
    }

    private void moveCursor(SearchResults.Direction direction) {
        this.myLivePreviewController.moveCursor(direction);
    }

    @Override
    public void close() {
        IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)this.myEditor.getContentComponent(), false);
        this.myLivePreviewController.dispose();
        this.myEditor.setHeaderComponent(null);
    }

    private void initLivePreview() {
        if (this.myEditor.isDisposed()) {
            return;
        }
        this.myLivePreviewController.on();
        this.myLivePreviewController.setUserActivityDelay(0);
        this.updateResults(false);
        this.myLivePreviewController.setUserActivityDelay(30);
        this.mySearchResults.addListener(this);
    }

    private void updateResults(boolean allowedToChangedEditorSelection) {
        String text = this.myFindModel.getStringToFind();
        if (text.isEmpty()) {
            this.nothingToSearchFor(allowedToChangedEditorSelection);
        } else {
            if (this.myFindModel.isRegularExpressions()) {
                try {
                    Pattern.compile(text);
                }
                catch (Exception e) {
                    this.myComponent.setNotFoundBackground();
                    this.myClickToHighlightLabel.setVisible(false);
                    this.mySearchResults.clear();
                    this.myComponent.setStatusText("Incorrect regular expression");
                    return;
                }
            }
            FindManager findManager = FindManager.getInstance((Project)this.getProject());
            if (allowedToChangedEditorSelection) {
                findManager.setFindWasPerformed();
                FindModel copy = new FindModel();
                copy.copyFrom(this.myFindModel);
                copy.setReplaceState(false);
                findManager.setFindNextModel(copy);
            }
            if (this.myLivePreviewController != null) {
                this.myLivePreviewController.updateInBackground(this.myFindModel, allowedToChangedEditorSelection);
            }
        }
    }

    private void nothingToSearchFor(boolean allowedToChangedEditorSelection) {
        this.updateUIWithEmptyResults();
        if (this.mySearchResults != null) {
            this.mySearchResults.clear();
        }
        if (allowedToChangedEditorSelection) {
            this.restoreInitialCaretPositionAndSelection();
        }
    }

    private void restoreInitialCaretPositionAndSelection() {
        int originalSelectionStart = Math.min(this.myStartSessionSelectionMarker.getStartOffset(), this.myEditor.getDocument().getTextLength());
        int originalSelectionEnd = Math.min(this.myStartSessionSelectionMarker.getEndOffset(), this.myEditor.getDocument().getTextLength());
        this.myEditor.getSelectionModel().setSelection(originalSelectionStart, originalSelectionEnd);
        this.myEditor.getCaretModel().moveToOffset(Math.min(this.myStartSessionCaretMarker.getEndOffset(), this.myEditor.getDocument().getTextLength()));
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    private void updateUIWithEmptyResults() {
        this.myComponent.setRegularBackground();
        this.myComponent.setStatusText("");
        this.myClickToHighlightLabel.setVisible(false);
    }

    public String getTextInField() {
        return this.myComponent.getSearchTextComponent().getText();
    }

    public void setTextInField(String text) {
        this.myComponent.getSearchTextComponent().setText(text);
        this.myFindModel.setStringToFind(text);
    }

    public void selectAllOccurrences() {
        FindUtil.selectSearchResultsInEditor(this.myEditor, this.mySearchResults.getOccurrences().iterator(), -1);
    }

    public void removeOccurrence() {
        this.mySearchResults.prevOccurrence(true);
    }

    public void addNextOccurrence() {
        this.mySearchResults.nextOccurrence(true);
    }

    public void clearUndoInTextFields() {
        this.myComponent.resetUndoRedoActions();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/EditorSearchSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/EditorSearchSession";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "start";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultFindModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ExcludeAction
    extends ButtonAction {
        public ExcludeAction() {
            super("", 'l');
        }

        @Override
        protected void update(@NotNull JButton button) {
            FindResult cursor;
            if (button == null) {
                ExcludeAction.$$$reportNull$$$0(0);
            }
            button.setEnabled((cursor = EditorSearchSession.this.mySearchResults.getCursor()) != null);
            button.setText(cursor != null && EditorSearchSession.this.mySearchResults.isExcluded(cursor) ? "Include" : "Exclude");
        }

        @Override
        protected void onClick() {
            EditorSearchSession.this.myLivePreviewController.exclude();
            EditorSearchSession.this.moveCursor(SearchResults.Direction.DOWN);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/find/EditorSearchSession$ExcludeAction", "update"));
        }
    }

    private class ReplaceAllAction
    extends ButtonAction {
        ReplaceAllAction() {
            super("Replace all", 'a');
        }

        @Override
        protected void update(@NotNull JButton button) {
            if (button == null) {
                ReplaceAllAction.$$$reportNull$$$0(0);
            }
            button.setEnabled(EditorSearchSession.this.mySearchResults.hasMatches());
        }

        @Override
        protected void onClick() {
            EditorSearchSession.this.myLivePreviewController.performReplaceAll();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/find/EditorSearchSession$ReplaceAllAction", "update"));
        }
    }

    private class ReplaceAction
    extends ButtonAction {
        ReplaceAction() {
            super("Replace", 'p');
        }

        @Override
        protected void update(@NotNull JButton button) {
            if (button == null) {
                ReplaceAction.$$$reportNull$$$0(0);
            }
            button.setEnabled(EditorSearchSession.this.mySearchResults.hasMatches());
        }

        @Override
        protected void onClick() {
            EditorSearchSession.this.replaceCurrent();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/find/EditorSearchSession$ReplaceAction", "update"));
        }
    }

    private static abstract class ButtonAction
    extends DumbAwareAction
    implements CustomComponentAction,
    ActionListener {
        private final String myTitle;
        private final char myMnemonic;

        ButtonAction(@NotNull String title, char mnemonic) {
            if (title == null) {
                ButtonAction.$$$reportNull$$$0(0);
            }
            this.myTitle = title;
            this.myMnemonic = mnemonic;
        }

        public JComponent createCustomComponent(Presentation presentation) {
            JButton button = new JButton(this.myTitle);
            button.setFocusable(false);
            if (!UISettings.getInstance().getDisableMnemonicsInControls()) {
                button.setMnemonic(this.myMnemonic);
            }
            button.addActionListener(this);
            return button;
        }

        public final void update(AnActionEvent e) {
            JButton button = (JButton)e.getPresentation().getClientProperty("customComponent");
            if (button != null) {
                this.update(button);
            }
        }

        public final void actionPerformed(AnActionEvent e) {
            this.onClick();
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            this.onClick();
        }

        protected abstract void update(@NotNull JButton var1);

        protected abstract void onClick();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/find/EditorSearchSession$ButtonAction", "<init>"));
        }
    }
}

