/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.FindPopupPanel;
import com.intellij.find.impl.FindUIHelper;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FindPopupDirectoryChooser
extends JPanel {
    @NotNull
    private final FindUIHelper myHelper;
    @NotNull
    private final Project myProject;
    @NotNull
    private final FindPopupPanel myFindPopupPanel;
    @NotNull
    private final ComboBox<String> myDirectoryComboBox;

    FindPopupDirectoryChooser(@NotNull FindPopupPanel panel2) {
        if (panel2 == null) {
            FindPopupDirectoryChooser.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myHelper = panel2.getHelper();
        this.myProject = panel2.getProject();
        this.myFindPopupPanel = panel2;
        this.myDirectoryComboBox = new ComboBox(200);
        this.myDirectoryComboBox.setEditable(true);
        Component editorComponent = this.myDirectoryComboBox.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextField) {
            JTextField field = (JTextField)editorComponent;
            field.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    FindPopupDirectoryChooser.this.myFindPopupPanel.scheduleResultsUpdate();
                }
            });
            field.setColumns(40);
        }
        this.myDirectoryComboBox.setMaximumRowCount(8);
        ActionListener restartSearchListener = e -> this.myFindPopupPanel.scheduleResultsUpdate();
        this.myDirectoryComboBox.addActionListener(restartSearchListener);
        FixedSizeButton mySelectDirectoryButton = new FixedSizeButton(this.myDirectoryComboBox);
        ComponentWithBrowseButton.MyDoClickAction.addTo((FixedSizeButton)mySelectDirectoryButton, this.myDirectoryComboBox);
        mySelectDirectoryButton.setMargin((Insets)JBUI.emptyInsets());
        mySelectDirectoryButton.addActionListener(__ -> {
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            descriptor.setForcedToUseIdeaFileChooser(true);
            this.myFindPopupPanel.getCanClose().set(false);
            FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myProject, null, null, (Consumer)new FileChooser.FileChooserConsumer(){

                public void consume(List<VirtualFile> files2) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        FindPopupDirectoryChooser.this.myFindPopupPanel.getCanClose().set(true);
                        IdeFocusManager.getInstance((Project)FindPopupDirectoryChooser.this.myProject).requestFocus(FindPopupDirectoryChooser.this.myDirectoryComboBox.getEditor().getEditorComponent(), true);
                        FindPopupDirectoryChooser.this.myHelper.getModel().setDirectoryName(((VirtualFile)files2.get(0)).getPresentableUrl());
                        FindPopupDirectoryChooser.this.myDirectoryComboBox.getEditor().setItem(((VirtualFile)files2.get(0)).getPresentableUrl());
                    });
                }

                public void cancelled() {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        FindPopupDirectoryChooser.this.myFindPopupPanel.getCanClose().set(true);
                        IdeFocusManager.getInstance((Project)FindPopupDirectoryChooser.this.myProject).requestFocus(FindPopupDirectoryChooser.this.myDirectoryComboBox.getEditor().getEditorComponent(), true);
                    });
                }
            });
        });
        MyRecursiveDirectoryAction recursiveDirectoryAction = new MyRecursiveDirectoryAction();
        int mnemonicModifiers = SystemInfo.isMac ? 640 : 512;
        recursiveDirectoryAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(89, mnemonicModifiers)), (JComponent)((Object)this.myFindPopupPanel));
        this.add((Component)this.myDirectoryComboBox, "Center");
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2));
        buttonsPanel.add((Component)mySelectDirectoryButton);
        buttonsPanel.add(FindPopupPanel.createToolbar(new AnAction[]{recursiveDirectoryAction}).getComponent());
        this.add((Component)buttonsPanel, "East");
    }

    void initByModel(@NotNull FindModel findModel) {
        if (findModel == null) {
            FindPopupDirectoryChooser.$$$reportNull$$$0(1);
        }
        String directoryName = findModel.getDirectoryName();
        List<String> strings = FindInProjectSettings.getInstance(this.myProject).getRecentDirectories();
        if (this.myDirectoryComboBox.getItemCount() > 0) {
            this.myDirectoryComboBox.removeAllItems();
        }
        if (directoryName != null && !directoryName.isEmpty()) {
            if (strings.contains(directoryName)) {
                strings.remove(directoryName);
            }
            this.myDirectoryComboBox.addItem((Object)directoryName);
        }
        for (int i = strings.size() - 1; i >= 0; --i) {
            this.myDirectoryComboBox.addItem((Object)strings.get(i));
        }
        if (this.myDirectoryComboBox.getItemCount() == 0) {
            this.myDirectoryComboBox.addItem((Object)"");
        }
    }

    @NotNull
    public ComboBox getComboBox() {
        ComboBox<String> comboBox = this.myDirectoryComboBox;
        if (comboBox == null) {
            FindPopupDirectoryChooser.$$$reportNull$$$0(2);
        }
        return comboBox;
    }

    @NotNull
    public String getDirectory() {
        String string = (String)this.myDirectoryComboBox.getEditor().getItem();
        if (string == null) {
            FindPopupDirectoryChooser.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public ValidationInfo validate(@NotNull FindModel model) {
        VirtualFile directory;
        if (model == null) {
            FindPopupDirectoryChooser.$$$reportNull$$$0(4);
        }
        if ((directory = FindInProjectUtil.getDirectory(model)) == null) {
            return new ValidationInfo(FindBundle.message("find.directory.not.found.error", this.getDirectory()), this.myDirectoryComboBox);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/FindPopupDirectoryChooser";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/FindPopupDirectoryChooser";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComboBox";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initByModel";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRecursiveDirectoryAction
    extends ToggleAction {
        MyRecursiveDirectoryAction() {
            super(FindBundle.message("find.scope.directory.recursive.checkbox", new Object[0]), "Recursively", AllIcons.General.Recursive);
        }

        public boolean isSelected(AnActionEvent e) {
            return FindPopupDirectoryChooser.this.myHelper.getModel().isWithSubdirectories();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            FindPopupDirectoryChooser.this.myHelper.getModel().setWithSubdirectories(state);
            FindPopupDirectoryChooser.this.myFindPopupPanel.scheduleResultsUpdate();
        }
    }
}

