/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CopyPasteDelegator
implements CopyPasteSupport {
    private static final ExtensionPointName<PasteProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.filePasteProvider");
    public static final Key<Boolean> SHOW_CHOOSER_KEY = Key.create((String)"show.dirs.chooser");
    private final Project myProject;
    private final JComponent myKeyReceiver;
    private final MyEditable myEditable;

    public CopyPasteDelegator(Project project, JComponent keyReceiver) {
        this.myProject = project;
        this.myKeyReceiver = keyReceiver;
        this.myEditable = new MyEditable();
    }

    @NotNull
    protected abstract PsiElement[] getSelectedElements();

    @NotNull
    private PsiElement[] getValidSelectedElements() {
        PsiElement[] selectedElements;
        for (PsiElement element : selectedElements = this.getSelectedElements()) {
            if (element != null && element.isValid()) continue;
            if (PsiElement.EMPTY_ARRAY == null) {
                CopyPasteDelegator.$$$reportNull$$$0(0);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (selectedElements == null) {
            CopyPasteDelegator.$$$reportNull$$$0(1);
        }
        return selectedElements;
    }

    private void updateView() {
        this.myKeyReceiver.repaint();
    }

    public CopyProvider getCopyProvider() {
        return this.myEditable;
    }

    public CutProvider getCutProvider() {
        return this.myEditable;
    }

    public PasteProvider getPasteProvider() {
        return this.myEditable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/CopyPasteDelegator", "getValidSelectedElements"));
    }

    private class MyEditable
    implements CutProvider,
    CopyProvider,
    PasteProvider {
        private MyEditable() {
        }

        public void performCopy(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(0);
            }
            PsiElement[] elements = CopyPasteDelegator.this.getValidSelectedElements();
            PsiCopyPasteManager.getInstance().setElements(elements, true);
            CopyPasteDelegator.this.updateView();
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            PsiElement[] elements;
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(1);
            }
            return CopyHandler.canCopy(elements = CopyPasteDelegator.this.getValidSelectedElements()) || PsiCopyPasteManager.asFileList(elements) != null;
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void performCut(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(3);
            }
            PsiElement[] elements = CopyPasteDelegator.this.getValidSelectedElements();
            if (MoveHandler.adjustForMove(CopyPasteDelegator.this.myProject, elements, null) == null) {
                return;
            }
            PsiCopyPasteManager.getInstance().setElements(elements, false);
            CopyPasteDelegator.this.updateView();
        }

        public boolean isCutEnabled(@NotNull DataContext dataContext) {
            PsiElement[] elements;
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(4);
            }
            return (elements = CopyPasteDelegator.this.getValidSelectedElements()).length != 0 && MoveHandler.canMove(elements, null);
        }

        public boolean isCutVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(5);
            }
            return true;
        }

        public void performPaste(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(6);
            }
            if (!this.performDefaultPaste(dataContext)) {
                for (PasteProvider provider : (PasteProvider[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
                    if (!provider.isPasteEnabled(dataContext)) continue;
                    provider.performPaste(dataContext);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean performDefaultPaste(DataContext dataContext) {
            block6: {
                boolean[] isCopied = new boolean[1];
                PsiElement[] elements = PsiCopyPasteManager.getInstance().getElements(isCopied);
                if (elements == null) {
                    return false;
                }
                DumbService.getInstance((Project)CopyPasteDelegator.this.myProject).setAlternativeResolveEnabled(true);
                try {
                    Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
                    PsiElement target2 = this.getPasteTarget(dataContext, module);
                    if (isCopied[0]) {
                        TransactionGuard.getInstance().submitTransactionAndWait(() -> this.pasteAfterCopy(elements, module, target2, true));
                        break block6;
                    }
                    if (MoveHandler.canMove(elements, target2)) {
                        TransactionGuard.getInstance().submitTransactionAndWait(() -> this.pasteAfterCut(dataContext, elements, target2));
                        break block6;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    DumbService.getInstance((Project)CopyPasteDelegator.this.myProject).setAlternativeResolveEnabled(false);
                    CopyPasteDelegator.this.updateView();
                }
            }
            return true;
        }

        private PsiElement getPasteTarget(@NotNull DataContext dataContext, @Nullable Module module) {
            PsiDirectory[] directories;
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(7);
            }
            PsiElement target2 = (PsiElement)LangDataKeys.PASTE_TARGET_PSI_ELEMENT.getData(dataContext);
            if (module != null && target2 instanceof PsiDirectoryContainer && (directories = ((PsiDirectoryContainer)target2).getDirectories(GlobalSearchScope.moduleScope((Module)module))).length == 1) {
                return directories[0];
            }
            return target2;
        }

        @Nullable
        private PsiDirectory getTargetDirectory(@Nullable Module module, @Nullable PsiElement target2) {
            PsiFile containingFile;
            PsiDirectory targetDirectory;
            PsiDirectory psiDirectory = targetDirectory = target2 instanceof PsiDirectory ? (PsiDirectory)target2 : null;
            if (targetDirectory == null && target2 instanceof PsiDirectoryContainer) {
                PsiDirectory[] directories;
                PsiDirectory[] psiDirectoryArray = directories = module == null ? ((PsiDirectoryContainer)target2).getDirectories() : ((PsiDirectoryContainer)target2).getDirectories(GlobalSearchScope.moduleScope((Module)module));
                if (directories.length > 0) {
                    targetDirectory = directories[0];
                    targetDirectory.putCopyableUserData(SHOW_CHOOSER_KEY, (Object)(directories.length > 1 ? 1 : 0));
                }
            }
            if (targetDirectory == null && target2 != null && (containingFile = target2.getContainingFile()) != null) {
                targetDirectory = containingFile.getContainingDirectory();
            }
            return targetDirectory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void pasteAfterCopy(PsiElement[] elements, Module module, PsiElement target2, boolean tryFromFiles) {
            PsiDirectory targetDirectory = elements.length == 1 && elements[0] == target2 ? null : this.getTargetDirectory(module, target2);
            try {
                List<File> files2;
                if (CopyHandler.canCopy(elements)) {
                    CopyHandler.doCopy(elements, targetDirectory);
                } else if (tryFromFiles && (files2 = PsiCopyPasteManager.asFileList(elements)) != null) {
                    PsiManager manager = elements[0].getManager();
                    PsiFileSystemItem[] items = (PsiFileSystemItem[])files2.stream().map(file2 -> LocalFileSystem.getInstance().findFileByIoFile(file2)).map(file2 -> {
                        if (file2 != null) {
                            return file2.isDirectory() ? manager.findDirectory(file2) : manager.findFile(file2);
                        }
                        return null;
                    }).filter(file2 -> file2 != null).toArray(PsiFileSystemItem[]::new);
                    this.pasteAfterCopy((PsiElement[])items, module, target2, false);
                }
            }
            finally {
                if (targetDirectory != null) {
                    targetDirectory.putCopyableUserData(SHOW_CHOOSER_KEY, null);
                }
            }
        }

        private void pasteAfterCut(DataContext dataContext, PsiElement[] elements, PsiElement target2) {
            MoveHandler.doMove(CopyPasteDelegator.this.myProject, elements, target2, dataContext, new MoveCallback(){

                @Override
                public void refactoringCompleted() {
                    PsiCopyPasteManager.getInstance().clear();
                }
            });
        }

        public boolean isPastePossible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(8);
            }
            return true;
        }

        public boolean isPasteEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyEditable.$$$reportNull$$$0(9);
            }
            if (this.isDefaultPasteEnabled(dataContext)) {
                return true;
            }
            for (PasteProvider provider : (PasteProvider[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
                if (!provider.isPasteEnabled(dataContext)) continue;
                return true;
            }
            return false;
        }

        private boolean isDefaultPasteEnabled(DataContext dataContext) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return false;
            }
            if (DumbService.isDumb((Project)project)) {
                return false;
            }
            Object target2 = LangDataKeys.PASTE_TARGET_PSI_ELEMENT.getData(dataContext);
            if (target2 == null) {
                return false;
            }
            PsiElement[] elements = PsiCopyPasteManager.getInstance().getElements(new boolean[]{false});
            if (elements == null) {
                return false;
            }
            for (PsiElement element : elements) {
                PsiManager manager = element.getManager();
                if (manager != null && manager.getProject() == project) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "dataContext";
            objectArray2[1] = "com/intellij/ide/CopyPasteDelegator$MyEditable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performCopy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyEnabled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCopyVisible";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performCut";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCutEnabled";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isCutVisible";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "performPaste";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPasteTarget";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPastePossible";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPasteEnabled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

