/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.GotoFileItemProvider;
import com.intellij.ide.util.gotoByName.GotoFileModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DirectoryPathMatcher {
    @NotNull
    private final GotoFileModel myModel;
    @Nullable
    private final List<Pair<VirtualFile, String>> myFiles;
    @NotNull
    private final String myPattern;

    private DirectoryPathMatcher(@NotNull GotoFileModel model, @Nullable List<Pair<VirtualFile, String>> files2, @NotNull String pattern) {
        if (model == null) {
            DirectoryPathMatcher.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            DirectoryPathMatcher.$$$reportNull$$$0(1);
        }
        this.myModel = model;
        this.myFiles = files2;
        this.myPattern = pattern;
    }

    @Nullable
    static DirectoryPathMatcher root(@NotNull GotoFileModel model, @NotNull String pattern) {
        if (model == null) {
            DirectoryPathMatcher.$$$reportNull$$$0(2);
        }
        if (pattern == null) {
            DirectoryPathMatcher.$$$reportNull$$$0(3);
        }
        DirectoryPathMatcher matcher = new DirectoryPathMatcher(model, null, "");
        for (int i = 0; i < pattern.length(); ++i) {
            if ((matcher = matcher.appendChar(pattern.charAt(i))) != null) continue;
            return null;
        }
        return matcher;
    }

    @Nullable
    DirectoryPathMatcher appendChar(char c) {
        String nextPattern = this.myPattern + c;
        if (c == '*' || c == '/' || c == ' ') {
            return new DirectoryPathMatcher(this.myModel, this.myFiles, nextPattern);
        }
        List<Pair<VirtualFile, String>> files2 = this.getMatchingRoots();
        ArrayList<Pair<VirtualFile, String>> nextRoots = new ArrayList<Pair<VirtualFile, String>>();
        MinusculeMatcher matcher = GotoFileItemProvider.getQualifiedNameMatcher(nextPattern);
        for (Pair<VirtualFile, String> pair : files2) {
            if (DirectoryPathMatcher.containsChar((String)pair.second, c) && matcher.matches((String)pair.second)) {
                nextRoots.add(pair);
                continue;
            }
            this.processProjectFilesUnder((VirtualFile)pair.first, (Processor<VirtualFile>)((Processor)sub -> {
                if (!sub.isDirectory()) {
                    return false;
                }
                if (!DirectoryPathMatcher.containsChar(sub.getName(), c)) {
                    return true;
                }
                String fullName = this.myModel.getFullName((VirtualFile)sub);
                if (fullName == null) {
                    return true;
                }
                if (matcher.matches(fullName = FileUtil.toSystemIndependentName((String)fullName))) {
                    nextRoots.add(Pair.create((Object)sub, (Object)fullName));
                    return false;
                }
                return true;
            }));
        }
        return nextRoots.isEmpty() ? null : new DirectoryPathMatcher(this.myModel, nextRoots, nextPattern);
    }

    @Nullable
    Set<String> findFileNamesMatchingIfCheap(char nextLetter, MinusculeMatcher matcher) {
        List<Pair<VirtualFile, String>> files2 = this.getMatchingRoots();
        HashSet<String> names = new HashSet<String>();
        AtomicInteger counter = new AtomicInteger();
        BooleanSupplier tooMany = () -> counter.incrementAndGet() > 1000;
        for (Pair<VirtualFile, String> pair : files2) {
            if (DirectoryPathMatcher.containsChar((String)pair.second, nextLetter) && matcher.matches((String)pair.second)) {
                names.add(((VirtualFile)pair.first).getName());
            }
            this.processProjectFilesUnder((VirtualFile)pair.first, (Processor<VirtualFile>)((Processor)sub -> {
                counter.incrementAndGet();
                if (tooMany.getAsBoolean()) {
                    return false;
                }
                String name = sub.getName();
                if (DirectoryPathMatcher.containsChar(name, nextLetter) && matcher.matches(name)) {
                    names.add(name);
                }
                return true;
            }));
        }
        return tooMany.getAsBoolean() ? null : names;
    }

    @NotNull
    private List<Pair<VirtualFile, String>> getMatchingRoots() {
        List<Pair<VirtualFile, String>> list2 = this.myFiles != null ? this.myFiles : DirectoryPathMatcher.getProjectRoots(this.myModel);
        if (list2 == null) {
            DirectoryPathMatcher.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    GlobalSearchScope narrowDown(@NotNull GlobalSearchScope fileSearchScope) {
        if (fileSearchScope == null) {
            DirectoryPathMatcher.$$$reportNull$$$0(5);
        }
        if (this.myFiles == null) {
            GlobalSearchScope globalSearchScope = fileSearchScope;
            if (globalSearchScope == null) {
                DirectoryPathMatcher.$$$reportNull$$$0(6);
            }
            return globalSearchScope;
        }
        VirtualFile[] array = (VirtualFile[])ContainerUtil.map2Array(this.myFiles, VirtualFile.class, p -> (VirtualFile)p.first);
        GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoriesScope((Project)this.myModel.getProject(), (boolean)true, (VirtualFile[])array).intersectWith(fileSearchScope);
        if (globalSearchScope == null) {
            DirectoryPathMatcher.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    private void processProjectFilesUnder(VirtualFile root, final Processor<VirtualFile> consumer) {
        final GlobalSearchScope scope = GlobalSearchScope.allScope((Project)this.myModel.getProject());
        VfsUtilCore.visitChildrenRecursively((VirtualFile)root, (VirtualFileVisitor)new VirtualFileVisitor<Object>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return scope.contains(file2) && consumer.process((Object)file2);
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return file2 instanceof NewVirtualFile ? ((NewVirtualFile)file2).getCachedChildren() : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "file";
                objectArray2[1] = "com/intellij/ide/actions/DirectoryPathMatcher$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getChildrenIterable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean containsChar(String name, char c) {
        return StringUtil.indexOfIgnoreCase((String)name, (char)c, (int)0) >= 0;
    }

    @NotNull
    private static List<Pair<VirtualFile, String>> getProjectRoots(GotoFileModel model) {
        HashSet roots = new HashSet();
        for (Module module : ModuleManager.getInstance((Project)model.getProject()).getModules()) {
            Collections.addAll(roots, ModuleRootManager.getInstance((Module)module).getContentRoots());
            for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                if (!(entry instanceof LibraryOrSdkOrderEntry)) continue;
                Collections.addAll(roots, entry.getFiles(OrderRootType.CLASSES));
                Collections.addAll(roots, entry.getFiles(OrderRootType.SOURCES));
            }
        }
        List<Pair<VirtualFile, String>> list2 = roots.stream().map(root -> {
            VirtualFile top = model.getTopLevelRoot((VirtualFile)root);
            return top != null ? top : root;
        }).distinct().map(r -> Pair.create((Object)r, (Object)StringUtil.notNullize((String)model.getFullName((VirtualFile)r)))).collect(Collectors.toList());
        if (list2 == null) {
            DirectoryPathMatcher.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/DirectoryPathMatcher";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSearchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/DirectoryPathMatcher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchingRoots";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowDown";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "root";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "narrowDown";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

