/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class MarkExcludeRootAction
extends MarkRootActionBase {
    public MarkExcludeRootAction() {
        super(null, null, AllIcons.Modules.ExcludeRoot);
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] files2 = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (Registry.is((String)"ide.hide.excluded.files")) {
            String message = files2.length == 1 ? FileUtil.toSystemDependentName((String)files2[0].getPath()) : files2.length + " selected files";
            int rc = Messages.showOkCancelDialog((Project)((Project)e.getData(CommonDataKeys.PROJECT)), (String)this.getPromptText(message), (String)"Mark as Excluded", (Icon)Messages.getQuestionIcon());
            if (rc != 0) {
                return;
            }
        }
        super.actionPerformed(e);
    }

    protected String getPromptText(String message) {
        return "Are you sure you would like to exclude " + message + " from the project?\nYou can restore excluded directories later using the Project Structure dialog.";
    }

    @Override
    protected void modifyRoots(@NotNull VirtualFile vFile, @NotNull ContentEntry entry) {
        if (vFile == null) {
            MarkExcludeRootAction.$$$reportNull$$$0(0);
        }
        if (entry == null) {
            MarkExcludeRootAction.$$$reportNull$$$0(1);
        }
        entry.addExcludeFolder(vFile);
    }

    @Override
    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module) {
        if (selection == null) {
            MarkExcludeRootAction.$$$reportNull$$$0(2);
        }
        if (module == null) {
            MarkExcludeRootAction.$$$reportNull$$$0(3);
        }
        ModuleFileIndex index = ModuleRootManager.getInstance((Module)module).getFileIndex();
        return selection.mySelectedDirectories.stream().allMatch(file2 -> index.isInContent(file2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectView/actions/MarkExcludeRootAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "modifyRoots";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

