/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.scopeView;

import com.intellij.ide.scratch.ScratchesNamedScope;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public final class NamedScopeFilter
implements VirtualFileFilter {
    private static final Logger LOG = Logger.getInstance(NamedScopeFilter.class);
    private final NamedScopesHolder holder;
    private final NamedScope scope;

    public NamedScopeFilter(@NotNull NamedScopesHolder holder, @NotNull NamedScope scope) {
        if (holder == null) {
            NamedScopeFilter.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            NamedScopeFilter.$$$reportNull$$$0(1);
        }
        this.holder = holder;
        this.scope = scope;
    }

    @NotNull
    public String toString() {
        String string = this.scope.getName();
        if (string == null) {
            NamedScopeFilter.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean accept(VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        PackageSet set2 = this.scope.getValue();
        if (set2 == null) {
            return false;
        }
        Project project = this.holder.getProject();
        if (set2 instanceof PackageSetBase) {
            PackageSetBase base = (PackageSetBase)set2;
            return base.contains(file2, project, this.holder);
        }
        PsiFile psiFile = PackageSetBase.getPsiFile((VirtualFile)file2, (Project)project);
        return psiFile != null && set2.contains(psiFile, this.holder);
    }

    static boolean isVisible(@NotNull NamedScope scope) {
        if (scope == null) {
            NamedScopeFilter.$$$reportNull$$$0(3);
        }
        return !(scope instanceof NonProjectFilesScope) && !(scope instanceof ScratchesNamedScope) && scope != CustomScopesProviderEx.getAllScope();
    }

    @NotNull
    static Map<String, NamedScopeFilter> map(NamedScopesHolder ... holders) {
        Map<String, NamedScopeFilter> map = NamedScopeFilter.map(NamedScopeFilter::isVisible, holders);
        if (map == null) {
            NamedScopeFilter.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    static Map<String, NamedScopeFilter> map(@NotNull Predicate<NamedScope> visible, NamedScopesHolder ... holders) {
        if (visible == null) {
            NamedScopeFilter.$$$reportNull$$$0(5);
        }
        if (holders == null) {
            NamedScopeFilter.$$$reportNull$$$0(6);
        }
        LinkedHashMap<String, NamedScopeFilter> map = new LinkedHashMap<String, NamedScopeFilter>();
        for (NamedScopesHolder holder : holders) {
            for (NamedScope scope : holder.getScopes()) {
                String name = scope.getName();
                if (null == scope.getValue()) {
                    LOG.debug("ignore scope without package set: ", new Object[]{name, "; holder: ", holder});
                    continue;
                }
                if (!visible.test(scope)) {
                    LOG.debug("ignore hidden scope: ", new Object[]{name, "; holder: ", holder});
                    continue;
                }
                if (map.containsKey(name)) {
                    LOG.warn("ignore duplicated scope: " + name + "; holder: " + holder);
                    continue;
                }
                map.put(name, new NamedScopeFilter(holder, scope));
            }
        }
        LinkedHashMap<String, NamedScopeFilter> linkedHashMap = map;
        if (linkedHashMap == null) {
            NamedScopeFilter.$$$reportNull$$$0(7);
        }
        return linkedHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/scopeView/NamedScopeFilter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visible";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/scopeView/NamedScopeFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

